<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for versicherteFahrzeugeType StructType
 * @subpackage Structs
 */
class VersicherteFahrzeugeType extends AbstractStructBase
{
    /**
     * The anzahlFahrzeuge
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $anzahlFahrzeuge;
    /**
     * The versichertesFahrzeug
     * Meta information extracted from the WSDL
     * - maxOccurs: 9
     * - minOccurs: 0
     * @var \StructType\VersichertesFahrzeugType[]
     */
    public $versichertesFahrzeug;
    /**
     * Constructor method for versicherteFahrzeugeType
     * @uses VersicherteFahrzeugeType::setAnzahlFahrzeuge()
     * @uses VersicherteFahrzeugeType::setVersichertesFahrzeug()
     * @param int $anzahlFahrzeuge
     * @param \StructType\VersichertesFahrzeugType[] $versichertesFahrzeug
     */
    public function __construct($anzahlFahrzeuge = null, array $versichertesFahrzeug = array())
    {
        $this
            ->setAnzahlFahrzeuge($anzahlFahrzeuge)
            ->setVersichertesFahrzeug($versichertesFahrzeug);
    }
    /**
     * Get anzahlFahrzeuge value
     * @return int|null
     */
    public function getAnzahlFahrzeuge()
    {
        return $this->anzahlFahrzeuge;
    }
    /**
     * Set anzahlFahrzeuge value
     * @param int $anzahlFahrzeuge
     * @return \StructType\VersicherteFahrzeugeType
     */
    public function setAnzahlFahrzeuge($anzahlFahrzeuge = null)
    {
        // validation for constraint: int
        if (!is_null($anzahlFahrzeuge) && !(is_int($anzahlFahrzeuge) || ctype_digit($anzahlFahrzeuge))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anzahlFahrzeuge, true), gettype($anzahlFahrzeuge)), __LINE__);
        }
        $this->anzahlFahrzeuge = $anzahlFahrzeuge;
        return $this;
    }
    /**
     * Get versichertesFahrzeug value
     * @return \StructType\VersichertesFahrzeugType[]|null
     */
    public function getVersichertesFahrzeug()
    {
        return $this->versichertesFahrzeug;
    }
    /**
     * This method is responsible for validating the values passed to the setVersichertesFahrzeug method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVersichertesFahrzeug method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVersichertesFahrzeugForArrayConstraintsFromSetVersichertesFahrzeug(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $versicherteFahrzeugeTypeVersichertesFahrzeugItem) {
            // validation for constraint: itemType
            if (!$versicherteFahrzeugeTypeVersichertesFahrzeugItem instanceof \StructType\VersichertesFahrzeugType) {
                $invalidValues[] = is_object($versicherteFahrzeugeTypeVersichertesFahrzeugItem) ? get_class($versicherteFahrzeugeTypeVersichertesFahrzeugItem) : sprintf('%s(%s)', gettype($versicherteFahrzeugeTypeVersichertesFahrzeugItem), var_export($versicherteFahrzeugeTypeVersichertesFahrzeugItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The versichertesFahrzeug property can only contain items of type \StructType\VersichertesFahrzeugType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set versichertesFahrzeug value
     * @throws \InvalidArgumentException
     * @param \StructType\VersichertesFahrzeugType[] $versichertesFahrzeug
     * @return \StructType\VersicherteFahrzeugeType
     */
    public function setVersichertesFahrzeug(array $versichertesFahrzeug = array())
    {
        // validation for constraint: array
        if ('' !== ($versichertesFahrzeugArrayErrorMessage = self::validateVersichertesFahrzeugForArrayConstraintsFromSetVersichertesFahrzeug($versichertesFahrzeug))) {
            throw new \InvalidArgumentException($versichertesFahrzeugArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($versichertesFahrzeug) && count($versichertesFahrzeug) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 9', count($versichertesFahrzeug)), __LINE__);
        }
        $this->versichertesFahrzeug = $versichertesFahrzeug;
        return $this;
    }
    /**
     * Add item to versichertesFahrzeug value
     * @throws \InvalidArgumentException
     * @param \StructType\VersichertesFahrzeugType $item
     * @return \StructType\VersicherteFahrzeugeType
     */
    public function addToVersichertesFahrzeug(\StructType\VersichertesFahrzeugType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\VersichertesFahrzeugType) {
            throw new \InvalidArgumentException(sprintf('The versichertesFahrzeug property can only contain items of type \StructType\VersichertesFahrzeugType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($this->versichertesFahrzeug) && count($this->versichertesFahrzeug) >= 9) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 9', count($this->versichertesFahrzeug)), __LINE__);
        }
        $this->versichertesFahrzeug[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VersicherteFahrzeugeType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
