<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for vereinbarungenType StructType
 * @subpackage Structs
 */
class VereinbarungenType extends AbstractStructBase
{
    /**
     * The paketrabatt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $paketrabatt;
    /**
     * The kfzKomplettBonus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $kfzKomplettBonus;
    /**
     * The hinterlegungsverzicht
     * Meta information extracted from the WSDL
     * - documentation: Hinterlegungsverzicht gibt es nur für Motorräder.
     * - minOccurs: 0
     * @var string
     */
    public $hinterlegungsverzicht;
    /**
     * The vorgabeSonderrabatt
     * Meta information extracted from the WSDL
     * - base: xs:decimal
     * - fractionDigits: 2
     * - maxInclusive: 100
     * - minInclusive: 0
     * - minOccurs: 0
     * @var float
     */
    public $vorgabeSonderrabatt;
    /**
     * The vereinbarungenHaftpflicht
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\VereinbarungenHaftpflichtType
     */
    public $vereinbarungenHaftpflicht;
    /**
     * The vereinbarungenKasko
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\VereinbarungenKaskoType
     */
    public $vereinbarungenKasko;
    /**
     * The vereinbarungenInsassenunfall
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\VereinbarungenInsassenunfallType
     */
    public $vereinbarungenInsassenunfall;
    /**
     * The vereinbarungenRechtsschutz
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\VereinbarungenRechtsschutz
     */
    public $vereinbarungenRechtsschutz;
    /**
     * Constructor method for vereinbarungenType
     * @uses VereinbarungenType::setPaketrabatt()
     * @uses VereinbarungenType::setKfzKomplettBonus()
     * @uses VereinbarungenType::setHinterlegungsverzicht()
     * @uses VereinbarungenType::setVorgabeSonderrabatt()
     * @uses VereinbarungenType::setVereinbarungenHaftpflicht()
     * @uses VereinbarungenType::setVereinbarungenKasko()
     * @uses VereinbarungenType::setVereinbarungenInsassenunfall()
     * @uses VereinbarungenType::setVereinbarungenRechtsschutz()
     * @param string $paketrabatt
     * @param string $kfzKomplettBonus
     * @param string $hinterlegungsverzicht
     * @param float $vorgabeSonderrabatt
     * @param \StructType\VereinbarungenHaftpflichtType $vereinbarungenHaftpflicht
     * @param \StructType\VereinbarungenKaskoType $vereinbarungenKasko
     * @param \StructType\VereinbarungenInsassenunfallType $vereinbarungenInsassenunfall
     * @param \StructType\VereinbarungenRechtsschutz $vereinbarungenRechtsschutz
     */
    public function __construct($paketrabatt = null, $kfzKomplettBonus = null, $hinterlegungsverzicht = null, $vorgabeSonderrabatt = null, \StructType\VereinbarungenHaftpflichtType $vereinbarungenHaftpflicht = null, \StructType\VereinbarungenKaskoType $vereinbarungenKasko = null, \StructType\VereinbarungenInsassenunfallType $vereinbarungenInsassenunfall = null, \StructType\VereinbarungenRechtsschutz $vereinbarungenRechtsschutz = null)
    {
        $this
            ->setPaketrabatt($paketrabatt)
            ->setKfzKomplettBonus($kfzKomplettBonus)
            ->setHinterlegungsverzicht($hinterlegungsverzicht)
            ->setVorgabeSonderrabatt($vorgabeSonderrabatt)
            ->setVereinbarungenHaftpflicht($vereinbarungenHaftpflicht)
            ->setVereinbarungenKasko($vereinbarungenKasko)
            ->setVereinbarungenInsassenunfall($vereinbarungenInsassenunfall)
            ->setVereinbarungenRechtsschutz($vereinbarungenRechtsschutz);
    }
    /**
     * Get paketrabatt value
     * @return string|null
     */
    public function getPaketrabatt()
    {
        return $this->paketrabatt;
    }
    /**
     * Set paketrabatt value
     * @uses \EnumType\JaNeinType::valueIsValid()
     * @uses \EnumType\JaNeinType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paketrabatt
     * @return \StructType\VereinbarungenType
     */
    public function setPaketrabatt($paketrabatt = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JaNeinType::valueIsValid($paketrabatt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JaNeinType', is_array($paketrabatt) ? implode(', ', $paketrabatt) : var_export($paketrabatt, true), implode(', ', \EnumType\JaNeinType::getValidValues())), __LINE__);
        }
        $this->paketrabatt = $paketrabatt;
        return $this;
    }
    /**
     * Get kfzKomplettBonus value
     * @return string|null
     */
    public function getKfzKomplettBonus()
    {
        return $this->kfzKomplettBonus;
    }
    /**
     * Set kfzKomplettBonus value
     * @uses \EnumType\JaNeinType::valueIsValid()
     * @uses \EnumType\JaNeinType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $kfzKomplettBonus
     * @return \StructType\VereinbarungenType
     */
    public function setKfzKomplettBonus($kfzKomplettBonus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JaNeinType::valueIsValid($kfzKomplettBonus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JaNeinType', is_array($kfzKomplettBonus) ? implode(', ', $kfzKomplettBonus) : var_export($kfzKomplettBonus, true), implode(', ', \EnumType\JaNeinType::getValidValues())), __LINE__);
        }
        $this->kfzKomplettBonus = $kfzKomplettBonus;
        return $this;
    }
    /**
     * Get hinterlegungsverzicht value
     * @return string|null
     */
    public function getHinterlegungsverzicht()
    {
        return $this->hinterlegungsverzicht;
    }
    /**
     * Set hinterlegungsverzicht value
     * @uses \EnumType\JaNeinType::valueIsValid()
     * @uses \EnumType\JaNeinType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $hinterlegungsverzicht
     * @return \StructType\VereinbarungenType
     */
    public function setHinterlegungsverzicht($hinterlegungsverzicht = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JaNeinType::valueIsValid($hinterlegungsverzicht)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JaNeinType', is_array($hinterlegungsverzicht) ? implode(', ', $hinterlegungsverzicht) : var_export($hinterlegungsverzicht, true), implode(', ', \EnumType\JaNeinType::getValidValues())), __LINE__);
        }
        $this->hinterlegungsverzicht = $hinterlegungsverzicht;
        return $this;
    }
    /**
     * Get vorgabeSonderrabatt value
     * @return float|null
     */
    public function getVorgabeSonderrabatt()
    {
        return $this->vorgabeSonderrabatt;
    }
    /**
     * Set vorgabeSonderrabatt value
     * @param float $vorgabeSonderrabatt
     * @return \StructType\VereinbarungenType
     */
    public function setVorgabeSonderrabatt($vorgabeSonderrabatt = null)
    {
        // validation for constraint: float
        if (!is_null($vorgabeSonderrabatt) && !(is_float($vorgabeSonderrabatt) || is_numeric($vorgabeSonderrabatt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($vorgabeSonderrabatt, true), gettype($vorgabeSonderrabatt)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($vorgabeSonderrabatt) && mb_strlen(mb_substr($vorgabeSonderrabatt, mb_strpos($vorgabeSonderrabatt, '.') + 1)) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($vorgabeSonderrabatt, true), mb_strlen(mb_substr($vorgabeSonderrabatt, mb_strpos($vorgabeSonderrabatt, '.') + 1))), __LINE__);
        }
        // validation for constraint: maxInclusive(100)
        if (!is_null($vorgabeSonderrabatt) && $vorgabeSonderrabatt > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 100', var_export($vorgabeSonderrabatt, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($vorgabeSonderrabatt) && $vorgabeSonderrabatt < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($vorgabeSonderrabatt, true)), __LINE__);
        }
        $this->vorgabeSonderrabatt = $vorgabeSonderrabatt;
        return $this;
    }
    /**
     * Get vereinbarungenHaftpflicht value
     * @return \StructType\VereinbarungenHaftpflichtType|null
     */
    public function getVereinbarungenHaftpflicht()
    {
        return $this->vereinbarungenHaftpflicht;
    }
    /**
     * Set vereinbarungenHaftpflicht value
     * @param \StructType\VereinbarungenHaftpflichtType $vereinbarungenHaftpflicht
     * @return \StructType\VereinbarungenType
     */
    public function setVereinbarungenHaftpflicht(\StructType\VereinbarungenHaftpflichtType $vereinbarungenHaftpflicht = null)
    {
        $this->vereinbarungenHaftpflicht = $vereinbarungenHaftpflicht;
        return $this;
    }
    /**
     * Get vereinbarungenKasko value
     * @return \StructType\VereinbarungenKaskoType|null
     */
    public function getVereinbarungenKasko()
    {
        return $this->vereinbarungenKasko;
    }
    /**
     * Set vereinbarungenKasko value
     * @param \StructType\VereinbarungenKaskoType $vereinbarungenKasko
     * @return \StructType\VereinbarungenType
     */
    public function setVereinbarungenKasko(\StructType\VereinbarungenKaskoType $vereinbarungenKasko = null)
    {
        $this->vereinbarungenKasko = $vereinbarungenKasko;
        return $this;
    }
    /**
     * Get vereinbarungenInsassenunfall value
     * @return \StructType\VereinbarungenInsassenunfallType|null
     */
    public function getVereinbarungenInsassenunfall()
    {
        return $this->vereinbarungenInsassenunfall;
    }
    /**
     * Set vereinbarungenInsassenunfall value
     * @param \StructType\VereinbarungenInsassenunfallType $vereinbarungenInsassenunfall
     * @return \StructType\VereinbarungenType
     */
    public function setVereinbarungenInsassenunfall(\StructType\VereinbarungenInsassenunfallType $vereinbarungenInsassenunfall = null)
    {
        $this->vereinbarungenInsassenunfall = $vereinbarungenInsassenunfall;
        return $this;
    }
    /**
     * Get vereinbarungenRechtsschutz value
     * @return \StructType\VereinbarungenRechtsschutz|null
     */
    public function getVereinbarungenRechtsschutz()
    {
        return $this->vereinbarungenRechtsschutz;
    }
    /**
     * Set vereinbarungenRechtsschutz value
     * @param \StructType\VereinbarungenRechtsschutz $vereinbarungenRechtsschutz
     * @return \StructType\VereinbarungenType
     */
    public function setVereinbarungenRechtsschutz(\StructType\VereinbarungenRechtsschutz $vereinbarungenRechtsschutz = null)
    {
        $this->vereinbarungenRechtsschutz = $vereinbarungenRechtsschutz;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VereinbarungenType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
