<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for stationary StructType
 * @subpackage Structs
 */
class Stationary extends AbstractStructBase
{
    /**
     * The person
     * @var \StructType\ClaimentPerson
     */
    public $person;
    /**
     * The treatmentBegin
     * @var string
     */
    public $treatmentBegin;
    /**
     * The treatmentEnd
     * @var string
     */
    public $treatmentEnd;
    /**
     * Constructor method for stationary
     * @uses Stationary::setPerson()
     * @uses Stationary::setTreatmentBegin()
     * @uses Stationary::setTreatmentEnd()
     * @param \StructType\ClaimentPerson $person
     * @param string $treatmentBegin
     * @param string $treatmentEnd
     */
    public function __construct(\StructType\ClaimentPerson $person = null, $treatmentBegin = null, $treatmentEnd = null)
    {
        $this
            ->setPerson($person)
            ->setTreatmentBegin($treatmentBegin)
            ->setTreatmentEnd($treatmentEnd);
    }
    /**
     * Get person value
     * @return \StructType\ClaimentPerson|null
     */
    public function getPerson()
    {
        return $this->person;
    }
    /**
     * Set person value
     * @param \StructType\ClaimentPerson $person
     * @return \StructType\Stationary
     */
    public function setPerson(\StructType\ClaimentPerson $person = null)
    {
        $this->person = $person;
        return $this;
    }
    /**
     * Get treatmentBegin value
     * @return string|null
     */
    public function getTreatmentBegin()
    {
        return $this->treatmentBegin;
    }
    /**
     * Set treatmentBegin value
     * @param string $treatmentBegin
     * @return \StructType\Stationary
     */
    public function setTreatmentBegin($treatmentBegin = null)
    {
        // validation for constraint: string
        if (!is_null($treatmentBegin) && !is_string($treatmentBegin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($treatmentBegin, true), gettype($treatmentBegin)), __LINE__);
        }
        $this->treatmentBegin = $treatmentBegin;
        return $this;
    }
    /**
     * Get treatmentEnd value
     * @return string|null
     */
    public function getTreatmentEnd()
    {
        return $this->treatmentEnd;
    }
    /**
     * Set treatmentEnd value
     * @param string $treatmentEnd
     * @return \StructType\Stationary
     */
    public function setTreatmentEnd($treatmentEnd = null)
    {
        // validation for constraint: string
        if (!is_null($treatmentEnd) && !is_string($treatmentEnd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($treatmentEnd, true), gettype($treatmentEnd)), __LINE__);
        }
        $this->treatmentEnd = $treatmentEnd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Stationary
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
