<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for signDocumentsRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Lässt alle Dokumente der mitgeschickten SignGroupId unterschreiben
 * @subpackage Structs
 */
class SignDocumentsRequest extends AbstractStructBase
{
    /**
     * The login
     * @var \StructType\Login
     */
    public $login;
    /**
     * The businessCaseNumber
     * Meta information extracted from the WSDL
     * - documentation: ID des Geschäftsfalles in der TIS/eVP
     * @var int
     */
    public $businessCaseNumber;
    /**
     * The documentSignGroupId
     * Meta information extracted from the WSDL
     * - documentation: GroupId der Dokumente, die auf einmal unterschrieben werden
     * @var int
     */
    public $documentSignGroupId;
    /**
     * The signerPhone
     * Meta information extracted from the WSDL
     * - documentation: Telefonnummer, die zum Verschicken des Unterschriftenlinks verwendet wird
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $signerPhone;
    /**
     * The signerEmail
     * Meta information extracted from the WSDL
     * - documentation: Mailadresse, die zum Verschicken des Unterschriftenlinks verwendet wird
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $signerEmail;
    /**
     * The signWithATrust
     * Meta information extracted from the WSDL
     * - documentation: Legt fest, ob mit ATrust unterschrieben werden soll (Default=False)
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $signWithATrust;
    /**
     * Constructor method for signDocumentsRequest
     * @uses SignDocumentsRequest::setLogin()
     * @uses SignDocumentsRequest::setBusinessCaseNumber()
     * @uses SignDocumentsRequest::setDocumentSignGroupId()
     * @uses SignDocumentsRequest::setSignerPhone()
     * @uses SignDocumentsRequest::setSignerEmail()
     * @uses SignDocumentsRequest::setSignWithATrust()
     * @param \StructType\Login $login
     * @param int $businessCaseNumber
     * @param int $documentSignGroupId
     * @param string $signerPhone
     * @param string $signerEmail
     * @param bool $signWithATrust
     */
    public function __construct(\StructType\Login $login = null, $businessCaseNumber = null, $documentSignGroupId = null, $signerPhone = null, $signerEmail = null, $signWithATrust = null)
    {
        $this
            ->setLogin($login)
            ->setBusinessCaseNumber($businessCaseNumber)
            ->setDocumentSignGroupId($documentSignGroupId)
            ->setSignerPhone($signerPhone)
            ->setSignerEmail($signerEmail)
            ->setSignWithATrust($signWithATrust);
    }
    /**
     * Get login value
     * @return \StructType\Login|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param \StructType\Login $login
     * @return \StructType\SignDocumentsRequest
     */
    public function setLogin(\StructType\Login $login = null)
    {
        $this->login = $login;
        return $this;
    }
    /**
     * Get businessCaseNumber value
     * @return int|null
     */
    public function getBusinessCaseNumber()
    {
        return $this->businessCaseNumber;
    }
    /**
     * Set businessCaseNumber value
     * @param int $businessCaseNumber
     * @return \StructType\SignDocumentsRequest
     */
    public function setBusinessCaseNumber($businessCaseNumber = null)
    {
        // validation for constraint: int
        if (!is_null($businessCaseNumber) && !(is_int($businessCaseNumber) || ctype_digit($businessCaseNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($businessCaseNumber, true), gettype($businessCaseNumber)), __LINE__);
        }
        $this->businessCaseNumber = $businessCaseNumber;
        return $this;
    }
    /**
     * Get documentSignGroupId value
     * @return int|null
     */
    public function getDocumentSignGroupId()
    {
        return $this->documentSignGroupId;
    }
    /**
     * Set documentSignGroupId value
     * @param int $documentSignGroupId
     * @return \StructType\SignDocumentsRequest
     */
    public function setDocumentSignGroupId($documentSignGroupId = null)
    {
        // validation for constraint: int
        if (!is_null($documentSignGroupId) && !(is_int($documentSignGroupId) || ctype_digit($documentSignGroupId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($documentSignGroupId, true), gettype($documentSignGroupId)), __LINE__);
        }
        $this->documentSignGroupId = $documentSignGroupId;
        return $this;
    }
    /**
     * Get signerPhone value
     * @return string|null
     */
    public function getSignerPhone()
    {
        return $this->signerPhone;
    }
    /**
     * Set signerPhone value
     * @param string $signerPhone
     * @return \StructType\SignDocumentsRequest
     */
    public function setSignerPhone($signerPhone = null)
    {
        // validation for constraint: string
        if (!is_null($signerPhone) && !is_string($signerPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($signerPhone, true), gettype($signerPhone)), __LINE__);
        }
        $this->signerPhone = $signerPhone;
        return $this;
    }
    /**
     * Get signerEmail value
     * @return string|null
     */
    public function getSignerEmail()
    {
        return $this->signerEmail;
    }
    /**
     * Set signerEmail value
     * @param string $signerEmail
     * @return \StructType\SignDocumentsRequest
     */
    public function setSignerEmail($signerEmail = null)
    {
        // validation for constraint: string
        if (!is_null($signerEmail) && !is_string($signerEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($signerEmail, true), gettype($signerEmail)), __LINE__);
        }
        $this->signerEmail = $signerEmail;
        return $this;
    }
    /**
     * Get signWithATrust value
     * @return bool|null
     */
    public function getSignWithATrust()
    {
        return $this->signWithATrust;
    }
    /**
     * Set signWithATrust value
     * @param bool $signWithATrust
     * @return \StructType\SignDocumentsRequest
     */
    public function setSignWithATrust($signWithATrust = null)
    {
        // validation for constraint: boolean
        if (!is_null($signWithATrust) && !is_bool($signWithATrust)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($signWithATrust, true), gettype($signWithATrust)), __LINE__);
        }
        $this->signWithATrust = $signWithATrust;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SignDocumentsRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
