<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for sendMessageToMQRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Request for sending a string message to MQ with a messageID and corrleationID. The service will use the default MQ Settings.
 * @subpackage Structs
 */
class SendMessageToMQRequest extends AbstractStructBase
{
    /**
     * The login
     * Meta information extracted from the WSDL
     * - documentation: login data of user
     * @var \StructType\Login
     */
    public $login;
    /**
     * The message
     * Meta information extracted from the WSDL
     * - documentation: message string (xml)
     * @var string
     */
    public $message;
    /**
     * The messageID
     * Meta information extracted from the WSDL
     * - documentation: message id
     * @var string
     */
    public $messageID;
    /**
     * The correlationID
     * Meta information extracted from the WSDL
     * - documentation: correlation id
     * @var string
     */
    public $correlationID;
    /**
     * Constructor method for sendMessageToMQRequest
     * @uses SendMessageToMQRequest::setLogin()
     * @uses SendMessageToMQRequest::setMessage()
     * @uses SendMessageToMQRequest::setMessageID()
     * @uses SendMessageToMQRequest::setCorrelationID()
     * @param \StructType\Login $login
     * @param string $message
     * @param string $messageID
     * @param string $correlationID
     */
    public function __construct(\StructType\Login $login = null, $message = null, $messageID = null, $correlationID = null)
    {
        $this
            ->setLogin($login)
            ->setMessage($message)
            ->setMessageID($messageID)
            ->setCorrelationID($correlationID);
    }
    /**
     * Get login value
     * @return \StructType\Login|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param \StructType\Login $login
     * @return \StructType\SendMessageToMQRequest
     */
    public function setLogin(\StructType\Login $login = null)
    {
        $this->login = $login;
        return $this;
    }
    /**
     * Get message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->message;
    }
    /**
     * Set message value
     * @param string $message
     * @return \StructType\SendMessageToMQRequest
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->message = $message;
        return $this;
    }
    /**
     * Get messageID value
     * @return string|null
     */
    public function getMessageID()
    {
        return $this->messageID;
    }
    /**
     * Set messageID value
     * @param string $messageID
     * @return \StructType\SendMessageToMQRequest
     */
    public function setMessageID($messageID = null)
    {
        // validation for constraint: string
        if (!is_null($messageID) && !is_string($messageID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($messageID, true), gettype($messageID)), __LINE__);
        }
        $this->messageID = $messageID;
        return $this;
    }
    /**
     * Get correlationID value
     * @return string|null
     */
    public function getCorrelationID()
    {
        return $this->correlationID;
    }
    /**
     * Set correlationID value
     * @param string $correlationID
     * @return \StructType\SendMessageToMQRequest
     */
    public function setCorrelationID($correlationID = null)
    {
        // validation for constraint: string
        if (!is_null($correlationID) && !is_string($correlationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($correlationID, true), gettype($correlationID)), __LINE__);
        }
        $this->correlationID = $correlationID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SendMessageToMQRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
