<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for sendCustomerResponse StructType
 * Meta information extracted from the WSDL
 * - documentation: Liefert die (generierte) ID des Kunden in der eVP
 * @subpackage Structs
 */
class SendCustomerResponse extends AbstractStructBase
{
    /**
     * The customerID
     * Meta information extracted from the WSDL
     * - documentation: Ist die ID des Kunden in der eVP
     * @var int
     */
    public $customerID;
    /**
     * The httpLink
     * Meta information extracted from the WSDL
     * - documentation: HTTP Url zum Partner
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $httpLink;
    /**
     * The evpServiceFault
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EvpServiceFault
     */
    public $evpServiceFault;
    /**
     * Constructor method for sendCustomerResponse
     * @uses SendCustomerResponse::setCustomerID()
     * @uses SendCustomerResponse::setHttpLink()
     * @uses SendCustomerResponse::setEvpServiceFault()
     * @param int $customerID
     * @param string $httpLink
     * @param \StructType\EvpServiceFault $evpServiceFault
     */
    public function __construct($customerID = null, $httpLink = null, \StructType\EvpServiceFault $evpServiceFault = null)
    {
        $this
            ->setCustomerID($customerID)
            ->setHttpLink($httpLink)
            ->setEvpServiceFault($evpServiceFault);
    }
    /**
     * Get customerID value
     * @return int|null
     */
    public function getCustomerID()
    {
        return $this->customerID;
    }
    /**
     * Set customerID value
     * @param int $customerID
     * @return \StructType\SendCustomerResponse
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: int
        if (!is_null($customerID) && !(is_int($customerID) || ctype_digit($customerID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerID, true), gettype($customerID)), __LINE__);
        }
        $this->customerID = $customerID;
        return $this;
    }
    /**
     * Get httpLink value
     * @return string|null
     */
    public function getHttpLink()
    {
        return $this->httpLink;
    }
    /**
     * Set httpLink value
     * @param string $httpLink
     * @return \StructType\SendCustomerResponse
     */
    public function setHttpLink($httpLink = null)
    {
        // validation for constraint: string
        if (!is_null($httpLink) && !is_string($httpLink)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($httpLink, true), gettype($httpLink)), __LINE__);
        }
        $this->httpLink = $httpLink;
        return $this;
    }
    /**
     * Get evpServiceFault value
     * @return \StructType\EvpServiceFault|null
     */
    public function getEvpServiceFault()
    {
        return $this->evpServiceFault;
    }
    /**
     * Set evpServiceFault value
     * @param \StructType\EvpServiceFault $evpServiceFault
     * @return \StructType\SendCustomerResponse
     */
    public function setEvpServiceFault(\StructType\EvpServiceFault $evpServiceFault = null)
    {
        $this->evpServiceFault = $evpServiceFault;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SendCustomerResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
