<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for searchClaimListRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Request zum Suchen von Schäden
 * @subpackage Structs
 */
class SearchClaimListRequest extends AbstractStructBase
{
    /**
     * The login
     * @var \StructType\Login
     */
    public $login;
    /**
     * The policyNumber
     * Meta information extracted from the WSDL
     * - documentation: Polizzennummer
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $policyNumber;
    /**
     * The onlyActive
     * Meta information extracted from the WSDL
     * - documentation: nur aktive schäden, default yes
     * - minOccurs: 0
     * @var bool
     */
    public $onlyActive;
    /**
     * Constructor method for searchClaimListRequest
     * @uses SearchClaimListRequest::setLogin()
     * @uses SearchClaimListRequest::setPolicyNumber()
     * @uses SearchClaimListRequest::setOnlyActive()
     * @param \StructType\Login $login
     * @param string[] $policyNumber
     * @param bool $onlyActive
     */
    public function __construct(\StructType\Login $login = null, array $policyNumber = array(), $onlyActive = null)
    {
        $this
            ->setLogin($login)
            ->setPolicyNumber($policyNumber)
            ->setOnlyActive($onlyActive);
    }
    /**
     * Get login value
     * @return \StructType\Login|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param \StructType\Login $login
     * @return \StructType\SearchClaimListRequest
     */
    public function setLogin(\StructType\Login $login = null)
    {
        $this->login = $login;
        return $this;
    }
    /**
     * Get policyNumber value
     * @return string[]|null
     */
    public function getPolicyNumber()
    {
        return $this->policyNumber;
    }
    /**
     * This method is responsible for validating the values passed to the setPolicyNumber method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPolicyNumber method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePolicyNumberForArrayConstraintsFromSetPolicyNumber(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $searchClaimListRequestPolicyNumberItem) {
            // validation for constraint: itemType
            if (!is_string($searchClaimListRequestPolicyNumberItem)) {
                $invalidValues[] = is_object($searchClaimListRequestPolicyNumberItem) ? get_class($searchClaimListRequestPolicyNumberItem) : sprintf('%s(%s)', gettype($searchClaimListRequestPolicyNumberItem), var_export($searchClaimListRequestPolicyNumberItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The policyNumber property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set policyNumber value
     * @throws \InvalidArgumentException
     * @param string[] $policyNumber
     * @return \StructType\SearchClaimListRequest
     */
    public function setPolicyNumber(array $policyNumber = array())
    {
        // validation for constraint: array
        if ('' !== ($policyNumberArrayErrorMessage = self::validatePolicyNumberForArrayConstraintsFromSetPolicyNumber($policyNumber))) {
            throw new \InvalidArgumentException($policyNumberArrayErrorMessage, __LINE__);
        }
        $this->policyNumber = $policyNumber;
        return $this;
    }
    /**
     * Add item to policyNumber value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\SearchClaimListRequest
     */
    public function addToPolicyNumber($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The policyNumber property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->policyNumber[] = $item;
        return $this;
    }
    /**
     * Get onlyActive value
     * @return bool|null
     */
    public function getOnlyActive()
    {
        return $this->onlyActive;
    }
    /**
     * Set onlyActive value
     * @param bool $onlyActive
     * @return \StructType\SearchClaimListRequest
     */
    public function setOnlyActive($onlyActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($onlyActive) && !is_bool($onlyActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($onlyActive, true), gettype($onlyActive)), __LINE__);
        }
        $this->onlyActive = $onlyActive;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SearchClaimListRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
