<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SchliessfachEintrag StructType
 * Meta information extracted from the WSDL
 * - documentation: Ein Eintrag aus dem elektronischen Schließfach
 * @subpackage Structs
 */
class SchliessfachEintrag extends AbstractStructBase
{
    /**
     * The attachment
     * Meta information extracted from the WSDL
     * - documentation: Datei-Anhang
     * @var \StructType\Attachment
     */
    public $attachment;
    /**
     * The date
     * Meta information extracted from the WSDL
     * - documentation: Gespeichert am
     * @var string
     */
    public $date;
    /**
     * Constructor method for SchliessfachEintrag
     * @uses SchliessfachEintrag::setAttachment()
     * @uses SchliessfachEintrag::setDate()
     * @param \StructType\Attachment $attachment
     * @param string $date
     */
    public function __construct(\StructType\Attachment $attachment = null, $date = null)
    {
        $this
            ->setAttachment($attachment)
            ->setDate($date);
    }
    /**
     * Get attachment value
     * @return \StructType\Attachment|null
     */
    public function getAttachment()
    {
        return $this->attachment;
    }
    /**
     * Set attachment value
     * @param \StructType\Attachment $attachment
     * @return \StructType\SchliessfachEintrag
     */
    public function setAttachment(\StructType\Attachment $attachment = null)
    {
        $this->attachment = $attachment;
        return $this;
    }
    /**
     * Get date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->date;
    }
    /**
     * Set date value
     * @param string $date
     * @return \StructType\SchliessfachEintrag
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->date = $date;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SchliessfachEintrag
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
