<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for risikoHHimMFHType StructType
 * @subpackage Structs
 */
class RisikoHHimMFHType extends AbstractStructBase
{
    /**
     * The wohnnutzflaaeche
     * @var int
     */
    public $wohnnutzflaaeche;
    /**
     * The ausstattungskategorie
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ausstattungskategorie;
    /**
     * The vorschaeden
     * @var string
     */
    public $vorschaeden;
    /**
     * The wenigerAls270TageBewohnt
     * Meta information extracted from the WSDL
     * - documentation: Die Gebäude sind nicht ständig bewohnt (weniger als 270 Tage pro Jahr)!
     * - minOccurs: 0
     * @var bool
     */
    public $wenigerAls270TageBewohnt;
    /**
     * Constructor method for risikoHHimMFHType
     * @uses RisikoHHimMFHType::setWohnnutzflaaeche()
     * @uses RisikoHHimMFHType::setAusstattungskategorie()
     * @uses RisikoHHimMFHType::setVorschaeden()
     * @uses RisikoHHimMFHType::setWenigerAls270TageBewohnt()
     * @param int $wohnnutzflaaeche
     * @param string $ausstattungskategorie
     * @param string $vorschaeden
     * @param bool $wenigerAls270TageBewohnt
     */
    public function __construct($wohnnutzflaaeche = null, $ausstattungskategorie = null, $vorschaeden = null, $wenigerAls270TageBewohnt = null)
    {
        $this
            ->setWohnnutzflaaeche($wohnnutzflaaeche)
            ->setAusstattungskategorie($ausstattungskategorie)
            ->setVorschaeden($vorschaeden)
            ->setWenigerAls270TageBewohnt($wenigerAls270TageBewohnt);
    }
    /**
     * Get wohnnutzflaaeche value
     * @return int|null
     */
    public function getWohnnutzflaaeche()
    {
        return $this->wohnnutzflaaeche;
    }
    /**
     * Set wohnnutzflaaeche value
     * @param int $wohnnutzflaaeche
     * @return \StructType\RisikoHHimMFHType
     */
    public function setWohnnutzflaaeche($wohnnutzflaaeche = null)
    {
        // validation for constraint: int
        if (!is_null($wohnnutzflaaeche) && !(is_int($wohnnutzflaaeche) || ctype_digit($wohnnutzflaaeche))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($wohnnutzflaaeche, true), gettype($wohnnutzflaaeche)), __LINE__);
        }
        $this->wohnnutzflaaeche = $wohnnutzflaaeche;
        return $this;
    }
    /**
     * Get ausstattungskategorie value
     * @return string|null
     */
    public function getAusstattungskategorie()
    {
        return $this->ausstattungskategorie;
    }
    /**
     * Set ausstattungskategorie value
     * @uses \EnumType\RisikoAusstattungskategorieType::valueIsValid()
     * @uses \EnumType\RisikoAusstattungskategorieType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ausstattungskategorie
     * @return \StructType\RisikoHHimMFHType
     */
    public function setAusstattungskategorie($ausstattungskategorie = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RisikoAusstattungskategorieType::valueIsValid($ausstattungskategorie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\RisikoAusstattungskategorieType', is_array($ausstattungskategorie) ? implode(', ', $ausstattungskategorie) : var_export($ausstattungskategorie, true), implode(', ', \EnumType\RisikoAusstattungskategorieType::getValidValues())), __LINE__);
        }
        $this->ausstattungskategorie = $ausstattungskategorie;
        return $this;
    }
    /**
     * Get vorschaeden value
     * @return string|null
     */
    public function getVorschaeden()
    {
        return $this->vorschaeden;
    }
    /**
     * Set vorschaeden value
     * @uses \EnumType\RisikoVorschaedenType::valueIsValid()
     * @uses \EnumType\RisikoVorschaedenType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vorschaeden
     * @return \StructType\RisikoHHimMFHType
     */
    public function setVorschaeden($vorschaeden = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RisikoVorschaedenType::valueIsValid($vorschaeden)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\RisikoVorschaedenType', is_array($vorschaeden) ? implode(', ', $vorschaeden) : var_export($vorschaeden, true), implode(', ', \EnumType\RisikoVorschaedenType::getValidValues())), __LINE__);
        }
        $this->vorschaeden = $vorschaeden;
        return $this;
    }
    /**
     * Get wenigerAls270TageBewohnt value
     * @return bool|null
     */
    public function getWenigerAls270TageBewohnt()
    {
        return $this->wenigerAls270TageBewohnt;
    }
    /**
     * Set wenigerAls270TageBewohnt value
     * @param bool $wenigerAls270TageBewohnt
     * @return \StructType\RisikoHHimMFHType
     */
    public function setWenigerAls270TageBewohnt($wenigerAls270TageBewohnt = null)
    {
        // validation for constraint: boolean
        if (!is_null($wenigerAls270TageBewohnt) && !is_bool($wenigerAls270TageBewohnt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($wenigerAls270TageBewohnt, true), gettype($wenigerAls270TageBewohnt)), __LINE__);
        }
        $this->wenigerAls270TageBewohnt = $wenigerAls270TageBewohnt;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RisikoHHimMFHType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
