<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PraemienreduktionType StructType
 * Meta information extracted from the WSDL
 * - documentation: Gibt die Prämienreduktion in% an (50 = 50%) und die Dauer der Reduktion in Jahren
 * @subpackage Structs
 */
class PraemienreduktionType extends AbstractStructBase
{
    /**
     * The praemienreduktion
     * Meta information extracted from the WSDL
     * - documentation: Reduktion der Prämie (50 = 50%)
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $praemienreduktion;
    /**
     * The dauerReduktion
     * Meta information extracted from the WSDL
     * - documentation: Dauer der Reduktion in Jahren
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $dauerReduktion;
    /**
     * Constructor method for PraemienreduktionType
     * @uses PraemienreduktionType::setPraemienreduktion()
     * @uses PraemienreduktionType::setDauerReduktion()
     * @param int $praemienreduktion
     * @param int $dauerReduktion
     */
    public function __construct($praemienreduktion = null, $dauerReduktion = null)
    {
        $this
            ->setPraemienreduktion($praemienreduktion)
            ->setDauerReduktion($dauerReduktion);
    }
    /**
     * Get praemienreduktion value
     * @return int
     */
    public function getPraemienreduktion()
    {
        return $this->praemienreduktion;
    }
    /**
     * Set praemienreduktion value
     * @param int $praemienreduktion
     * @return \StructType\PraemienreduktionType
     */
    public function setPraemienreduktion($praemienreduktion = null)
    {
        // validation for constraint: int
        if (!is_null($praemienreduktion) && !(is_int($praemienreduktion) || ctype_digit($praemienreduktion))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($praemienreduktion, true), gettype($praemienreduktion)), __LINE__);
        }
        $this->praemienreduktion = $praemienreduktion;
        return $this;
    }
    /**
     * Get dauerReduktion value
     * @return int
     */
    public function getDauerReduktion()
    {
        return $this->dauerReduktion;
    }
    /**
     * Set dauerReduktion value
     * @param int $dauerReduktion
     * @return \StructType\PraemienreduktionType
     */
    public function setDauerReduktion($dauerReduktion = null)
    {
        // validation for constraint: int
        if (!is_null($dauerReduktion) && !(is_int($dauerReduktion) || ctype_digit($dauerReduktion))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dauerReduktion, true), gettype($dauerReduktion)), __LINE__);
        }
        $this->dauerReduktion = $dauerReduktion;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PraemienreduktionType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
