<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Policy StructType
 * Meta information extracted from the WSDL
 * - documentation: Polizzenobjekt
 * @subpackage Structs
 */
class Policy extends AbstractStructBase
{
    /**
     * The policyNumber
     * Meta information extracted from the WSDL
     * - documentation: Polizzennummer z.B. : 1/51/12345678 oder 1/51/12345678-01
     * @var string
     */
    public $policyNumber;
    /**
     * The section
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $section;
    /**
     * The agentNumber
     * Meta information extracted from the WSDL
     * - documentation: Vermittlernummer z.B: 123456
     * - base: xsd:string
     * - maxLength: 6
     * - minOccurs: 0
     * @var string
     */
    public $agentNumber;
    /**
     * The policyType
     * Meta information extracted from the WSDL
     * - documentation: Nachspann zu neuen Polizzennummern
     * - minOccurs: 0
     * @var string
     */
    public $policyType;
    /**
     * The policyPartyRole
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PolicyPartnerRole[]
     */
    public $policyPartyRole;
    /**
     * Constructor method for Policy
     * @uses Policy::setPolicyNumber()
     * @uses Policy::setSection()
     * @uses Policy::setAgentNumber()
     * @uses Policy::setPolicyType()
     * @uses Policy::setPolicyPartyRole()
     * @param string $policyNumber
     * @param string $section
     * @param string $agentNumber
     * @param string $policyType
     * @param \StructType\PolicyPartnerRole[] $policyPartyRole
     */
    public function __construct($policyNumber = null, $section = null, $agentNumber = null, $policyType = null, array $policyPartyRole = array())
    {
        $this
            ->setPolicyNumber($policyNumber)
            ->setSection($section)
            ->setAgentNumber($agentNumber)
            ->setPolicyType($policyType)
            ->setPolicyPartyRole($policyPartyRole);
    }
    /**
     * Get policyNumber value
     * @return string|null
     */
    public function getPolicyNumber()
    {
        return $this->policyNumber;
    }
    /**
     * Set policyNumber value
     * @param string $policyNumber
     * @return \StructType\Policy
     */
    public function setPolicyNumber($policyNumber = null)
    {
        // validation for constraint: string
        if (!is_null($policyNumber) && !is_string($policyNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($policyNumber, true), gettype($policyNumber)), __LINE__);
        }
        $this->policyNumber = $policyNumber;
        return $this;
    }
    /**
     * Get section value
     * @return string|null
     */
    public function getSection()
    {
        return $this->section;
    }
    /**
     * Set section value
     * @uses \EnumType\Section::valueIsValid()
     * @uses \EnumType\Section::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $section
     * @return \StructType\Policy
     */
    public function setSection($section = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Section::valueIsValid($section)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Section', is_array($section) ? implode(', ', $section) : var_export($section, true), implode(', ', \EnumType\Section::getValidValues())), __LINE__);
        }
        $this->section = $section;
        return $this;
    }
    /**
     * Get agentNumber value
     * @return string|null
     */
    public function getAgentNumber()
    {
        return $this->agentNumber;
    }
    /**
     * Set agentNumber value
     * @param string $agentNumber
     * @return \StructType\Policy
     */
    public function setAgentNumber($agentNumber = null)
    {
        // validation for constraint: string
        if (!is_null($agentNumber) && !is_string($agentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agentNumber, true), gettype($agentNumber)), __LINE__);
        }
        // validation for constraint: maxLength(6)
        if (!is_null($agentNumber) && mb_strlen($agentNumber) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 6', mb_strlen($agentNumber)), __LINE__);
        }
        $this->agentNumber = $agentNumber;
        return $this;
    }
    /**
     * Get policyType value
     * @return string|null
     */
    public function getPolicyType()
    {
        return $this->policyType;
    }
    /**
     * Set policyType value
     * @uses \EnumType\PolicyType::valueIsValid()
     * @uses \EnumType\PolicyType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $policyType
     * @return \StructType\Policy
     */
    public function setPolicyType($policyType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PolicyType::valueIsValid($policyType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PolicyType', is_array($policyType) ? implode(', ', $policyType) : var_export($policyType, true), implode(', ', \EnumType\PolicyType::getValidValues())), __LINE__);
        }
        $this->policyType = $policyType;
        return $this;
    }
    /**
     * Get policyPartyRole value
     * @return \StructType\PolicyPartnerRole[]|null
     */
    public function getPolicyPartyRole()
    {
        return $this->policyPartyRole;
    }
    /**
     * This method is responsible for validating the values passed to the setPolicyPartyRole method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPolicyPartyRole method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePolicyPartyRoleForArrayConstraintsFromSetPolicyPartyRole(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $policyPolicyPartyRoleItem) {
            // validation for constraint: itemType
            if (!$policyPolicyPartyRoleItem instanceof \StructType\PolicyPartnerRole) {
                $invalidValues[] = is_object($policyPolicyPartyRoleItem) ? get_class($policyPolicyPartyRoleItem) : sprintf('%s(%s)', gettype($policyPolicyPartyRoleItem), var_export($policyPolicyPartyRoleItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The policyPartyRole property can only contain items of type \StructType\PolicyPartnerRole, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set policyPartyRole value
     * @throws \InvalidArgumentException
     * @param \StructType\PolicyPartnerRole[] $policyPartyRole
     * @return \StructType\Policy
     */
    public function setPolicyPartyRole(array $policyPartyRole = array())
    {
        // validation for constraint: array
        if ('' !== ($policyPartyRoleArrayErrorMessage = self::validatePolicyPartyRoleForArrayConstraintsFromSetPolicyPartyRole($policyPartyRole))) {
            throw new \InvalidArgumentException($policyPartyRoleArrayErrorMessage, __LINE__);
        }
        $this->policyPartyRole = $policyPartyRole;
        return $this;
    }
    /**
     * Add item to policyPartyRole value
     * @throws \InvalidArgumentException
     * @param \StructType\PolicyPartnerRole $item
     * @return \StructType\Policy
     */
    public function addToPolicyPartyRole(\StructType\PolicyPartnerRole $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PolicyPartnerRole) {
            throw new \InvalidArgumentException(sprintf('The policyPartyRole property can only contain items of type \StructType\PolicyPartnerRole, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->policyPartyRole[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Policy
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
