<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaCustomer StructType
 * Meta information extracted from the WSDL
 * - documentation: PA-Customer
 * @subpackage Structs
 */
class PaCustomer extends AbstractStructBase
{
    /**
     * The paoId
     * @var string
     */
    public $paoId;
    /**
     * The role
     * @var int
     */
    public $role;
    /**
     * The newCustomer
     * Meta information extracted from the WSDL
     * - documentation: Neu anzulegender Customer (Falls PAO-ID nicht im eigenen Bestand ist)
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Customer
     */
    public $newCustomer;
    /**
     * Constructor method for PaCustomer
     * @uses PaCustomer::setPaoId()
     * @uses PaCustomer::setRole()
     * @uses PaCustomer::setNewCustomer()
     * @param string $paoId
     * @param int $role
     * @param \StructType\Customer $newCustomer
     */
    public function __construct($paoId = null, $role = null, \StructType\Customer $newCustomer = null)
    {
        $this
            ->setPaoId($paoId)
            ->setRole($role)
            ->setNewCustomer($newCustomer);
    }
    /**
     * Get paoId value
     * @return string|null
     */
    public function getPaoId()
    {
        return $this->paoId;
    }
    /**
     * Set paoId value
     * @param string $paoId
     * @return \StructType\PaCustomer
     */
    public function setPaoId($paoId = null)
    {
        // validation for constraint: string
        if (!is_null($paoId) && !is_string($paoId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paoId, true), gettype($paoId)), __LINE__);
        }
        $this->paoId = $paoId;
        return $this;
    }
    /**
     * Get role value
     * @return int|null
     */
    public function getRole()
    {
        return $this->role;
    }
    /**
     * Set role value
     * @param int $role
     * @return \StructType\PaCustomer
     */
    public function setRole($role = null)
    {
        // validation for constraint: int
        if (!is_null($role) && !(is_int($role) || ctype_digit($role))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($role, true), gettype($role)), __LINE__);
        }
        $this->role = $role;
        return $this;
    }
    /**
     * Get newCustomer value
     * @return \StructType\Customer|null
     */
    public function getNewCustomer()
    {
        return $this->newCustomer;
    }
    /**
     * Set newCustomer value
     * @param \StructType\Customer $newCustomer
     * @return \StructType\PaCustomer
     */
    public function setNewCustomer(\StructType\Customer $newCustomer = null)
    {
        $this->newCustomer = $newCustomer;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PaCustomer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
