<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for orderGreenOrServiceCardRequest StructType
 * @subpackage Structs
 */
class OrderGreenOrServiceCardRequest extends AbstractStructBase
{
    /**
     * The login
     * Meta information extracted from the WSDL
     * - documentation: login user
     * @var \StructType\Login
     */
    public $login;
    /**
     * The serviceType
     * @var string
     */
    public $serviceType;
    /**
     * Constructor method for orderGreenOrServiceCardRequest
     * @uses OrderGreenOrServiceCardRequest::setLogin()
     * @uses OrderGreenOrServiceCardRequest::setServiceType()
     * @param \StructType\Login $login
     * @param string $serviceType
     */
    public function __construct(\StructType\Login $login = null, $serviceType = null)
    {
        $this
            ->setLogin($login)
            ->setServiceType($serviceType);
    }
    /**
     * Get login value
     * @return \StructType\Login|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param \StructType\Login $login
     * @return \StructType\OrderGreenOrServiceCardRequest
     */
    public function setLogin(\StructType\Login $login = null)
    {
        $this->login = $login;
        return $this;
    }
    /**
     * Get serviceType value
     * @return string|null
     */
    public function getServiceType()
    {
        return $this->serviceType;
    }
    /**
     * Set serviceType value
     * @uses \EnumType\ServiceType::valueIsValid()
     * @uses \EnumType\ServiceType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $serviceType
     * @return \StructType\OrderGreenOrServiceCardRequest
     */
    public function setServiceType($serviceType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ServiceType::valueIsValid($serviceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ServiceType', is_array($serviceType) ? implode(', ', $serviceType) : var_export($serviceType, true), implode(', ', \EnumType\ServiceType::getValidValues())), __LINE__);
        }
        $this->serviceType = $serviceType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OrderGreenOrServiceCardRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
