<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OMDSPackageInfo StructType
 * @subpackage Structs
 */
class OMDSPackageInfo extends AbstractStructBase
{
    /**
     * The packageID
     * @var int
     */
    public $packageID;
    /**
     * The timeStamp
     * @var string
     */
    public $timeStamp;
    /**
     * The packageSize
     * @var int
     */
    public $packageSize;
    /**
     * Constructor method for OMDSPackageInfo
     * @uses OMDSPackageInfo::setPackageID()
     * @uses OMDSPackageInfo::setTimeStamp()
     * @uses OMDSPackageInfo::setPackageSize()
     * @param int $packageID
     * @param string $timeStamp
     * @param int $packageSize
     */
    public function __construct($packageID = null, $timeStamp = null, $packageSize = null)
    {
        $this
            ->setPackageID($packageID)
            ->setTimeStamp($timeStamp)
            ->setPackageSize($packageSize);
    }
    /**
     * Get packageID value
     * @return int|null
     */
    public function getPackageID()
    {
        return $this->packageID;
    }
    /**
     * Set packageID value
     * @param int $packageID
     * @return \StructType\OMDSPackageInfo
     */
    public function setPackageID($packageID = null)
    {
        // validation for constraint: int
        if (!is_null($packageID) && !(is_int($packageID) || ctype_digit($packageID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($packageID, true), gettype($packageID)), __LINE__);
        }
        $this->packageID = $packageID;
        return $this;
    }
    /**
     * Get timeStamp value
     * @return string|null
     */
    public function getTimeStamp()
    {
        return $this->timeStamp;
    }
    /**
     * Set timeStamp value
     * @param string $timeStamp
     * @return \StructType\OMDSPackageInfo
     */
    public function setTimeStamp($timeStamp = null)
    {
        // validation for constraint: string
        if (!is_null($timeStamp) && !is_string($timeStamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeStamp, true), gettype($timeStamp)), __LINE__);
        }
        $this->timeStamp = $timeStamp;
        return $this;
    }
    /**
     * Get packageSize value
     * @return int|null
     */
    public function getPackageSize()
    {
        return $this->packageSize;
    }
    /**
     * Set packageSize value
     * @param int $packageSize
     * @return \StructType\OMDSPackageInfo
     */
    public function setPackageSize($packageSize = null)
    {
        // validation for constraint: int
        if (!is_null($packageSize) && !(is_int($packageSize) || ctype_digit($packageSize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($packageSize, true), gettype($packageSize)), __LINE__);
        }
        $this->packageSize = $packageSize;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OMDSPackageInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
