<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for newBusinessCaseVersicherungsBestaetigungRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Request zur Versorgung eines Geschäftsfalles
 * @subpackage Structs
 */
class NewBusinessCaseVersicherungsBestaetigungRequest extends AbstractStructBase
{
    /**
     * The versicherungsUnternehmen
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $versicherungsUnternehmen;
    /**
     * The antragserbringer
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 7
     * - maxOccurs: 1
     * - minLength: 7
     * - minOccurs: 1
     * @var string
     */
    public $antragserbringer;
    /**
     * The login
     * @var \StructType\Login
     */
    public $login;
    /**
     * The customer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $customer;
    /**
     * The deckungNachGGBG
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $deckungNachGGBG;
    /**
     * The kasko
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $kasko;
    /**
     * The rechtsschutz
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $rechtsschutz;
    /**
     * The insassenunfall
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $insassenunfall;
    /**
     * The assistance
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $assistance;
    /**
     * Constructor method for newBusinessCaseVersicherungsBestaetigungRequest
     * @uses NewBusinessCaseVersicherungsBestaetigungRequest::setVersicherungsUnternehmen()
     * @uses NewBusinessCaseVersicherungsBestaetigungRequest::setAntragserbringer()
     * @uses NewBusinessCaseVersicherungsBestaetigungRequest::setLogin()
     * @uses NewBusinessCaseVersicherungsBestaetigungRequest::setCustomer()
     * @uses NewBusinessCaseVersicherungsBestaetigungRequest::setDeckungNachGGBG()
     * @uses NewBusinessCaseVersicherungsBestaetigungRequest::setKasko()
     * @uses NewBusinessCaseVersicherungsBestaetigungRequest::setRechtsschutz()
     * @uses NewBusinessCaseVersicherungsBestaetigungRequest::setInsassenunfall()
     * @uses NewBusinessCaseVersicherungsBestaetigungRequest::setAssistance()
     * @param string $versicherungsUnternehmen
     * @param string $antragserbringer
     * @param \StructType\Login $login
     * @param int $customer
     * @param bool $deckungNachGGBG
     * @param string $kasko
     * @param string $rechtsschutz
     * @param string $insassenunfall
     * @param string $assistance
     */
    public function __construct($versicherungsUnternehmen = null, $antragserbringer = null, \StructType\Login $login = null, $customer = null, $deckungNachGGBG = null, $kasko = null, $rechtsschutz = null, $insassenunfall = null, $assistance = null)
    {
        $this
            ->setVersicherungsUnternehmen($versicherungsUnternehmen)
            ->setAntragserbringer($antragserbringer)
            ->setLogin($login)
            ->setCustomer($customer)
            ->setDeckungNachGGBG($deckungNachGGBG)
            ->setKasko($kasko)
            ->setRechtsschutz($rechtsschutz)
            ->setInsassenunfall($insassenunfall)
            ->setAssistance($assistance);
    }
    /**
     * Get versicherungsUnternehmen value
     * @return string
     */
    public function getVersicherungsUnternehmen()
    {
        return $this->versicherungsUnternehmen;
    }
    /**
     * Set versicherungsUnternehmen value
     * @uses \EnumType\VersicherungsUnternehmen::valueIsValid()
     * @uses \EnumType\VersicherungsUnternehmen::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $versicherungsUnternehmen
     * @return \StructType\NewBusinessCaseVersicherungsBestaetigungRequest
     */
    public function setVersicherungsUnternehmen($versicherungsUnternehmen = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VersicherungsUnternehmen::valueIsValid($versicherungsUnternehmen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\VersicherungsUnternehmen', is_array($versicherungsUnternehmen) ? implode(', ', $versicherungsUnternehmen) : var_export($versicherungsUnternehmen, true), implode(', ', \EnumType\VersicherungsUnternehmen::getValidValues())), __LINE__);
        }
        $this->versicherungsUnternehmen = $versicherungsUnternehmen;
        return $this;
    }
    /**
     * Get antragserbringer value
     * @return string
     */
    public function getAntragserbringer()
    {
        return $this->antragserbringer;
    }
    /**
     * Set antragserbringer value
     * @param string $antragserbringer
     * @return \StructType\NewBusinessCaseVersicherungsBestaetigungRequest
     */
    public function setAntragserbringer($antragserbringer = null)
    {
        // validation for constraint: string
        if (!is_null($antragserbringer) && !is_string($antragserbringer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($antragserbringer, true), gettype($antragserbringer)), __LINE__);
        }
        // validation for constraint: maxLength(7)
        if (!is_null($antragserbringer) && mb_strlen($antragserbringer) > 7) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 7', mb_strlen($antragserbringer)), __LINE__);
        }
        // validation for constraint: minLength(7)
        if (!is_null($antragserbringer) && mb_strlen($antragserbringer) < 7) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 7', mb_strlen($antragserbringer)), __LINE__);
        }
        $this->antragserbringer = $antragserbringer;
        return $this;
    }
    /**
     * Get login value
     * @return \StructType\Login|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param \StructType\Login $login
     * @return \StructType\NewBusinessCaseVersicherungsBestaetigungRequest
     */
    public function setLogin(\StructType\Login $login = null)
    {
        $this->login = $login;
        return $this;
    }
    /**
     * Get customer value
     * @return int|null
     */
    public function getCustomer()
    {
        return $this->customer;
    }
    /**
     * Set customer value
     * @param int $customer
     * @return \StructType\NewBusinessCaseVersicherungsBestaetigungRequest
     */
    public function setCustomer($customer = null)
    {
        // validation for constraint: int
        if (!is_null($customer) && !(is_int($customer) || ctype_digit($customer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customer, true), gettype($customer)), __LINE__);
        }
        $this->customer = $customer;
        return $this;
    }
    /**
     * Get deckungNachGGBG value
     * @return bool|null
     */
    public function getDeckungNachGGBG()
    {
        return $this->deckungNachGGBG;
    }
    /**
     * Set deckungNachGGBG value
     * @param bool $deckungNachGGBG
     * @return \StructType\NewBusinessCaseVersicherungsBestaetigungRequest
     */
    public function setDeckungNachGGBG($deckungNachGGBG = null)
    {
        // validation for constraint: boolean
        if (!is_null($deckungNachGGBG) && !is_bool($deckungNachGGBG)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($deckungNachGGBG, true), gettype($deckungNachGGBG)), __LINE__);
        }
        $this->deckungNachGGBG = $deckungNachGGBG;
        return $this;
    }
    /**
     * Get kasko value
     * @return string|null
     */
    public function getKasko()
    {
        return $this->kasko;
    }
    /**
     * Set kasko value
     * @uses \EnumType\Kasko::valueIsValid()
     * @uses \EnumType\Kasko::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $kasko
     * @return \StructType\NewBusinessCaseVersicherungsBestaetigungRequest
     */
    public function setKasko($kasko = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Kasko::valueIsValid($kasko)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Kasko', is_array($kasko) ? implode(', ', $kasko) : var_export($kasko, true), implode(', ', \EnumType\Kasko::getValidValues())), __LINE__);
        }
        $this->kasko = $kasko;
        return $this;
    }
    /**
     * Get rechtsschutz value
     * @return string|null
     */
    public function getRechtsschutz()
    {
        return $this->rechtsschutz;
    }
    /**
     * Set rechtsschutz value
     * @uses \EnumType\Rechtsschutz::valueIsValid()
     * @uses \EnumType\Rechtsschutz::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $rechtsschutz
     * @return \StructType\NewBusinessCaseVersicherungsBestaetigungRequest
     */
    public function setRechtsschutz($rechtsschutz = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Rechtsschutz::valueIsValid($rechtsschutz)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Rechtsschutz', is_array($rechtsschutz) ? implode(', ', $rechtsschutz) : var_export($rechtsschutz, true), implode(', ', \EnumType\Rechtsschutz::getValidValues())), __LINE__);
        }
        $this->rechtsschutz = $rechtsschutz;
        return $this;
    }
    /**
     * Get insassenunfall value
     * @return string|null
     */
    public function getInsassenunfall()
    {
        return $this->insassenunfall;
    }
    /**
     * Set insassenunfall value
     * @uses \EnumType\Insassenunfall::valueIsValid()
     * @uses \EnumType\Insassenunfall::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $insassenunfall
     * @return \StructType\NewBusinessCaseVersicherungsBestaetigungRequest
     */
    public function setInsassenunfall($insassenunfall = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Insassenunfall::valueIsValid($insassenunfall)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Insassenunfall', is_array($insassenunfall) ? implode(', ', $insassenunfall) : var_export($insassenunfall, true), implode(', ', \EnumType\Insassenunfall::getValidValues())), __LINE__);
        }
        $this->insassenunfall = $insassenunfall;
        return $this;
    }
    /**
     * Get assistance value
     * @return string|null
     */
    public function getAssistance()
    {
        return $this->assistance;
    }
    /**
     * Set assistance value
     * @uses \EnumType\Assistance::valueIsValid()
     * @uses \EnumType\Assistance::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $assistance
     * @return \StructType\NewBusinessCaseVersicherungsBestaetigungRequest
     */
    public function setAssistance($assistance = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Assistance::valueIsValid($assistance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Assistance', is_array($assistance) ? implode(', ', $assistance) : var_export($assistance, true), implode(', ', \EnumType\Assistance::getValidValues())), __LINE__);
        }
        $this->assistance = $assistance;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\NewBusinessCaseVersicherungsBestaetigungRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
