<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for newBusinessCaseToPolicyResponse StructType
 * @subpackage Structs
 */
class NewBusinessCaseToPolicyResponse extends AbstractStructBase
{
    /**
     * The premium
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $premium;
    /**
     * The tax
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tax;
    /**
     * The businessCase
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\BusinessCase
     */
    public $businessCase;
    /**
     * The evpServiceFault
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EvpServiceFault
     */
    public $evpServiceFault;
    /**
     * Constructor method for newBusinessCaseToPolicyResponse
     * @uses NewBusinessCaseToPolicyResponse::setPremium()
     * @uses NewBusinessCaseToPolicyResponse::setTax()
     * @uses NewBusinessCaseToPolicyResponse::setBusinessCase()
     * @uses NewBusinessCaseToPolicyResponse::setEvpServiceFault()
     * @param string $premium
     * @param string $tax
     * @param \StructType\BusinessCase $businessCase
     * @param \StructType\EvpServiceFault $evpServiceFault
     */
    public function __construct($premium = null, $tax = null, \StructType\BusinessCase $businessCase = null, \StructType\EvpServiceFault $evpServiceFault = null)
    {
        $this
            ->setPremium($premium)
            ->setTax($tax)
            ->setBusinessCase($businessCase)
            ->setEvpServiceFault($evpServiceFault);
    }
    /**
     * Get premium value
     * @return string|null
     */
    public function getPremium()
    {
        return $this->premium;
    }
    /**
     * Set premium value
     * @param string $premium
     * @return \StructType\NewBusinessCaseToPolicyResponse
     */
    public function setPremium($premium = null)
    {
        // validation for constraint: string
        if (!is_null($premium) && !is_string($premium)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($premium, true), gettype($premium)), __LINE__);
        }
        $this->premium = $premium;
        return $this;
    }
    /**
     * Get tax value
     * @return string|null
     */
    public function getTax()
    {
        return $this->tax;
    }
    /**
     * Set tax value
     * @param string $tax
     * @return \StructType\NewBusinessCaseToPolicyResponse
     */
    public function setTax($tax = null)
    {
        // validation for constraint: string
        if (!is_null($tax) && !is_string($tax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tax, true), gettype($tax)), __LINE__);
        }
        $this->tax = $tax;
        return $this;
    }
    /**
     * Get businessCase value
     * @return \StructType\BusinessCase|null
     */
    public function getBusinessCase()
    {
        return $this->businessCase;
    }
    /**
     * Set businessCase value
     * @param \StructType\BusinessCase $businessCase
     * @return \StructType\NewBusinessCaseToPolicyResponse
     */
    public function setBusinessCase(\StructType\BusinessCase $businessCase = null)
    {
        $this->businessCase = $businessCase;
        return $this;
    }
    /**
     * Get evpServiceFault value
     * @return \StructType\EvpServiceFault|null
     */
    public function getEvpServiceFault()
    {
        return $this->evpServiceFault;
    }
    /**
     * Set evpServiceFault value
     * @param \StructType\EvpServiceFault $evpServiceFault
     * @return \StructType\NewBusinessCaseToPolicyResponse
     */
    public function setEvpServiceFault(\StructType\EvpServiceFault $evpServiceFault = null)
    {
        $this->evpServiceFault = $evpServiceFault;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\NewBusinessCaseToPolicyResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
