<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for newBusinessCaseStornoRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Request zur Versorgung eines Geschäftsfalles
 * @subpackage Structs
 */
class NewBusinessCaseStornoRequest extends AbstractStructBase
{
    /**
     * The login
     * @var \StructType\Login
     */
    public $login;
    /**
     * The policynumber
     * Meta information extracted from the WSDL
     * - union: IrisPolicyNumber | EVtgPolicyNumber
     * @var string
     */
    public $policynumber;
    /**
     * The status
     * @var string
     */
    public $status;
    /**
     * The stornoDatum
     * @var string
     */
    public $stornoDatum;
    /**
     * The stornoGrund
     * @var string
     */
    public $stornoGrund;
    /**
     * The attachment
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Attachment[]
     */
    public $attachment;
    /**
     * The kommentar
     * @var string
     */
    public $kommentar;
    /**
     * Constructor method for newBusinessCaseStornoRequest
     * @uses NewBusinessCaseStornoRequest::setLogin()
     * @uses NewBusinessCaseStornoRequest::setPolicynumber()
     * @uses NewBusinessCaseStornoRequest::setStatus()
     * @uses NewBusinessCaseStornoRequest::setStornoDatum()
     * @uses NewBusinessCaseStornoRequest::setStornoGrund()
     * @uses NewBusinessCaseStornoRequest::setAttachment()
     * @uses NewBusinessCaseStornoRequest::setKommentar()
     * @param \StructType\Login $login
     * @param string $policynumber
     * @param string $status
     * @param string $stornoDatum
     * @param string $stornoGrund
     * @param \StructType\Attachment[] $attachment
     * @param string $kommentar
     */
    public function __construct(\StructType\Login $login = null, $policynumber = null, $status = null, $stornoDatum = null, $stornoGrund = null, array $attachment = array(), $kommentar = null)
    {
        $this
            ->setLogin($login)
            ->setPolicynumber($policynumber)
            ->setStatus($status)
            ->setStornoDatum($stornoDatum)
            ->setStornoGrund($stornoGrund)
            ->setAttachment($attachment)
            ->setKommentar($kommentar);
    }
    /**
     * Get login value
     * @return \StructType\Login|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param \StructType\Login $login
     * @return \StructType\NewBusinessCaseStornoRequest
     */
    public function setLogin(\StructType\Login $login = null)
    {
        $this->login = $login;
        return $this;
    }
    /**
     * Get policynumber value
     * @return string|null
     */
    public function getPolicynumber()
    {
        return $this->policynumber;
    }
    /**
     * This method is responsible for validating the value passed to the setPolicynumber method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPolicynumber method
     * This is a set of validation rules based on the union types associated to the property being set by the setPolicynumber method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePolicynumberForUnionConstraintsFromSetPolicynumber($value)
    {
        $message = '';
        // validation for constraint: pattern(\d/\d{2}/\d{8}(-\d{2})?)
        if (!is_null($value) && !preg_match('/\\d\/\\d{2}\/\\d{8}(-\\d{2})?/', $value)) {
            $exception0 = new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d/\d{2}/\d{8}(-\d{2})?', var_export($value, true)), __LINE__);
        }
        // validation for constraint: pattern(\d{3}-\d{4}-\d{4})
        if (!is_null($value) && !preg_match('/\\d{3}-\\d{4}-\\d{4}/', $value)) {
            $exception1 = new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{3}-\d{4}-\d{4}', var_export($value, true)), __LINE__);
        }
        if (isset($exception0) && isset($exception1)) {
            $message = sprintf("The value %s does not match any of the union rules: IrisPolicyNumber, EVtgPolicyNumber. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [$exception0, $exception1])));
        }
        unset($exception0, $exception1);
        return $message;
    }
    /**
     * Set policynumber value
     * @param string $policynumber
     * @return \StructType\NewBusinessCaseStornoRequest
     */
    public function setPolicynumber($policynumber = null)
    {
        // validation for constraint: string
        if (!is_null($policynumber) && !is_string($policynumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($policynumber, true), gettype($policynumber)), __LINE__);
        }
        // validation for constraint: union(IrisPolicyNumber, EVtgPolicyNumber)
        if ('' !== ($policynumberUnionErrorMessage = self::validatePolicynumberForUnionConstraintsFromSetPolicynumber($policynumber))) {
            throw new \InvalidArgumentException($policynumberUnionErrorMessage, __LINE__);
        }
        $this->policynumber = $policynumber;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @uses \EnumType\StornoStatus::valueIsValid()
     * @uses \EnumType\StornoStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\NewBusinessCaseStornoRequest
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\StornoStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\StornoStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\StornoStatus::getValidValues())), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get stornoDatum value
     * @return string|null
     */
    public function getStornoDatum()
    {
        return $this->stornoDatum;
    }
    /**
     * Set stornoDatum value
     * @param string $stornoDatum
     * @return \StructType\NewBusinessCaseStornoRequest
     */
    public function setStornoDatum($stornoDatum = null)
    {
        // validation for constraint: string
        if (!is_null($stornoDatum) && !is_string($stornoDatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stornoDatum, true), gettype($stornoDatum)), __LINE__);
        }
        $this->stornoDatum = $stornoDatum;
        return $this;
    }
    /**
     * Get stornoGrund value
     * @return string|null
     */
    public function getStornoGrund()
    {
        return $this->stornoGrund;
    }
    /**
     * Set stornoGrund value
     * @uses \EnumType\StornoGrund::valueIsValid()
     * @uses \EnumType\StornoGrund::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $stornoGrund
     * @return \StructType\NewBusinessCaseStornoRequest
     */
    public function setStornoGrund($stornoGrund = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\StornoGrund::valueIsValid($stornoGrund)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\StornoGrund', is_array($stornoGrund) ? implode(', ', $stornoGrund) : var_export($stornoGrund, true), implode(', ', \EnumType\StornoGrund::getValidValues())), __LINE__);
        }
        $this->stornoGrund = $stornoGrund;
        return $this;
    }
    /**
     * Get attachment value
     * @return \StructType\Attachment[]|null
     */
    public function getAttachment()
    {
        return $this->attachment;
    }
    /**
     * This method is responsible for validating the values passed to the setAttachment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAttachment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAttachmentForArrayConstraintsFromSetAttachment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $newBusinessCaseStornoRequestAttachmentItem) {
            // validation for constraint: itemType
            if (!$newBusinessCaseStornoRequestAttachmentItem instanceof \StructType\Attachment) {
                $invalidValues[] = is_object($newBusinessCaseStornoRequestAttachmentItem) ? get_class($newBusinessCaseStornoRequestAttachmentItem) : sprintf('%s(%s)', gettype($newBusinessCaseStornoRequestAttachmentItem), var_export($newBusinessCaseStornoRequestAttachmentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The attachment property can only contain items of type \StructType\Attachment, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set attachment value
     * @throws \InvalidArgumentException
     * @param \StructType\Attachment[] $attachment
     * @return \StructType\NewBusinessCaseStornoRequest
     */
    public function setAttachment(array $attachment = array())
    {
        // validation for constraint: array
        if ('' !== ($attachmentArrayErrorMessage = self::validateAttachmentForArrayConstraintsFromSetAttachment($attachment))) {
            throw new \InvalidArgumentException($attachmentArrayErrorMessage, __LINE__);
        }
        $this->attachment = $attachment;
        return $this;
    }
    /**
     * Add item to attachment value
     * @throws \InvalidArgumentException
     * @param \StructType\Attachment $item
     * @return \StructType\NewBusinessCaseStornoRequest
     */
    public function addToAttachment(\StructType\Attachment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Attachment) {
            throw new \InvalidArgumentException(sprintf('The attachment property can only contain items of type \StructType\Attachment, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->attachment[] = $item;
        return $this;
    }
    /**
     * Get kommentar value
     * @return string|null
     */
    public function getKommentar()
    {
        return $this->kommentar;
    }
    /**
     * Set kommentar value
     * @param string $kommentar
     * @return \StructType\NewBusinessCaseStornoRequest
     */
    public function setKommentar($kommentar = null)
    {
        // validation for constraint: string
        if (!is_null($kommentar) && !is_string($kommentar)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kommentar, true), gettype($kommentar)), __LINE__);
        }
        $this->kommentar = $kommentar;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\NewBusinessCaseStornoRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
