<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for newBusinessCaseRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Request um einen neuen Geschäftsfall anzulegen. Dieser werden alle Kundenobjekte übergeben, die in die Session gelegt werden sollen
 * @subpackage Structs
 */
class NewBusinessCaseRequest extends AbstractStructBase
{
    /**
     * The login
     * Meta information extracted from the WSDL
     * - documentation: login user
     * @var \StructType\Login
     */
    public $login;
    /**
     * The customer
     * Meta information extracted from the WSDL
     * - documentation: Kunden ID´s
     * - maxOccurs: 50
     * - minOccurs: 0
     * @var int[]
     */
    public $customer;
    /**
     * The policy
     * Meta information extracted from the WSDL
     * - documentation: Polizzen Informationen für eine Schadenmeldung
     * - maxOccurs: 3
     * - minOccurs: 0
     * @var \StructType\Policy[]
     */
    public $policy;
    /**
     * The businessCaseType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $businessCaseType;
    /**
     * The paOid
     * Meta information extracted from the WSDL
     * - documentation: paOid des kundenportal partners
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $paOid;
    /**
     * The externalContractNumber
     * Meta information extracted from the WSDL
     * - documentation: Externe Antragsnummer, welche zu dem Geschäftsfall gespeichert werden.
     * - minOccurs: 0
     * @var string
     */
    public $externalContractNumber;
    /**
     * The withoutFrame
     * Meta information extracted from the WSDL
     * - documentation: Definiert ob ein eVP Navigationsframe angezeigt wird oder nicht
     * - default: false
     * - minOccurs: 0
     * @var bool
     */
    public $withoutFrame;
    /**
     * Constructor method for newBusinessCaseRequest
     * @uses NewBusinessCaseRequest::setLogin()
     * @uses NewBusinessCaseRequest::setCustomer()
     * @uses NewBusinessCaseRequest::setPolicy()
     * @uses NewBusinessCaseRequest::setBusinessCaseType()
     * @uses NewBusinessCaseRequest::setPaOid()
     * @uses NewBusinessCaseRequest::setExternalContractNumber()
     * @uses NewBusinessCaseRequest::setWithoutFrame()
     * @param \StructType\Login $login
     * @param int[] $customer
     * @param \StructType\Policy[] $policy
     * @param string $businessCaseType
     * @param string $paOid
     * @param string $externalContractNumber
     * @param bool $withoutFrame
     */
    public function __construct(\StructType\Login $login = null, array $customer = array(), array $policy = array(), $businessCaseType = null, $paOid = null, $externalContractNumber = null, $withoutFrame = false)
    {
        $this
            ->setLogin($login)
            ->setCustomer($customer)
            ->setPolicy($policy)
            ->setBusinessCaseType($businessCaseType)
            ->setPaOid($paOid)
            ->setExternalContractNumber($externalContractNumber)
            ->setWithoutFrame($withoutFrame);
    }
    /**
     * Get login value
     * @return \StructType\Login|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param \StructType\Login $login
     * @return \StructType\NewBusinessCaseRequest
     */
    public function setLogin(\StructType\Login $login = null)
    {
        $this->login = $login;
        return $this;
    }
    /**
     * Get customer value
     * @return int[]|null
     */
    public function getCustomer()
    {
        return $this->customer;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomer method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomerForArrayConstraintsFromSetCustomer(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $newBusinessCaseRequestCustomerItem) {
            // validation for constraint: itemType
            if (!(is_int($newBusinessCaseRequestCustomerItem) || ctype_digit($newBusinessCaseRequestCustomerItem))) {
                $invalidValues[] = is_object($newBusinessCaseRequestCustomerItem) ? get_class($newBusinessCaseRequestCustomerItem) : sprintf('%s(%s)', gettype($newBusinessCaseRequestCustomerItem), var_export($newBusinessCaseRequestCustomerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The customer property can only contain items of type integer, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set customer value
     * @throws \InvalidArgumentException
     * @param int[] $customer
     * @return \StructType\NewBusinessCaseRequest
     */
    public function setCustomer(array $customer = array())
    {
        // validation for constraint: array
        if ('' !== ($customerArrayErrorMessage = self::validateCustomerForArrayConstraintsFromSetCustomer($customer))) {
            throw new \InvalidArgumentException($customerArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(50)
        if (is_array($customer) && count($customer) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 50', count($customer)), __LINE__);
        }
        $this->customer = $customer;
        return $this;
    }
    /**
     * Add item to customer value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\NewBusinessCaseRequest
     */
    public function addToCustomer($item)
    {
        // validation for constraint: itemType
        if (!(is_int($item) || ctype_digit($item))) {
            throw new \InvalidArgumentException(sprintf('The customer property can only contain items of type integer, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(50)
        if (is_array($this->customer) && count($this->customer) >= 50) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 50', count($this->customer)), __LINE__);
        }
        $this->customer[] = $item;
        return $this;
    }
    /**
     * Get policy value
     * @return \StructType\Policy[]|null
     */
    public function getPolicy()
    {
        return $this->policy;
    }
    /**
     * This method is responsible for validating the values passed to the setPolicy method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPolicy method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePolicyForArrayConstraintsFromSetPolicy(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $newBusinessCaseRequestPolicyItem) {
            // validation for constraint: itemType
            if (!$newBusinessCaseRequestPolicyItem instanceof \StructType\Policy) {
                $invalidValues[] = is_object($newBusinessCaseRequestPolicyItem) ? get_class($newBusinessCaseRequestPolicyItem) : sprintf('%s(%s)', gettype($newBusinessCaseRequestPolicyItem), var_export($newBusinessCaseRequestPolicyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The policy property can only contain items of type \StructType\Policy, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set policy value
     * @throws \InvalidArgumentException
     * @param \StructType\Policy[] $policy
     * @return \StructType\NewBusinessCaseRequest
     */
    public function setPolicy(array $policy = array())
    {
        // validation for constraint: array
        if ('' !== ($policyArrayErrorMessage = self::validatePolicyForArrayConstraintsFromSetPolicy($policy))) {
            throw new \InvalidArgumentException($policyArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($policy) && count($policy) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 3', count($policy)), __LINE__);
        }
        $this->policy = $policy;
        return $this;
    }
    /**
     * Add item to policy value
     * @throws \InvalidArgumentException
     * @param \StructType\Policy $item
     * @return \StructType\NewBusinessCaseRequest
     */
    public function addToPolicy(\StructType\Policy $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Policy) {
            throw new \InvalidArgumentException(sprintf('The policy property can only contain items of type \StructType\Policy, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($this->policy) && count($this->policy) >= 3) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 3', count($this->policy)), __LINE__);
        }
        $this->policy[] = $item;
        return $this;
    }
    /**
     * Get businessCaseType value
     * @return string|null
     */
    public function getBusinessCaseType()
    {
        return $this->businessCaseType;
    }
    /**
     * Set businessCaseType value
     * @uses \EnumType\BusinessCaseType::valueIsValid()
     * @uses \EnumType\BusinessCaseType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $businessCaseType
     * @return \StructType\NewBusinessCaseRequest
     */
    public function setBusinessCaseType($businessCaseType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\BusinessCaseType::valueIsValid($businessCaseType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\BusinessCaseType', is_array($businessCaseType) ? implode(', ', $businessCaseType) : var_export($businessCaseType, true), implode(', ', \EnumType\BusinessCaseType::getValidValues())), __LINE__);
        }
        $this->businessCaseType = $businessCaseType;
        return $this;
    }
    /**
     * Get paOid value
     * @return string|null
     */
    public function getPaOid()
    {
        return $this->paOid;
    }
    /**
     * Set paOid value
     * @param string $paOid
     * @return \StructType\NewBusinessCaseRequest
     */
    public function setPaOid($paOid = null)
    {
        // validation for constraint: string
        if (!is_null($paOid) && !is_string($paOid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paOid, true), gettype($paOid)), __LINE__);
        }
        $this->paOid = $paOid;
        return $this;
    }
    /**
     * Get externalContractNumber value
     * @return string|null
     */
    public function getExternalContractNumber()
    {
        return $this->externalContractNumber;
    }
    /**
     * Set externalContractNumber value
     * @param string $externalContractNumber
     * @return \StructType\NewBusinessCaseRequest
     */
    public function setExternalContractNumber($externalContractNumber = null)
    {
        // validation for constraint: string
        if (!is_null($externalContractNumber) && !is_string($externalContractNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalContractNumber, true), gettype($externalContractNumber)), __LINE__);
        }
        $this->externalContractNumber = $externalContractNumber;
        return $this;
    }
    /**
     * Get withoutFrame value
     * @return bool|null
     */
    public function getWithoutFrame()
    {
        return $this->withoutFrame;
    }
    /**
     * Set withoutFrame value
     * @param bool $withoutFrame
     * @return \StructType\NewBusinessCaseRequest
     */
    public function setWithoutFrame($withoutFrame = false)
    {
        // validation for constraint: boolean
        if (!is_null($withoutFrame) && !is_bool($withoutFrame)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($withoutFrame, true), gettype($withoutFrame)), __LINE__);
        }
        $this->withoutFrame = $withoutFrame;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\NewBusinessCaseRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
