<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for newBusinessCaseFromXmlRequest StructType
 * @subpackage Structs
 */
class NewBusinessCaseFromXmlRequest extends AbstractStructBase
{
    /**
     * The login
     * @var \StructType\Login
     */
    public $login;
    /**
     * The customer
     * @var \StructType\Customer
     */
    public $customer;
    /**
     * The businessCaseType
     * @var string
     */
    public $businessCaseType;
    /**
     * The businessCaseDataXml
     * Meta information extracted from the WSDL
     * - documentation: save XML as base64 decoded String
     * @var string
     */
    public $businessCaseDataXml;
    /**
     * Constructor method for newBusinessCaseFromXmlRequest
     * @uses NewBusinessCaseFromXmlRequest::setLogin()
     * @uses NewBusinessCaseFromXmlRequest::setCustomer()
     * @uses NewBusinessCaseFromXmlRequest::setBusinessCaseType()
     * @uses NewBusinessCaseFromXmlRequest::setBusinessCaseDataXml()
     * @param \StructType\Login $login
     * @param \StructType\Customer $customer
     * @param string $businessCaseType
     * @param string $businessCaseDataXml
     */
    public function __construct(\StructType\Login $login = null, \StructType\Customer $customer = null, $businessCaseType = null, $businessCaseDataXml = null)
    {
        $this
            ->setLogin($login)
            ->setCustomer($customer)
            ->setBusinessCaseType($businessCaseType)
            ->setBusinessCaseDataXml($businessCaseDataXml);
    }
    /**
     * Get login value
     * @return \StructType\Login|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param \StructType\Login $login
     * @return \StructType\NewBusinessCaseFromXmlRequest
     */
    public function setLogin(\StructType\Login $login = null)
    {
        $this->login = $login;
        return $this;
    }
    /**
     * Get customer value
     * @return \StructType\Customer|null
     */
    public function getCustomer()
    {
        return $this->customer;
    }
    /**
     * Set customer value
     * @param \StructType\Customer $customer
     * @return \StructType\NewBusinessCaseFromXmlRequest
     */
    public function setCustomer(\StructType\Customer $customer = null)
    {
        $this->customer = $customer;
        return $this;
    }
    /**
     * Get businessCaseType value
     * @return string|null
     */
    public function getBusinessCaseType()
    {
        return $this->businessCaseType;
    }
    /**
     * Set businessCaseType value
     * @uses \EnumType\BusinessCaseType::valueIsValid()
     * @uses \EnumType\BusinessCaseType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $businessCaseType
     * @return \StructType\NewBusinessCaseFromXmlRequest
     */
    public function setBusinessCaseType($businessCaseType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\BusinessCaseType::valueIsValid($businessCaseType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\BusinessCaseType', is_array($businessCaseType) ? implode(', ', $businessCaseType) : var_export($businessCaseType, true), implode(', ', \EnumType\BusinessCaseType::getValidValues())), __LINE__);
        }
        $this->businessCaseType = $businessCaseType;
        return $this;
    }
    /**
     * Get businessCaseDataXml value
     * @return string|null
     */
    public function getBusinessCaseDataXml()
    {
        return $this->businessCaseDataXml;
    }
    /**
     * Set businessCaseDataXml value
     * @param string $businessCaseDataXml
     * @return \StructType\NewBusinessCaseFromXmlRequest
     */
    public function setBusinessCaseDataXml($businessCaseDataXml = null)
    {
        // validation for constraint: string
        if (!is_null($businessCaseDataXml) && !is_string($businessCaseDataXml)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($businessCaseDataXml, true), gettype($businessCaseDataXml)), __LINE__);
        }
        $this->businessCaseDataXml = $businessCaseDataXml;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\NewBusinessCaseFromXmlRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
