<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for mapCustomerToPAPartnerRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Request zum Mappen eines WS-Customers --> PA Partner
 * @subpackage Structs
 */
class MapCustomerToPAPartnerRequest extends AbstractStructBase
{
    /**
     * The login
     * @var \StructType\Login
     */
    public $login;
    /**
     * The customer
     * Meta information extracted from the WSDL
     * - documentation: Kunde...
     * @var \StructType\Customer
     */
    public $customer;
    /**
     * The policy
     * Meta information extracted from the WSDL
     * - documentation: Policy
     * @var \StructType\Policy
     */
    public $policy;
    /**
     * Constructor method for mapCustomerToPAPartnerRequest
     * @uses MapCustomerToPAPartnerRequest::setLogin()
     * @uses MapCustomerToPAPartnerRequest::setCustomer()
     * @uses MapCustomerToPAPartnerRequest::setPolicy()
     * @param \StructType\Login $login
     * @param \StructType\Customer $customer
     * @param \StructType\Policy $policy
     */
    public function __construct(\StructType\Login $login = null, \StructType\Customer $customer = null, \StructType\Policy $policy = null)
    {
        $this
            ->setLogin($login)
            ->setCustomer($customer)
            ->setPolicy($policy);
    }
    /**
     * Get login value
     * @return \StructType\Login|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param \StructType\Login $login
     * @return \StructType\MapCustomerToPAPartnerRequest
     */
    public function setLogin(\StructType\Login $login = null)
    {
        $this->login = $login;
        return $this;
    }
    /**
     * Get customer value
     * @return \StructType\Customer|null
     */
    public function getCustomer()
    {
        return $this->customer;
    }
    /**
     * Set customer value
     * @param \StructType\Customer $customer
     * @return \StructType\MapCustomerToPAPartnerRequest
     */
    public function setCustomer(\StructType\Customer $customer = null)
    {
        $this->customer = $customer;
        return $this;
    }
    /**
     * Get policy value
     * @return \StructType\Policy|null
     */
    public function getPolicy()
    {
        return $this->policy;
    }
    /**
     * Set policy value
     * @param \StructType\Policy $policy
     * @return \StructType\MapCustomerToPAPartnerRequest
     */
    public function setPolicy(\StructType\Policy $policy = null)
    {
        $this->policy = $policy;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MapCustomerToPAPartnerRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
