<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for kundenportalCreateDeleteSaveOrUpdateDocumentRequest
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Kundenportal CreateDeleteSaveOrUpdateDocument Service Request
 * @subpackage Structs
 */
class KundenportalCreateDeleteSaveOrUpdateDocumentRequest extends AbstractStructBase
{
    /**
     * The login
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Login
     */
    public $login;
    /**
     * The referenceId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $referenceId;
    /**
     * The documentid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $documentid;
    /**
     * The deleteDocument
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $deleteDocument;
    /**
     * The documentType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $documentType;
    /**
     * The documentName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $documentName;
    /**
     * The documentDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $documentDate;
    /**
     * The document
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Attachment
     */
    public $document;
    /**
     * Constructor method for kundenportalCreateDeleteSaveOrUpdateDocumentRequest
     * @uses KundenportalCreateDeleteSaveOrUpdateDocumentRequest::setLogin()
     * @uses KundenportalCreateDeleteSaveOrUpdateDocumentRequest::setReferenceId()
     * @uses KundenportalCreateDeleteSaveOrUpdateDocumentRequest::setDocumentid()
     * @uses KundenportalCreateDeleteSaveOrUpdateDocumentRequest::setDeleteDocument()
     * @uses KundenportalCreateDeleteSaveOrUpdateDocumentRequest::setDocumentType()
     * @uses KundenportalCreateDeleteSaveOrUpdateDocumentRequest::setDocumentName()
     * @uses KundenportalCreateDeleteSaveOrUpdateDocumentRequest::setDocumentDate()
     * @uses KundenportalCreateDeleteSaveOrUpdateDocumentRequest::setDocument()
     * @param \StructType\Login $login
     * @param int $referenceId
     * @param int $documentid
     * @param bool $deleteDocument
     * @param string $documentType
     * @param string $documentName
     * @param string $documentDate
     * @param \StructType\Attachment $document
     */
    public function __construct(\StructType\Login $login = null, $referenceId = null, $documentid = null, $deleteDocument = null, $documentType = null, $documentName = null, $documentDate = null, \StructType\Attachment $document = null)
    {
        $this
            ->setLogin($login)
            ->setReferenceId($referenceId)
            ->setDocumentid($documentid)
            ->setDeleteDocument($deleteDocument)
            ->setDocumentType($documentType)
            ->setDocumentName($documentName)
            ->setDocumentDate($documentDate)
            ->setDocument($document);
    }
    /**
     * Get login value
     * @return \StructType\Login
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param \StructType\Login $login
     * @return \StructType\KundenportalCreateDeleteSaveOrUpdateDocumentRequest
     */
    public function setLogin(\StructType\Login $login = null)
    {
        $this->login = $login;
        return $this;
    }
    /**
     * Get referenceId value
     * @return int|null
     */
    public function getReferenceId()
    {
        return $this->referenceId;
    }
    /**
     * Set referenceId value
     * @param int $referenceId
     * @return \StructType\KundenportalCreateDeleteSaveOrUpdateDocumentRequest
     */
    public function setReferenceId($referenceId = null)
    {
        // validation for constraint: int
        if (!is_null($referenceId) && !(is_int($referenceId) || ctype_digit($referenceId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($referenceId, true), gettype($referenceId)), __LINE__);
        }
        $this->referenceId = $referenceId;
        return $this;
    }
    /**
     * Get documentid value
     * @return int|null
     */
    public function getDocumentid()
    {
        return $this->documentid;
    }
    /**
     * Set documentid value
     * @param int $documentid
     * @return \StructType\KundenportalCreateDeleteSaveOrUpdateDocumentRequest
     */
    public function setDocumentid($documentid = null)
    {
        // validation for constraint: int
        if (!is_null($documentid) && !(is_int($documentid) || ctype_digit($documentid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($documentid, true), gettype($documentid)), __LINE__);
        }
        $this->documentid = $documentid;
        return $this;
    }
    /**
     * Get deleteDocument value
     * @return bool|null
     */
    public function getDeleteDocument()
    {
        return $this->deleteDocument;
    }
    /**
     * Set deleteDocument value
     * @param bool $deleteDocument
     * @return \StructType\KundenportalCreateDeleteSaveOrUpdateDocumentRequest
     */
    public function setDeleteDocument($deleteDocument = null)
    {
        // validation for constraint: boolean
        if (!is_null($deleteDocument) && !is_bool($deleteDocument)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($deleteDocument, true), gettype($deleteDocument)), __LINE__);
        }
        $this->deleteDocument = $deleteDocument;
        return $this;
    }
    /**
     * Get documentType value
     * @return string|null
     */
    public function getDocumentType()
    {
        return $this->documentType;
    }
    /**
     * Set documentType value
     * @param string $documentType
     * @return \StructType\KundenportalCreateDeleteSaveOrUpdateDocumentRequest
     */
    public function setDocumentType($documentType = null)
    {
        // validation for constraint: string
        if (!is_null($documentType) && !is_string($documentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentType, true), gettype($documentType)), __LINE__);
        }
        $this->documentType = $documentType;
        return $this;
    }
    /**
     * Get documentName value
     * @return string|null
     */
    public function getDocumentName()
    {
        return $this->documentName;
    }
    /**
     * Set documentName value
     * @param string $documentName
     * @return \StructType\KundenportalCreateDeleteSaveOrUpdateDocumentRequest
     */
    public function setDocumentName($documentName = null)
    {
        // validation for constraint: string
        if (!is_null($documentName) && !is_string($documentName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentName, true), gettype($documentName)), __LINE__);
        }
        $this->documentName = $documentName;
        return $this;
    }
    /**
     * Get documentDate value
     * @return string|null
     */
    public function getDocumentDate()
    {
        return $this->documentDate;
    }
    /**
     * Set documentDate value
     * @param string $documentDate
     * @return \StructType\KundenportalCreateDeleteSaveOrUpdateDocumentRequest
     */
    public function setDocumentDate($documentDate = null)
    {
        // validation for constraint: string
        if (!is_null($documentDate) && !is_string($documentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentDate, true), gettype($documentDate)), __LINE__);
        }
        $this->documentDate = $documentDate;
        return $this;
    }
    /**
     * Get document value
     * @return \StructType\Attachment|null
     */
    public function getDocument()
    {
        return $this->document;
    }
    /**
     * Set document value
     * @param \StructType\Attachment $document
     * @return \StructType\KundenportalCreateDeleteSaveOrUpdateDocumentRequest
     */
    public function setDocument(\StructType\Attachment $document = null)
    {
        $this->document = $document;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\KundenportalCreateDeleteSaveOrUpdateDocumentRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
