<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for kundenportalActivationRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Kundenportal Activation Request
 * @subpackage Structs
 */
class KundenportalActivationRequest extends AbstractStructBase
{
    /**
     * The email
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $email;
    /**
     * The paoid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $paoid;
    /**
     * The electronicDocuments
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $electronicDocuments;
    /**
     * The versandersatz
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $versandersatz;
    /**
     * The newsletter
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $newsletter;
    /**
     * The neuesPasswort
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $neuesPasswort;
    /**
     * The login
     * @var \StructType\Login
     */
    public $login;
    /**
     * The telefonnummer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $telefonnummer;
    /**
     * Constructor method for kundenportalActivationRequest
     * @uses KundenportalActivationRequest::setEmail()
     * @uses KundenportalActivationRequest::setPaoid()
     * @uses KundenportalActivationRequest::setElectronicDocuments()
     * @uses KundenportalActivationRequest::setVersandersatz()
     * @uses KundenportalActivationRequest::setNewsletter()
     * @uses KundenportalActivationRequest::setNeuesPasswort()
     * @uses KundenportalActivationRequest::setLogin()
     * @uses KundenportalActivationRequest::setTelefonnummer()
     * @param string $email
     * @param string $paoid
     * @param string $electronicDocuments
     * @param bool $versandersatz
     * @param bool $newsletter
     * @param string $neuesPasswort
     * @param \StructType\Login $login
     * @param string $telefonnummer
     */
    public function __construct($email = null, $paoid = null, $electronicDocuments = null, $versandersatz = null, $newsletter = null, $neuesPasswort = null, \StructType\Login $login = null, $telefonnummer = null)
    {
        $this
            ->setEmail($email)
            ->setPaoid($paoid)
            ->setElectronicDocuments($electronicDocuments)
            ->setVersandersatz($versandersatz)
            ->setNewsletter($newsletter)
            ->setNeuesPasswort($neuesPasswort)
            ->setLogin($login)
            ->setTelefonnummer($telefonnummer);
    }
    /**
     * Get email value
     * @return string
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \StructType\KundenportalActivationRequest
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get paoid value
     * @return string
     */
    public function getPaoid()
    {
        return $this->paoid;
    }
    /**
     * Set paoid value
     * @param string $paoid
     * @return \StructType\KundenportalActivationRequest
     */
    public function setPaoid($paoid = null)
    {
        // validation for constraint: string
        if (!is_null($paoid) && !is_string($paoid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paoid, true), gettype($paoid)), __LINE__);
        }
        $this->paoid = $paoid;
        return $this;
    }
    /**
     * Get electronicDocuments value
     * @return string
     */
    public function getElectronicDocuments()
    {
        return $this->electronicDocuments;
    }
    /**
     * Set electronicDocuments value
     * @uses \EnumType\TypElektronischeDokumente::valueIsValid()
     * @uses \EnumType\TypElektronischeDokumente::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $electronicDocuments
     * @return \StructType\KundenportalActivationRequest
     */
    public function setElectronicDocuments($electronicDocuments = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TypElektronischeDokumente::valueIsValid($electronicDocuments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TypElektronischeDokumente', is_array($electronicDocuments) ? implode(', ', $electronicDocuments) : var_export($electronicDocuments, true), implode(', ', \EnumType\TypElektronischeDokumente::getValidValues())), __LINE__);
        }
        $this->electronicDocuments = $electronicDocuments;
        return $this;
    }
    /**
     * Get versandersatz value
     * @return bool
     */
    public function getVersandersatz()
    {
        return $this->versandersatz;
    }
    /**
     * Set versandersatz value
     * @param bool $versandersatz
     * @return \StructType\KundenportalActivationRequest
     */
    public function setVersandersatz($versandersatz = null)
    {
        // validation for constraint: boolean
        if (!is_null($versandersatz) && !is_bool($versandersatz)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($versandersatz, true), gettype($versandersatz)), __LINE__);
        }
        $this->versandersatz = $versandersatz;
        return $this;
    }
    /**
     * Get newsletter value
     * @return bool
     */
    public function getNewsletter()
    {
        return $this->newsletter;
    }
    /**
     * Set newsletter value
     * @param bool $newsletter
     * @return \StructType\KundenportalActivationRequest
     */
    public function setNewsletter($newsletter = null)
    {
        // validation for constraint: boolean
        if (!is_null($newsletter) && !is_bool($newsletter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($newsletter, true), gettype($newsletter)), __LINE__);
        }
        $this->newsletter = $newsletter;
        return $this;
    }
    /**
     * Get neuesPasswort value
     * @return string
     */
    public function getNeuesPasswort()
    {
        return $this->neuesPasswort;
    }
    /**
     * Set neuesPasswort value
     * @param string $neuesPasswort
     * @return \StructType\KundenportalActivationRequest
     */
    public function setNeuesPasswort($neuesPasswort = null)
    {
        // validation for constraint: string
        if (!is_null($neuesPasswort) && !is_string($neuesPasswort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($neuesPasswort, true), gettype($neuesPasswort)), __LINE__);
        }
        $this->neuesPasswort = $neuesPasswort;
        return $this;
    }
    /**
     * Get login value
     * @return \StructType\Login|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param \StructType\Login $login
     * @return \StructType\KundenportalActivationRequest
     */
    public function setLogin(\StructType\Login $login = null)
    {
        $this->login = $login;
        return $this;
    }
    /**
     * Get telefonnummer value
     * @return string|null
     */
    public function getTelefonnummer()
    {
        return $this->telefonnummer;
    }
    /**
     * Set telefonnummer value
     * @param string $telefonnummer
     * @return \StructType\KundenportalActivationRequest
     */
    public function setTelefonnummer($telefonnummer = null)
    {
        // validation for constraint: string
        if (!is_null($telefonnummer) && !is_string($telefonnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($telefonnummer, true), gettype($telefonnummer)), __LINE__);
        }
        $this->telefonnummer = $telefonnummer;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\KundenportalActivationRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
