<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for kundenPortalClaimAdviceInitial StructType
 * Meta information extracted from the WSDL
 * - documentation: Detaildatenobjekt einer Schadenmeldung im Generali Kundenportal
 * @subpackage Structs
 */
class KundenPortalClaimAdviceInitial extends AbstractStructBase
{
    /**
     * The claimCategory
     * Meta information extracted from the WSDL
     * - documentation: Schadensparte
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $claimCategory;
    /**
     * The claimSubCategory
     * Meta information extracted from the WSDL
     * - documentation: 'Leistungsmeldung für' versicherte Person in der Kranken | Schadensubkategorie für Kranken
     * - base: xsd:string
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $claimSubCategory;
    /**
     * The possibleinsuredPeople
     * Meta information extracted from the WSDL
     * - documentation: im Vertrag versicherte Personen (Name und Geburtsdatum)
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $possibleinsuredPeople;
    /**
     * The carLicenceNumber
     * Meta information extracted from the WSDL
     * - documentation: KFZ-Kennzeichen
     * - minOccurs: 0
     * @var string
     */
    public $carLicenceNumber;
    /**
     * The bankAccount
     * Meta information extracted from the WSDL
     * - documentation: Bankdaten
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\BankAccount[]
     */
    public $bankAccount;
    /**
     * The contactEmail
     * Meta information extracted from the WSDL
     * - documentation: eMailadresse für Rückfragen
     * - minOccurs: 0
     * @var string
     */
    public $contactEmail;
    /**
     * The contactPhone
     * Meta information extracted from the WSDL
     * - documentation: Telefonnummer für Rückfragen
     * - minOccurs: 0
     * @var string
     */
    public $contactPhone;
    /**
     * The forwardTo
     * Meta information extracted from the WSDL
     * - documentation: Schadenmeldung an Generali oder Betreuer schicken | weiterleiten an Betreuer oder Generali
     * - base: ns2:ForwardTo
     * @var string
     */
    public $forwardTo;
    /**
     * Constructor method for kundenPortalClaimAdviceInitial
     * @uses KundenPortalClaimAdviceInitial::setClaimCategory()
     * @uses KundenPortalClaimAdviceInitial::setClaimSubCategory()
     * @uses KundenPortalClaimAdviceInitial::setPossibleinsuredPeople()
     * @uses KundenPortalClaimAdviceInitial::setCarLicenceNumber()
     * @uses KundenPortalClaimAdviceInitial::setBankAccount()
     * @uses KundenPortalClaimAdviceInitial::setContactEmail()
     * @uses KundenPortalClaimAdviceInitial::setContactPhone()
     * @uses KundenPortalClaimAdviceInitial::setForwardTo()
     * @param string[] $claimCategory
     * @param string[] $claimSubCategory
     * @param string[] $possibleinsuredPeople
     * @param string $carLicenceNumber
     * @param \StructType\BankAccount[] $bankAccount
     * @param string $contactEmail
     * @param string $contactPhone
     * @param string $forwardTo
     */
    public function __construct(array $claimCategory = array(), array $claimSubCategory = array(), array $possibleinsuredPeople = array(), $carLicenceNumber = null, array $bankAccount = array(), $contactEmail = null, $contactPhone = null, $forwardTo = null)
    {
        $this
            ->setClaimCategory($claimCategory)
            ->setClaimSubCategory($claimSubCategory)
            ->setPossibleinsuredPeople($possibleinsuredPeople)
            ->setCarLicenceNumber($carLicenceNumber)
            ->setBankAccount($bankAccount)
            ->setContactEmail($contactEmail)
            ->setContactPhone($contactPhone)
            ->setForwardTo($forwardTo);
    }
    /**
     * Get claimCategory value
     * @return string[]|null
     */
    public function getClaimCategory()
    {
        return $this->claimCategory;
    }
    /**
     * This method is responsible for validating the values passed to the setClaimCategory method
     * This method is willingly generated in order to preserve the one-line inline validation within the setClaimCategory method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateClaimCategoryForArrayConstraintsFromSetClaimCategory(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $kundenPortalClaimAdviceInitialClaimCategoryItem) {
            // validation for constraint: enumeration
            if (!\EnumType\ClaimCategory::valueIsValid($kundenPortalClaimAdviceInitialClaimCategoryItem)) {
                $invalidValues[] = is_object($kundenPortalClaimAdviceInitialClaimCategoryItem) ? get_class($kundenPortalClaimAdviceInitialClaimCategoryItem) : sprintf('%s(%s)', gettype($kundenPortalClaimAdviceInitialClaimCategoryItem), var_export($kundenPortalClaimAdviceInitialClaimCategoryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ClaimCategory', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\ClaimCategory::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set claimCategory value
     * @uses \EnumType\ClaimCategory::valueIsValid()
     * @uses \EnumType\ClaimCategory::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $claimCategory
     * @return \StructType\KundenPortalClaimAdviceInitial
     */
    public function setClaimCategory(array $claimCategory = array())
    {
        // validation for constraint: array
        if ('' !== ($claimCategoryArrayErrorMessage = self::validateClaimCategoryForArrayConstraintsFromSetClaimCategory($claimCategory))) {
            throw new \InvalidArgumentException($claimCategoryArrayErrorMessage, __LINE__);
        }
        $this->claimCategory = $claimCategory;
        return $this;
    }
    /**
     * Add item to claimCategory value
     * @uses \EnumType\ClaimCategory::valueIsValid()
     * @uses \EnumType\ClaimCategory::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\KundenPortalClaimAdviceInitial
     */
    public function addToClaimCategory($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ClaimCategory::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ClaimCategory', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \EnumType\ClaimCategory::getValidValues())), __LINE__);
        }
        $this->claimCategory[] = $item;
        return $this;
    }
    /**
     * Get claimSubCategory value
     * @return string[]|null
     */
    public function getClaimSubCategory()
    {
        return $this->claimSubCategory;
    }
    /**
     * This method is responsible for validating the values passed to the setClaimSubCategory method
     * This method is willingly generated in order to preserve the one-line inline validation within the setClaimSubCategory method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateClaimSubCategoryForArrayConstraintsFromSetClaimSubCategory(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $kundenPortalClaimAdviceInitialClaimSubCategoryItem) {
            // validation for constraint: itemType
            if (!is_string($kundenPortalClaimAdviceInitialClaimSubCategoryItem)) {
                $invalidValues[] = is_object($kundenPortalClaimAdviceInitialClaimSubCategoryItem) ? get_class($kundenPortalClaimAdviceInitialClaimSubCategoryItem) : sprintf('%s(%s)', gettype($kundenPortalClaimAdviceInitialClaimSubCategoryItem), var_export($kundenPortalClaimAdviceInitialClaimSubCategoryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The claimSubCategory property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set claimSubCategory value
     * @throws \InvalidArgumentException
     * @param string[] $claimSubCategory
     * @return \StructType\KundenPortalClaimAdviceInitial
     */
    public function setClaimSubCategory(array $claimSubCategory = array())
    {
        // validation for constraint: array
        if ('' !== ($claimSubCategoryArrayErrorMessage = self::validateClaimSubCategoryForArrayConstraintsFromSetClaimSubCategory($claimSubCategory))) {
            throw new \InvalidArgumentException($claimSubCategoryArrayErrorMessage, __LINE__);
        }
        $this->claimSubCategory = $claimSubCategory;
        return $this;
    }
    /**
     * Add item to claimSubCategory value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\KundenPortalClaimAdviceInitial
     */
    public function addToClaimSubCategory($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The claimSubCategory property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->claimSubCategory[] = $item;
        return $this;
    }
    /**
     * Get possibleinsuredPeople value
     * @return string[]|null
     */
    public function getPossibleinsuredPeople()
    {
        return $this->possibleinsuredPeople;
    }
    /**
     * This method is responsible for validating the values passed to the setPossibleinsuredPeople method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPossibleinsuredPeople method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePossibleinsuredPeopleForArrayConstraintsFromSetPossibleinsuredPeople(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $kundenPortalClaimAdviceInitialPossibleinsuredPeopleItem) {
            // validation for constraint: itemType
            if (!is_string($kundenPortalClaimAdviceInitialPossibleinsuredPeopleItem)) {
                $invalidValues[] = is_object($kundenPortalClaimAdviceInitialPossibleinsuredPeopleItem) ? get_class($kundenPortalClaimAdviceInitialPossibleinsuredPeopleItem) : sprintf('%s(%s)', gettype($kundenPortalClaimAdviceInitialPossibleinsuredPeopleItem), var_export($kundenPortalClaimAdviceInitialPossibleinsuredPeopleItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The possibleinsuredPeople property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set possibleinsuredPeople value
     * @throws \InvalidArgumentException
     * @param string[] $possibleinsuredPeople
     * @return \StructType\KundenPortalClaimAdviceInitial
     */
    public function setPossibleinsuredPeople(array $possibleinsuredPeople = array())
    {
        // validation for constraint: array
        if ('' !== ($possibleinsuredPeopleArrayErrorMessage = self::validatePossibleinsuredPeopleForArrayConstraintsFromSetPossibleinsuredPeople($possibleinsuredPeople))) {
            throw new \InvalidArgumentException($possibleinsuredPeopleArrayErrorMessage, __LINE__);
        }
        $this->possibleinsuredPeople = $possibleinsuredPeople;
        return $this;
    }
    /**
     * Add item to possibleinsuredPeople value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\KundenPortalClaimAdviceInitial
     */
    public function addToPossibleinsuredPeople($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The possibleinsuredPeople property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->possibleinsuredPeople[] = $item;
        return $this;
    }
    /**
     * Get carLicenceNumber value
     * @return string|null
     */
    public function getCarLicenceNumber()
    {
        return $this->carLicenceNumber;
    }
    /**
     * Set carLicenceNumber value
     * @param string $carLicenceNumber
     * @return \StructType\KundenPortalClaimAdviceInitial
     */
    public function setCarLicenceNumber($carLicenceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($carLicenceNumber) && !is_string($carLicenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carLicenceNumber, true), gettype($carLicenceNumber)), __LINE__);
        }
        $this->carLicenceNumber = $carLicenceNumber;
        return $this;
    }
    /**
     * Get bankAccount value
     * @return \StructType\BankAccount[]|null
     */
    public function getBankAccount()
    {
        return $this->bankAccount;
    }
    /**
     * This method is responsible for validating the values passed to the setBankAccount method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBankAccount method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBankAccountForArrayConstraintsFromSetBankAccount(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $kundenPortalClaimAdviceInitialBankAccountItem) {
            // validation for constraint: itemType
            if (!$kundenPortalClaimAdviceInitialBankAccountItem instanceof \StructType\BankAccount) {
                $invalidValues[] = is_object($kundenPortalClaimAdviceInitialBankAccountItem) ? get_class($kundenPortalClaimAdviceInitialBankAccountItem) : sprintf('%s(%s)', gettype($kundenPortalClaimAdviceInitialBankAccountItem), var_export($kundenPortalClaimAdviceInitialBankAccountItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The bankAccount property can only contain items of type \StructType\BankAccount, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set bankAccount value
     * @throws \InvalidArgumentException
     * @param \StructType\BankAccount[] $bankAccount
     * @return \StructType\KundenPortalClaimAdviceInitial
     */
    public function setBankAccount(array $bankAccount = array())
    {
        // validation for constraint: array
        if ('' !== ($bankAccountArrayErrorMessage = self::validateBankAccountForArrayConstraintsFromSetBankAccount($bankAccount))) {
            throw new \InvalidArgumentException($bankAccountArrayErrorMessage, __LINE__);
        }
        $this->bankAccount = $bankAccount;
        return $this;
    }
    /**
     * Add item to bankAccount value
     * @throws \InvalidArgumentException
     * @param \StructType\BankAccount $item
     * @return \StructType\KundenPortalClaimAdviceInitial
     */
    public function addToBankAccount(\StructType\BankAccount $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BankAccount) {
            throw new \InvalidArgumentException(sprintf('The bankAccount property can only contain items of type \StructType\BankAccount, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->bankAccount[] = $item;
        return $this;
    }
    /**
     * Get contactEmail value
     * @return string|null
     */
    public function getContactEmail()
    {
        return $this->contactEmail;
    }
    /**
     * Set contactEmail value
     * @param string $contactEmail
     * @return \StructType\KundenPortalClaimAdviceInitial
     */
    public function setContactEmail($contactEmail = null)
    {
        // validation for constraint: string
        if (!is_null($contactEmail) && !is_string($contactEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactEmail, true), gettype($contactEmail)), __LINE__);
        }
        $this->contactEmail = $contactEmail;
        return $this;
    }
    /**
     * Get contactPhone value
     * @return string|null
     */
    public function getContactPhone()
    {
        return $this->contactPhone;
    }
    /**
     * Set contactPhone value
     * @param string $contactPhone
     * @return \StructType\KundenPortalClaimAdviceInitial
     */
    public function setContactPhone($contactPhone = null)
    {
        // validation for constraint: string
        if (!is_null($contactPhone) && !is_string($contactPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactPhone, true), gettype($contactPhone)), __LINE__);
        }
        $this->contactPhone = $contactPhone;
        return $this;
    }
    /**
     * Get forwardTo value
     * @return string|null
     */
    public function getForwardTo()
    {
        return $this->forwardTo;
    }
    /**
     * Set forwardTo value
     * @param string $forwardTo
     * @return \StructType\KundenPortalClaimAdviceInitial
     */
    public function setForwardTo($forwardTo = null)
    {
        // validation for constraint: string
        if (!is_null($forwardTo) && !is_string($forwardTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($forwardTo, true), gettype($forwardTo)), __LINE__);
        }
        $this->forwardTo = $forwardTo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\KundenPortalClaimAdviceInitial
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
