<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for kontierungszeileType StructType
 * @subpackage Structs
 */
class KontierungszeileType extends AbstractStructBase
{
    /**
     * The sektion
     * @var string
     */
    public $sektion;
    /**
     * The vermittlernummer
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 6
     * - minLength: 6
     * @var string
     */
    public $vermittlernummer;
    /**
     * The abschluss
     * Meta information extracted from the WSDL
     * - base: xs:decimal
     * - fractionDigits: 2
     * - maxInclusive: 100
     * - minInclusive: 0
     * @var float
     */
    public $abschluss;
    /**
     * The folgeBetreuung
     * Meta information extracted from the WSDL
     * - base: xs:decimal
     * - fractionDigits: 2
     * - maxInclusive: 100
     * - minInclusive: 0
     * @var float
     */
    public $folgeBetreuung;
    /**
     * The produktion
     * Meta information extracted from the WSDL
     * - base: xs:decimal
     * - fractionDigits: 2
     * - maxInclusive: 100
     * - minInclusive: 0
     * @var float
     */
    public $produktion;
    /**
     * Constructor method for kontierungszeileType
     * @uses KontierungszeileType::setSektion()
     * @uses KontierungszeileType::setVermittlernummer()
     * @uses KontierungszeileType::setAbschluss()
     * @uses KontierungszeileType::setFolgeBetreuung()
     * @uses KontierungszeileType::setProduktion()
     * @param string $sektion
     * @param string $vermittlernummer
     * @param float $abschluss
     * @param float $folgeBetreuung
     * @param float $produktion
     */
    public function __construct($sektion = null, $vermittlernummer = null, $abschluss = null, $folgeBetreuung = null, $produktion = null)
    {
        $this
            ->setSektion($sektion)
            ->setVermittlernummer($vermittlernummer)
            ->setAbschluss($abschluss)
            ->setFolgeBetreuung($folgeBetreuung)
            ->setProduktion($produktion);
    }
    /**
     * Get sektion value
     * @return string|null
     */
    public function getSektion()
    {
        return $this->sektion;
    }
    /**
     * Set sektion value
     * @uses \EnumType\SektionType::valueIsValid()
     * @uses \EnumType\SektionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sektion
     * @return \StructType\KontierungszeileType
     */
    public function setSektion($sektion = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SektionType::valueIsValid($sektion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\SektionType', is_array($sektion) ? implode(', ', $sektion) : var_export($sektion, true), implode(', ', \EnumType\SektionType::getValidValues())), __LINE__);
        }
        $this->sektion = $sektion;
        return $this;
    }
    /**
     * Get vermittlernummer value
     * @return string|null
     */
    public function getVermittlernummer()
    {
        return $this->vermittlernummer;
    }
    /**
     * Set vermittlernummer value
     * @param string $vermittlernummer
     * @return \StructType\KontierungszeileType
     */
    public function setVermittlernummer($vermittlernummer = null)
    {
        // validation for constraint: string
        if (!is_null($vermittlernummer) && !is_string($vermittlernummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vermittlernummer, true), gettype($vermittlernummer)), __LINE__);
        }
        // validation for constraint: maxLength(6)
        if (!is_null($vermittlernummer) && mb_strlen($vermittlernummer) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 6', mb_strlen($vermittlernummer)), __LINE__);
        }
        // validation for constraint: minLength(6)
        if (!is_null($vermittlernummer) && mb_strlen($vermittlernummer) < 6) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 6', mb_strlen($vermittlernummer)), __LINE__);
        }
        $this->vermittlernummer = $vermittlernummer;
        return $this;
    }
    /**
     * Get abschluss value
     * @return float|null
     */
    public function getAbschluss()
    {
        return $this->abschluss;
    }
    /**
     * Set abschluss value
     * @param float $abschluss
     * @return \StructType\KontierungszeileType
     */
    public function setAbschluss($abschluss = null)
    {
        // validation for constraint: float
        if (!is_null($abschluss) && !(is_float($abschluss) || is_numeric($abschluss))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($abschluss, true), gettype($abschluss)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($abschluss) && mb_strlen(mb_substr($abschluss, mb_strpos($abschluss, '.') + 1)) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($abschluss, true), mb_strlen(mb_substr($abschluss, mb_strpos($abschluss, '.') + 1))), __LINE__);
        }
        // validation for constraint: maxInclusive(100)
        if (!is_null($abschluss) && $abschluss > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 100', var_export($abschluss, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($abschluss) && $abschluss < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($abschluss, true)), __LINE__);
        }
        $this->abschluss = $abschluss;
        return $this;
    }
    /**
     * Get folgeBetreuung value
     * @return float|null
     */
    public function getFolgeBetreuung()
    {
        return $this->folgeBetreuung;
    }
    /**
     * Set folgeBetreuung value
     * @param float $folgeBetreuung
     * @return \StructType\KontierungszeileType
     */
    public function setFolgeBetreuung($folgeBetreuung = null)
    {
        // validation for constraint: float
        if (!is_null($folgeBetreuung) && !(is_float($folgeBetreuung) || is_numeric($folgeBetreuung))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($folgeBetreuung, true), gettype($folgeBetreuung)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($folgeBetreuung) && mb_strlen(mb_substr($folgeBetreuung, mb_strpos($folgeBetreuung, '.') + 1)) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($folgeBetreuung, true), mb_strlen(mb_substr($folgeBetreuung, mb_strpos($folgeBetreuung, '.') + 1))), __LINE__);
        }
        // validation for constraint: maxInclusive(100)
        if (!is_null($folgeBetreuung) && $folgeBetreuung > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 100', var_export($folgeBetreuung, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($folgeBetreuung) && $folgeBetreuung < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($folgeBetreuung, true)), __LINE__);
        }
        $this->folgeBetreuung = $folgeBetreuung;
        return $this;
    }
    /**
     * Get produktion value
     * @return float|null
     */
    public function getProduktion()
    {
        return $this->produktion;
    }
    /**
     * Set produktion value
     * @param float $produktion
     * @return \StructType\KontierungszeileType
     */
    public function setProduktion($produktion = null)
    {
        // validation for constraint: float
        if (!is_null($produktion) && !(is_float($produktion) || is_numeric($produktion))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($produktion, true), gettype($produktion)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($produktion) && mb_strlen(mb_substr($produktion, mb_strpos($produktion, '.') + 1)) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($produktion, true), mb_strlen(mb_substr($produktion, mb_strpos($produktion, '.') + 1))), __LINE__);
        }
        // validation for constraint: maxInclusive(100)
        if (!is_null($produktion) && $produktion > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 100', var_export($produktion, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($produktion) && $produktion < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($produktion, true)), __LINE__);
        }
        $this->produktion = $produktion;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\KontierungszeileType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
