<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Intervention StructType
 * @subpackage Structs
 */
class Intervention extends AbstractStructBase
{
    /**
     * The customerID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $customerID;
    /**
     * The claimBranch
     * @var string
     */
    public $claimBranch;
    /**
     * The shortDescription
     * @var string
     */
    public $shortDescription;
    /**
     * The detailedDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $detailedDescription;
    /**
     * The feedbackRequested
     * @var bool
     */
    public $feedbackRequested;
    /**
     * The attachment
     * Meta information extracted from the WSDL
     * - maxOccurs: 4
     * - minOccurs: 0
     * @var \StructType\Attachment[]
     */
    public $attachment;
    /**
     * Constructor method for Intervention
     * @uses Intervention::setCustomerID()
     * @uses Intervention::setClaimBranch()
     * @uses Intervention::setShortDescription()
     * @uses Intervention::setDetailedDescription()
     * @uses Intervention::setFeedbackRequested()
     * @uses Intervention::setAttachment()
     * @param int $customerID
     * @param string $claimBranch
     * @param string $shortDescription
     * @param string $detailedDescription
     * @param bool $feedbackRequested
     * @param \StructType\Attachment[] $attachment
     */
    public function __construct($customerID = null, $claimBranch = null, $shortDescription = null, $detailedDescription = null, $feedbackRequested = null, array $attachment = array())
    {
        $this
            ->setCustomerID($customerID)
            ->setClaimBranch($claimBranch)
            ->setShortDescription($shortDescription)
            ->setDetailedDescription($detailedDescription)
            ->setFeedbackRequested($feedbackRequested)
            ->setAttachment($attachment);
    }
    /**
     * Get customerID value
     * @return int|null
     */
    public function getCustomerID()
    {
        return $this->customerID;
    }
    /**
     * Set customerID value
     * @param int $customerID
     * @return \StructType\Intervention
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: int
        if (!is_null($customerID) && !(is_int($customerID) || ctype_digit($customerID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerID, true), gettype($customerID)), __LINE__);
        }
        $this->customerID = $customerID;
        return $this;
    }
    /**
     * Get claimBranch value
     * @return string|null
     */
    public function getClaimBranch()
    {
        return $this->claimBranch;
    }
    /**
     * Set claimBranch value
     * @uses \EnumType\IVClaimBranch::valueIsValid()
     * @uses \EnumType\IVClaimBranch::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $claimBranch
     * @return \StructType\Intervention
     */
    public function setClaimBranch($claimBranch = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\IVClaimBranch::valueIsValid($claimBranch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\IVClaimBranch', is_array($claimBranch) ? implode(', ', $claimBranch) : var_export($claimBranch, true), implode(', ', \EnumType\IVClaimBranch::getValidValues())), __LINE__);
        }
        $this->claimBranch = $claimBranch;
        return $this;
    }
    /**
     * Get shortDescription value
     * @return string|null
     */
    public function getShortDescription()
    {
        return $this->shortDescription;
    }
    /**
     * Set shortDescription value
     * @param string $shortDescription
     * @return \StructType\Intervention
     */
    public function setShortDescription($shortDescription = null)
    {
        // validation for constraint: string
        if (!is_null($shortDescription) && !is_string($shortDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shortDescription, true), gettype($shortDescription)), __LINE__);
        }
        $this->shortDescription = $shortDescription;
        return $this;
    }
    /**
     * Get detailedDescription value
     * @return string|null
     */
    public function getDetailedDescription()
    {
        return $this->detailedDescription;
    }
    /**
     * Set detailedDescription value
     * @param string $detailedDescription
     * @return \StructType\Intervention
     */
    public function setDetailedDescription($detailedDescription = null)
    {
        // validation for constraint: string
        if (!is_null($detailedDescription) && !is_string($detailedDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($detailedDescription, true), gettype($detailedDescription)), __LINE__);
        }
        $this->detailedDescription = $detailedDescription;
        return $this;
    }
    /**
     * Get feedbackRequested value
     * @return bool|null
     */
    public function getFeedbackRequested()
    {
        return $this->feedbackRequested;
    }
    /**
     * Set feedbackRequested value
     * @param bool $feedbackRequested
     * @return \StructType\Intervention
     */
    public function setFeedbackRequested($feedbackRequested = null)
    {
        // validation for constraint: boolean
        if (!is_null($feedbackRequested) && !is_bool($feedbackRequested)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($feedbackRequested, true), gettype($feedbackRequested)), __LINE__);
        }
        $this->feedbackRequested = $feedbackRequested;
        return $this;
    }
    /**
     * Get attachment value
     * @return \StructType\Attachment[]|null
     */
    public function getAttachment()
    {
        return $this->attachment;
    }
    /**
     * This method is responsible for validating the values passed to the setAttachment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAttachment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAttachmentForArrayConstraintsFromSetAttachment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $interventionAttachmentItem) {
            // validation for constraint: itemType
            if (!$interventionAttachmentItem instanceof \StructType\Attachment) {
                $invalidValues[] = is_object($interventionAttachmentItem) ? get_class($interventionAttachmentItem) : sprintf('%s(%s)', gettype($interventionAttachmentItem), var_export($interventionAttachmentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The attachment property can only contain items of type \StructType\Attachment, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set attachment value
     * @throws \InvalidArgumentException
     * @param \StructType\Attachment[] $attachment
     * @return \StructType\Intervention
     */
    public function setAttachment(array $attachment = array())
    {
        // validation for constraint: array
        if ('' !== ($attachmentArrayErrorMessage = self::validateAttachmentForArrayConstraintsFromSetAttachment($attachment))) {
            throw new \InvalidArgumentException($attachmentArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(4)
        if (is_array($attachment) && count($attachment) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 4', count($attachment)), __LINE__);
        }
        $this->attachment = $attachment;
        return $this;
    }
    /**
     * Add item to attachment value
     * @throws \InvalidArgumentException
     * @param \StructType\Attachment $item
     * @return \StructType\Intervention
     */
    public function addToAttachment(\StructType\Attachment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Attachment) {
            throw new \InvalidArgumentException(sprintf('The attachment property can only contain items of type \StructType\Attachment, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(4)
        if (is_array($this->attachment) && count($this->attachment) >= 4) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 4', count($this->attachment)), __LINE__);
        }
        $this->attachment[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Intervention
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
