<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for History StructType
 * Meta information extracted from the WSDL
 * - documentation: Historyobjekt eines Geschäftsfalles. Dessen Statusänderungen werden hier Dokumentiert.
 * @subpackage Structs
 */
class History extends AbstractStructBase
{
    /**
     * The businessCaseNumber
     * Meta information extracted from the WSDL
     * - documentation: ID des Geschäftsfalles in der eVP
     * @var int
     */
    public $businessCaseNumber;
    /**
     * The applicationNumber
     * Meta information extracted from the WSDL
     * - documentation: Antragsnummer
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $applicationNumber;
    /**
     * The historyID
     * Meta information extracted from the WSDL
     * - documentation: ID des Geschäftsfalles in der eVP
     * @var int
     */
    public $historyID;
    /**
     * The state
     * Meta information extracted from the WSDL
     * - documentation: Status des Geschäftsfalles nach dem Eintrag in der History
     * @var string
     */
    public $state;
    /**
     * The stateID
     * Meta information extracted from the WSDL
     * - documentation: ID des Geschäftfallstatus in der History 90, Vorschlag gespeichert 10, Antrag gespeichert 100, Antrag aus Evidenz entfernt 111, Antrag unterschrieben 112, Antrag uebertragen 113, Antrag polizziert 114, Antrag empfangen 115, Antrag
     * abgelehnt 116, Antrag fehlerhaft 117, Antrag erfasst, 118 Antrag storniert
     * @var string
     */
    public $stateID;
    /**
     * The historyDate
     * Meta information extracted from the WSDL
     * - documentation: Erstellungsdatum des History-Eintrages
     * - minOccurs: 0
     * @var string
     */
    public $historyDate;
    /**
     * The firstName
     * Meta information extracted from the WSDL
     * - documentation: Vorname des Users der den History-Eintrag gemacht hat
     * - minOccurs: 0
     * @var string
     */
    public $firstName;
    /**
     * The sureName
     * Meta information extracted from the WSDL
     * - documentation: Nachname des Users der den History-Eintrag gemacht hat
     * - minOccurs: 0
     * @var string
     */
    public $sureName;
    /**
     * The userID
     * Meta information extracted from the WSDL
     * - documentation: userID des Users der den History-Eintrag gemacht hat
     * - base: xsd:string
     * - maxLength: 50
     * - minOccurs: 0
     * @var string
     */
    public $userID;
    /**
     * The eMail
     * Meta information extracted from the WSDL
     * - documentation: eMail-Adresse des Users der den History-Eintrag gemacht hat
     * - base: xsd:string
     * - maxLength: 100
     * - minOccurs: 0
     * @var string
     */
    public $eMail;
    /**
     * The comment
     * Meta information extracted from the WSDL
     * - documentation: Kommentar zum History-Eintrag. z.B. Polizzennummer
     * - base: xsd:string
     * - maxLength: 600
     * - minOccurs: 0
     * @var string
     */
    public $comment;
    /**
     * The contractData
     * Meta information extracted from the WSDL
     * - documentation: Polizzennummer zum Geschäftsfall
     * - minOccurs: 0
     * @var \StructType\HistoryContract
     */
    public $contractData;
    /**
     * The esamData
     * Meta information extracted from the WSDL
     * - documentation: Polizzennummer zum Geschäftsfall
     * - minOccurs: 0
     * @var \StructType\HistoryEsam
     */
    public $esamData;
    /**
     * The agentNumber
     * Meta information extracted from the WSDL
     * - documentation: Vermittlernummer
     * - base: xsd:string
     * - maxLength: 6
     * - minOccurs: 0
     * @var string
     */
    public $agentNumber;
    /**
     * The refusalReason
     * Meta information extracted from the WSDL
     * - documentation: Ablehnungsgrund
     * - base: xsd:string
     * - maxLength: 100
     * - minOccurs: 0
     * @var string
     */
    public $refusalReason;
    /**
     * Constructor method for History
     * @uses History::setBusinessCaseNumber()
     * @uses History::setApplicationNumber()
     * @uses History::setHistoryID()
     * @uses History::setState()
     * @uses History::setStateID()
     * @uses History::setHistoryDate()
     * @uses History::setFirstName()
     * @uses History::setSureName()
     * @uses History::setUserID()
     * @uses History::setEMail()
     * @uses History::setComment()
     * @uses History::setContractData()
     * @uses History::setEsamData()
     * @uses History::setAgentNumber()
     * @uses History::setRefusalReason()
     * @param int $businessCaseNumber
     * @param int $applicationNumber
     * @param int $historyID
     * @param string $state
     * @param string $stateID
     * @param string $historyDate
     * @param string $firstName
     * @param string $sureName
     * @param string $userID
     * @param string $eMail
     * @param string $comment
     * @param \StructType\HistoryContract $contractData
     * @param \StructType\HistoryEsam $esamData
     * @param string $agentNumber
     * @param string $refusalReason
     */
    public function __construct($businessCaseNumber = null, $applicationNumber = null, $historyID = null, $state = null, $stateID = null, $historyDate = null, $firstName = null, $sureName = null, $userID = null, $eMail = null, $comment = null, \StructType\HistoryContract $contractData = null, \StructType\HistoryEsam $esamData = null, $agentNumber = null, $refusalReason = null)
    {
        $this
            ->setBusinessCaseNumber($businessCaseNumber)
            ->setApplicationNumber($applicationNumber)
            ->setHistoryID($historyID)
            ->setState($state)
            ->setStateID($stateID)
            ->setHistoryDate($historyDate)
            ->setFirstName($firstName)
            ->setSureName($sureName)
            ->setUserID($userID)
            ->setEMail($eMail)
            ->setComment($comment)
            ->setContractData($contractData)
            ->setEsamData($esamData)
            ->setAgentNumber($agentNumber)
            ->setRefusalReason($refusalReason);
    }
    /**
     * Get businessCaseNumber value
     * @return int|null
     */
    public function getBusinessCaseNumber()
    {
        return $this->businessCaseNumber;
    }
    /**
     * Set businessCaseNumber value
     * @param int $businessCaseNumber
     * @return \StructType\History
     */
    public function setBusinessCaseNumber($businessCaseNumber = null)
    {
        // validation for constraint: int
        if (!is_null($businessCaseNumber) && !(is_int($businessCaseNumber) || ctype_digit($businessCaseNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($businessCaseNumber, true), gettype($businessCaseNumber)), __LINE__);
        }
        $this->businessCaseNumber = $businessCaseNumber;
        return $this;
    }
    /**
     * Get applicationNumber value
     * @return int|null
     */
    public function getApplicationNumber()
    {
        return $this->applicationNumber;
    }
    /**
     * Set applicationNumber value
     * @param int $applicationNumber
     * @return \StructType\History
     */
    public function setApplicationNumber($applicationNumber = null)
    {
        // validation for constraint: int
        if (!is_null($applicationNumber) && !(is_int($applicationNumber) || ctype_digit($applicationNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($applicationNumber, true), gettype($applicationNumber)), __LINE__);
        }
        $this->applicationNumber = $applicationNumber;
        return $this;
    }
    /**
     * Get historyID value
     * @return int|null
     */
    public function getHistoryID()
    {
        return $this->historyID;
    }
    /**
     * Set historyID value
     * @param int $historyID
     * @return \StructType\History
     */
    public function setHistoryID($historyID = null)
    {
        // validation for constraint: int
        if (!is_null($historyID) && !(is_int($historyID) || ctype_digit($historyID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($historyID, true), gettype($historyID)), __LINE__);
        }
        $this->historyID = $historyID;
        return $this;
    }
    /**
     * Get state value
     * @return string|null
     */
    public function getState()
    {
        return $this->state;
    }
    /**
     * Set state value
     * @param string $state
     * @return \StructType\History
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($state, true), gettype($state)), __LINE__);
        }
        $this->state = $state;
        return $this;
    }
    /**
     * Get stateID value
     * @return string|null
     */
    public function getStateID()
    {
        return $this->stateID;
    }
    /**
     * Set stateID value
     * @param string $stateID
     * @return \StructType\History
     */
    public function setStateID($stateID = null)
    {
        // validation for constraint: string
        if (!is_null($stateID) && !is_string($stateID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stateID, true), gettype($stateID)), __LINE__);
        }
        $this->stateID = $stateID;
        return $this;
    }
    /**
     * Get historyDate value
     * @return string|null
     */
    public function getHistoryDate()
    {
        return $this->historyDate;
    }
    /**
     * Set historyDate value
     * @param string $historyDate
     * @return \StructType\History
     */
    public function setHistoryDate($historyDate = null)
    {
        // validation for constraint: string
        if (!is_null($historyDate) && !is_string($historyDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($historyDate, true), gettype($historyDate)), __LINE__);
        }
        $this->historyDate = $historyDate;
        return $this;
    }
    /**
     * Get firstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->firstName;
    }
    /**
     * Set firstName value
     * @param string $firstName
     * @return \StructType\History
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        $this->firstName = $firstName;
        return $this;
    }
    /**
     * Get sureName value
     * @return string|null
     */
    public function getSureName()
    {
        return $this->sureName;
    }
    /**
     * Set sureName value
     * @param string $sureName
     * @return \StructType\History
     */
    public function setSureName($sureName = null)
    {
        // validation for constraint: string
        if (!is_null($sureName) && !is_string($sureName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sureName, true), gettype($sureName)), __LINE__);
        }
        $this->sureName = $sureName;
        return $this;
    }
    /**
     * Get userID value
     * @return string|null
     */
    public function getUserID()
    {
        return $this->userID;
    }
    /**
     * Set userID value
     * @param string $userID
     * @return \StructType\History
     */
    public function setUserID($userID = null)
    {
        // validation for constraint: string
        if (!is_null($userID) && !is_string($userID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userID, true), gettype($userID)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($userID) && mb_strlen($userID) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($userID)), __LINE__);
        }
        $this->userID = $userID;
        return $this;
    }
    /**
     * Get eMail value
     * @return string|null
     */
    public function getEMail()
    {
        return $this->eMail;
    }
    /**
     * Set eMail value
     * @param string $eMail
     * @return \StructType\History
     */
    public function setEMail($eMail = null)
    {
        // validation for constraint: string
        if (!is_null($eMail) && !is_string($eMail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eMail, true), gettype($eMail)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($eMail) && mb_strlen($eMail) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($eMail)), __LINE__);
        }
        $this->eMail = $eMail;
        return $this;
    }
    /**
     * Get comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->comment;
    }
    /**
     * Set comment value
     * @param string $comment
     * @return \StructType\History
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment, true), gettype($comment)), __LINE__);
        }
        // validation for constraint: maxLength(600)
        if (!is_null($comment) && mb_strlen($comment) > 600) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 600', mb_strlen($comment)), __LINE__);
        }
        $this->comment = $comment;
        return $this;
    }
    /**
     * Get contractData value
     * @return \StructType\HistoryContract|null
     */
    public function getContractData()
    {
        return $this->contractData;
    }
    /**
     * Set contractData value
     * @param \StructType\HistoryContract $contractData
     * @return \StructType\History
     */
    public function setContractData(\StructType\HistoryContract $contractData = null)
    {
        $this->contractData = $contractData;
        return $this;
    }
    /**
     * Get esamData value
     * @return \StructType\HistoryEsam|null
     */
    public function getEsamData()
    {
        return $this->esamData;
    }
    /**
     * Set esamData value
     * @param \StructType\HistoryEsam $esamData
     * @return \StructType\History
     */
    public function setEsamData(\StructType\HistoryEsam $esamData = null)
    {
        $this->esamData = $esamData;
        return $this;
    }
    /**
     * Get agentNumber value
     * @return string|null
     */
    public function getAgentNumber()
    {
        return $this->agentNumber;
    }
    /**
     * Set agentNumber value
     * @param string $agentNumber
     * @return \StructType\History
     */
    public function setAgentNumber($agentNumber = null)
    {
        // validation for constraint: string
        if (!is_null($agentNumber) && !is_string($agentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agentNumber, true), gettype($agentNumber)), __LINE__);
        }
        // validation for constraint: maxLength(6)
        if (!is_null($agentNumber) && mb_strlen($agentNumber) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 6', mb_strlen($agentNumber)), __LINE__);
        }
        $this->agentNumber = $agentNumber;
        return $this;
    }
    /**
     * Get refusalReason value
     * @return string|null
     */
    public function getRefusalReason()
    {
        return $this->refusalReason;
    }
    /**
     * Set refusalReason value
     * @param string $refusalReason
     * @return \StructType\History
     */
    public function setRefusalReason($refusalReason = null)
    {
        // validation for constraint: string
        if (!is_null($refusalReason) && !is_string($refusalReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refusalReason, true), gettype($refusalReason)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($refusalReason) && mb_strlen($refusalReason) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($refusalReason)), __LINE__);
        }
        $this->refusalReason = $refusalReason;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\History
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
