<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for haftpflichtType StructType
 * @subpackage Structs
 */
class HaftpflichtType extends AbstractStructBase
{
    /**
     * The bonusMalusStufe
     * @var string
     */
    public $bonusMalusStufe;
    /**
     * The tarifvariante
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tarifvariante;
    /**
     * The pauschalsumme
     * @var string
     */
    public $pauschalsumme;
    /**
     * The schadenersatzbeitrag
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $schadenersatzbeitrag;
    /**
     * The deckungserweiterungTuerkei
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $deckungserweiterungTuerkei;
    /**
     * The deckungserweiterungRussland
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $deckungserweiterungRussland;
    /**
     * The tipUndTatKfzAktiv
     * Meta information extracted from the WSDL
     * - documentation: Wenn die Sparte Kasko ebenfalls gewählt wird, dann gibt es dieses Feld nur bei der Kasko
     * - minOccurs: 0
     * @var string
     */
    public $tipUndTatKfzAktiv;
    /**
     * The tipUndTatReparaturkosten
     * Meta information extracted from the WSDL
     * - documentation: Wenn die Sparte Kasko ebenfalls gewählt wird, dann gibt es dieses Feld nur bei der Kasko. Das Feld ist nur aktiv, wenn 'tipUndTatKfzAktiv' gewählt ist.
     * - minOccurs: 0
     * @var string
     */
    public $tipUndTatReparaturkosten;
    /**
     * The tipUndTatReparaturkostenSelbstbeteiligung
     * Meta information extracted from the WSDL
     * - documentation: Wenn die Sparte Kasko ebenfalls gewählt wird, dann gibt es dieses Feld nur bei der Kasko. Das Feld ist nur aktiv, wenn 'tipUndTatReparatur' gewählt ist.
     * - minOccurs: 0
     * @var int
     */
    public $tipUndTatReparaturkostenSelbstbeteiligung;
    /**
     * The kfzEuropaschutz
     * Meta information extracted from the WSDL
     * - documentation: Wenn die Sparte Kasko ebenfalls gewählt wird, dann gibt es dieses Feld nur bei der Kasko
     * - minOccurs: 0
     * @var string
     */
    public $kfzEuropaschutz;
    /**
     * The bonusjoker
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $bonusjoker;
    /**
     * Constructor method for haftpflichtType
     * @uses HaftpflichtType::setBonusMalusStufe()
     * @uses HaftpflichtType::setTarifvariante()
     * @uses HaftpflichtType::setPauschalsumme()
     * @uses HaftpflichtType::setSchadenersatzbeitrag()
     * @uses HaftpflichtType::setDeckungserweiterungTuerkei()
     * @uses HaftpflichtType::setDeckungserweiterungRussland()
     * @uses HaftpflichtType::setTipUndTatKfzAktiv()
     * @uses HaftpflichtType::setTipUndTatReparaturkosten()
     * @uses HaftpflichtType::setTipUndTatReparaturkostenSelbstbeteiligung()
     * @uses HaftpflichtType::setKfzEuropaschutz()
     * @uses HaftpflichtType::setBonusjoker()
     * @param string $bonusMalusStufe
     * @param string $tarifvariante
     * @param string $pauschalsumme
     * @param string $schadenersatzbeitrag
     * @param string $deckungserweiterungTuerkei
     * @param string $deckungserweiterungRussland
     * @param string $tipUndTatKfzAktiv
     * @param string $tipUndTatReparaturkosten
     * @param int $tipUndTatReparaturkostenSelbstbeteiligung
     * @param string $kfzEuropaschutz
     * @param string $bonusjoker
     */
    public function __construct($bonusMalusStufe = null, $tarifvariante = null, $pauschalsumme = null, $schadenersatzbeitrag = null, $deckungserweiterungTuerkei = null, $deckungserweiterungRussland = null, $tipUndTatKfzAktiv = null, $tipUndTatReparaturkosten = null, $tipUndTatReparaturkostenSelbstbeteiligung = null, $kfzEuropaschutz = null, $bonusjoker = null)
    {
        $this
            ->setBonusMalusStufe($bonusMalusStufe)
            ->setTarifvariante($tarifvariante)
            ->setPauschalsumme($pauschalsumme)
            ->setSchadenersatzbeitrag($schadenersatzbeitrag)
            ->setDeckungserweiterungTuerkei($deckungserweiterungTuerkei)
            ->setDeckungserweiterungRussland($deckungserweiterungRussland)
            ->setTipUndTatKfzAktiv($tipUndTatKfzAktiv)
            ->setTipUndTatReparaturkosten($tipUndTatReparaturkosten)
            ->setTipUndTatReparaturkostenSelbstbeteiligung($tipUndTatReparaturkostenSelbstbeteiligung)
            ->setKfzEuropaschutz($kfzEuropaschutz)
            ->setBonusjoker($bonusjoker);
    }
    /**
     * Get bonusMalusStufe value
     * @return string|null
     */
    public function getBonusMalusStufe()
    {
        return $this->bonusMalusStufe;
    }
    /**
     * Set bonusMalusStufe value
     * @uses \EnumType\BonusMalusstufeType::valueIsValid()
     * @uses \EnumType\BonusMalusstufeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $bonusMalusStufe
     * @return \StructType\HaftpflichtType
     */
    public function setBonusMalusStufe($bonusMalusStufe = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\BonusMalusstufeType::valueIsValid($bonusMalusStufe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\BonusMalusstufeType', is_array($bonusMalusStufe) ? implode(', ', $bonusMalusStufe) : var_export($bonusMalusStufe, true), implode(', ', \EnumType\BonusMalusstufeType::getValidValues())), __LINE__);
        }
        $this->bonusMalusStufe = $bonusMalusStufe;
        return $this;
    }
    /**
     * Get tarifvariante value
     * @return string|null
     */
    public function getTarifvariante()
    {
        return $this->tarifvariante;
    }
    /**
     * Set tarifvariante value
     * @uses \EnumType\TarifvarianteType::valueIsValid()
     * @uses \EnumType\TarifvarianteType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tarifvariante
     * @return \StructType\HaftpflichtType
     */
    public function setTarifvariante($tarifvariante = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TarifvarianteType::valueIsValid($tarifvariante)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TarifvarianteType', is_array($tarifvariante) ? implode(', ', $tarifvariante) : var_export($tarifvariante, true), implode(', ', \EnumType\TarifvarianteType::getValidValues())), __LINE__);
        }
        $this->tarifvariante = $tarifvariante;
        return $this;
    }
    /**
     * Get pauschalsumme value
     * @return string|null
     */
    public function getPauschalsumme()
    {
        return $this->pauschalsumme;
    }
    /**
     * Set pauschalsumme value
     * @uses \EnumType\PauschalsummeType::valueIsValid()
     * @uses \EnumType\PauschalsummeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pauschalsumme
     * @return \StructType\HaftpflichtType
     */
    public function setPauschalsumme($pauschalsumme = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PauschalsummeType::valueIsValid($pauschalsumme)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PauschalsummeType', is_array($pauschalsumme) ? implode(', ', $pauschalsumme) : var_export($pauschalsumme, true), implode(', ', \EnumType\PauschalsummeType::getValidValues())), __LINE__);
        }
        $this->pauschalsumme = $pauschalsumme;
        return $this;
    }
    /**
     * Get schadenersatzbeitrag value
     * @return string|null
     */
    public function getSchadenersatzbeitrag()
    {
        return $this->schadenersatzbeitrag;
    }
    /**
     * Set schadenersatzbeitrag value
     * @uses \EnumType\SchadenersatzbeitragType::valueIsValid()
     * @uses \EnumType\SchadenersatzbeitragType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $schadenersatzbeitrag
     * @return \StructType\HaftpflichtType
     */
    public function setSchadenersatzbeitrag($schadenersatzbeitrag = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SchadenersatzbeitragType::valueIsValid($schadenersatzbeitrag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\SchadenersatzbeitragType', is_array($schadenersatzbeitrag) ? implode(', ', $schadenersatzbeitrag) : var_export($schadenersatzbeitrag, true), implode(', ', \EnumType\SchadenersatzbeitragType::getValidValues())), __LINE__);
        }
        $this->schadenersatzbeitrag = $schadenersatzbeitrag;
        return $this;
    }
    /**
     * Get deckungserweiterungTuerkei value
     * @return string|null
     */
    public function getDeckungserweiterungTuerkei()
    {
        return $this->deckungserweiterungTuerkei;
    }
    /**
     * Set deckungserweiterungTuerkei value
     * @uses \EnumType\JaNeinType::valueIsValid()
     * @uses \EnumType\JaNeinType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deckungserweiterungTuerkei
     * @return \StructType\HaftpflichtType
     */
    public function setDeckungserweiterungTuerkei($deckungserweiterungTuerkei = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JaNeinType::valueIsValid($deckungserweiterungTuerkei)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JaNeinType', is_array($deckungserweiterungTuerkei) ? implode(', ', $deckungserweiterungTuerkei) : var_export($deckungserweiterungTuerkei, true), implode(', ', \EnumType\JaNeinType::getValidValues())), __LINE__);
        }
        $this->deckungserweiterungTuerkei = $deckungserweiterungTuerkei;
        return $this;
    }
    /**
     * Get deckungserweiterungRussland value
     * @return string|null
     */
    public function getDeckungserweiterungRussland()
    {
        return $this->deckungserweiterungRussland;
    }
    /**
     * Set deckungserweiterungRussland value
     * @uses \EnumType\JaNeinType::valueIsValid()
     * @uses \EnumType\JaNeinType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deckungserweiterungRussland
     * @return \StructType\HaftpflichtType
     */
    public function setDeckungserweiterungRussland($deckungserweiterungRussland = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JaNeinType::valueIsValid($deckungserweiterungRussland)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JaNeinType', is_array($deckungserweiterungRussland) ? implode(', ', $deckungserweiterungRussland) : var_export($deckungserweiterungRussland, true), implode(', ', \EnumType\JaNeinType::getValidValues())), __LINE__);
        }
        $this->deckungserweiterungRussland = $deckungserweiterungRussland;
        return $this;
    }
    /**
     * Get tipUndTatKfzAktiv value
     * @return string|null
     */
    public function getTipUndTatKfzAktiv()
    {
        return $this->tipUndTatKfzAktiv;
    }
    /**
     * Set tipUndTatKfzAktiv value
     * @uses \EnumType\JaNeinType::valueIsValid()
     * @uses \EnumType\JaNeinType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tipUndTatKfzAktiv
     * @return \StructType\HaftpflichtType
     */
    public function setTipUndTatKfzAktiv($tipUndTatKfzAktiv = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JaNeinType::valueIsValid($tipUndTatKfzAktiv)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JaNeinType', is_array($tipUndTatKfzAktiv) ? implode(', ', $tipUndTatKfzAktiv) : var_export($tipUndTatKfzAktiv, true), implode(', ', \EnumType\JaNeinType::getValidValues())), __LINE__);
        }
        $this->tipUndTatKfzAktiv = $tipUndTatKfzAktiv;
        return $this;
    }
    /**
     * Get tipUndTatReparaturkosten value
     * @return string|null
     */
    public function getTipUndTatReparaturkosten()
    {
        return $this->tipUndTatReparaturkosten;
    }
    /**
     * Set tipUndTatReparaturkosten value
     * @uses \EnumType\JaNeinType::valueIsValid()
     * @uses \EnumType\JaNeinType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tipUndTatReparaturkosten
     * @return \StructType\HaftpflichtType
     */
    public function setTipUndTatReparaturkosten($tipUndTatReparaturkosten = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JaNeinType::valueIsValid($tipUndTatReparaturkosten)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JaNeinType', is_array($tipUndTatReparaturkosten) ? implode(', ', $tipUndTatReparaturkosten) : var_export($tipUndTatReparaturkosten, true), implode(', ', \EnumType\JaNeinType::getValidValues())), __LINE__);
        }
        $this->tipUndTatReparaturkosten = $tipUndTatReparaturkosten;
        return $this;
    }
    /**
     * Get tipUndTatReparaturkostenSelbstbeteiligung value
     * @return int|null
     */
    public function getTipUndTatReparaturkostenSelbstbeteiligung()
    {
        return $this->tipUndTatReparaturkostenSelbstbeteiligung;
    }
    /**
     * Set tipUndTatReparaturkostenSelbstbeteiligung value
     * @param int $tipUndTatReparaturkostenSelbstbeteiligung
     * @return \StructType\HaftpflichtType
     */
    public function setTipUndTatReparaturkostenSelbstbeteiligung($tipUndTatReparaturkostenSelbstbeteiligung = null)
    {
        // validation for constraint: int
        if (!is_null($tipUndTatReparaturkostenSelbstbeteiligung) && !(is_int($tipUndTatReparaturkostenSelbstbeteiligung) || ctype_digit($tipUndTatReparaturkostenSelbstbeteiligung))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tipUndTatReparaturkostenSelbstbeteiligung, true), gettype($tipUndTatReparaturkostenSelbstbeteiligung)), __LINE__);
        }
        $this->tipUndTatReparaturkostenSelbstbeteiligung = $tipUndTatReparaturkostenSelbstbeteiligung;
        return $this;
    }
    /**
     * Get kfzEuropaschutz value
     * @return string|null
     */
    public function getKfzEuropaschutz()
    {
        return $this->kfzEuropaschutz;
    }
    /**
     * Set kfzEuropaschutz value
     * @uses \EnumType\JaNeinType::valueIsValid()
     * @uses \EnumType\JaNeinType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $kfzEuropaschutz
     * @return \StructType\HaftpflichtType
     */
    public function setKfzEuropaschutz($kfzEuropaschutz = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JaNeinType::valueIsValid($kfzEuropaschutz)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JaNeinType', is_array($kfzEuropaschutz) ? implode(', ', $kfzEuropaschutz) : var_export($kfzEuropaschutz, true), implode(', ', \EnumType\JaNeinType::getValidValues())), __LINE__);
        }
        $this->kfzEuropaschutz = $kfzEuropaschutz;
        return $this;
    }
    /**
     * Get bonusjoker value
     * @return string|null
     */
    public function getBonusjoker()
    {
        return $this->bonusjoker;
    }
    /**
     * Set bonusjoker value
     * @uses \EnumType\JaNeinType::valueIsValid()
     * @uses \EnumType\JaNeinType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $bonusjoker
     * @return \StructType\HaftpflichtType
     */
    public function setBonusjoker($bonusjoker = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JaNeinType::valueIsValid($bonusjoker)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JaNeinType', is_array($bonusjoker) ? implode(', ', $bonusjoker) : var_export($bonusjoker, true), implode(', ', \EnumType\JaNeinType::getValidValues())), __LINE__);
        }
        $this->bonusjoker = $bonusjoker;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HaftpflichtType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
