<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getZeusDatenRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Request for getting ZEUS information (see details for search critierias). This service is only available in the generali intranet
 * @subpackage Structs
 */
class GetZeusDatenRequest extends AbstractStructBase
{
    /**
     * The login
     * Meta information extracted from the WSDL
     * - documentation: login data of user
     * @var \StructType\Login
     */
    public $login;
    /**
     * The licencePlate
     * Meta information extracted from the WSDL
     * - documentation: licence number of the car
     * - minOccurs: 0
     * @var string
     */
    public $licencePlate;
    /**
     * The vbNumber
     * Meta information extracted from the WSDL
     * - documentation: vb number of the car
     * - minOccurs: 0
     * @var string
     */
    public $vbNumber;
    /**
     * The carSerialNumber
     * Meta information extracted from the WSDL
     * - documentation: serial number of the car
     * - minOccurs: 0
     * @var string
     */
    public $carSerialNumber;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - documentation: zunameVorname
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The lastModified
     * Meta information extracted from the WSDL
     * - documentation: lastModified
     * - minOccurs: 0
     * @var string
     */
    public $lastModified;
    /**
     * The maxCount
     * Meta information extracted from the WSDL
     * - documentation: maximum count of entries, which will be returned. (max 150)
     * @var int
     */
    public $maxCount;
    /**
     * The searchSource
     * Meta information extracted from the WSDL
     * - default: database
     * - minOccurs: 0
     * @var string
     */
    public $searchSource;
    /**
     * Constructor method for getZeusDatenRequest
     * @uses GetZeusDatenRequest::setLogin()
     * @uses GetZeusDatenRequest::setLicencePlate()
     * @uses GetZeusDatenRequest::setVbNumber()
     * @uses GetZeusDatenRequest::setCarSerialNumber()
     * @uses GetZeusDatenRequest::setName()
     * @uses GetZeusDatenRequest::setLastModified()
     * @uses GetZeusDatenRequest::setMaxCount()
     * @uses GetZeusDatenRequest::setSearchSource()
     * @param \StructType\Login $login
     * @param string $licencePlate
     * @param string $vbNumber
     * @param string $carSerialNumber
     * @param string $name
     * @param string $lastModified
     * @param int $maxCount
     * @param string $searchSource
     */
    public function __construct(\StructType\Login $login = null, $licencePlate = null, $vbNumber = null, $carSerialNumber = null, $name = null, $lastModified = null, $maxCount = null, $searchSource = 'database')
    {
        $this
            ->setLogin($login)
            ->setLicencePlate($licencePlate)
            ->setVbNumber($vbNumber)
            ->setCarSerialNumber($carSerialNumber)
            ->setName($name)
            ->setLastModified($lastModified)
            ->setMaxCount($maxCount)
            ->setSearchSource($searchSource);
    }
    /**
     * Get login value
     * @return \StructType\Login|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param \StructType\Login $login
     * @return \StructType\GetZeusDatenRequest
     */
    public function setLogin(\StructType\Login $login = null)
    {
        $this->login = $login;
        return $this;
    }
    /**
     * Get licencePlate value
     * @return string|null
     */
    public function getLicencePlate()
    {
        return $this->licencePlate;
    }
    /**
     * Set licencePlate value
     * @param string $licencePlate
     * @return \StructType\GetZeusDatenRequest
     */
    public function setLicencePlate($licencePlate = null)
    {
        // validation for constraint: string
        if (!is_null($licencePlate) && !is_string($licencePlate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($licencePlate, true), gettype($licencePlate)), __LINE__);
        }
        $this->licencePlate = $licencePlate;
        return $this;
    }
    /**
     * Get vbNumber value
     * @return string|null
     */
    public function getVbNumber()
    {
        return $this->vbNumber;
    }
    /**
     * Set vbNumber value
     * @param string $vbNumber
     * @return \StructType\GetZeusDatenRequest
     */
    public function setVbNumber($vbNumber = null)
    {
        // validation for constraint: string
        if (!is_null($vbNumber) && !is_string($vbNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vbNumber, true), gettype($vbNumber)), __LINE__);
        }
        $this->vbNumber = $vbNumber;
        return $this;
    }
    /**
     * Get carSerialNumber value
     * @return string|null
     */
    public function getCarSerialNumber()
    {
        return $this->carSerialNumber;
    }
    /**
     * Set carSerialNumber value
     * @param string $carSerialNumber
     * @return \StructType\GetZeusDatenRequest
     */
    public function setCarSerialNumber($carSerialNumber = null)
    {
        // validation for constraint: string
        if (!is_null($carSerialNumber) && !is_string($carSerialNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carSerialNumber, true), gettype($carSerialNumber)), __LINE__);
        }
        $this->carSerialNumber = $carSerialNumber;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\GetZeusDatenRequest
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get lastModified value
     * @return string|null
     */
    public function getLastModified()
    {
        return $this->lastModified;
    }
    /**
     * Set lastModified value
     * @param string $lastModified
     * @return \StructType\GetZeusDatenRequest
     */
    public function setLastModified($lastModified = null)
    {
        // validation for constraint: string
        if (!is_null($lastModified) && !is_string($lastModified)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModified, true), gettype($lastModified)), __LINE__);
        }
        $this->lastModified = $lastModified;
        return $this;
    }
    /**
     * Get maxCount value
     * @return int|null
     */
    public function getMaxCount()
    {
        return $this->maxCount;
    }
    /**
     * Set maxCount value
     * @param int $maxCount
     * @return \StructType\GetZeusDatenRequest
     */
    public function setMaxCount($maxCount = null)
    {
        // validation for constraint: int
        if (!is_null($maxCount) && !(is_int($maxCount) || ctype_digit($maxCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxCount, true), gettype($maxCount)), __LINE__);
        }
        $this->maxCount = $maxCount;
        return $this;
    }
    /**
     * Get searchSource value
     * @return string|null
     */
    public function getSearchSource()
    {
        return $this->searchSource;
    }
    /**
     * Set searchSource value
     * @uses \EnumType\ZeusSearchSource::valueIsValid()
     * @uses \EnumType\ZeusSearchSource::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $searchSource
     * @return \StructType\GetZeusDatenRequest
     */
    public function setSearchSource($searchSource = 'database')
    {
        // validation for constraint: enumeration
        if (!\EnumType\ZeusSearchSource::valueIsValid($searchSource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ZeusSearchSource', is_array($searchSource) ? implode(', ', $searchSource) : var_export($searchSource, true), implode(', ', \EnumType\ZeusSearchSource::getValidValues())), __LINE__);
        }
        $this->searchSource = $searchSource;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetZeusDatenRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
