<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getZeusDatenGrecoResponse StructType
 * Meta information extracted from the WSDL
 * - documentation: Response of the found ZEUS data. This service is only available in the generali intranet
 * @subpackage Structs
 */
class GetZeusDatenGrecoResponse extends AbstractStructBase
{
    /**
     * The zeusCar
     * Meta information extracted from the WSDL
     * - maxOccurs: 300
     * - minOccurs: 0
     * @var \StructType\ZeusCar[]
     */
    public $zeusCar;
    /**
     * The evpServiceFault
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EvpServiceFault
     */
    public $evpServiceFault;
    /**
     * Constructor method for getZeusDatenGrecoResponse
     * @uses GetZeusDatenGrecoResponse::setZeusCar()
     * @uses GetZeusDatenGrecoResponse::setEvpServiceFault()
     * @param \StructType\ZeusCar[] $zeusCar
     * @param \StructType\EvpServiceFault $evpServiceFault
     */
    public function __construct(array $zeusCar = array(), \StructType\EvpServiceFault $evpServiceFault = null)
    {
        $this
            ->setZeusCar($zeusCar)
            ->setEvpServiceFault($evpServiceFault);
    }
    /**
     * Get zeusCar value
     * @return \StructType\ZeusCar[]|null
     */
    public function getZeusCar()
    {
        return $this->zeusCar;
    }
    /**
     * This method is responsible for validating the values passed to the setZeusCar method
     * This method is willingly generated in order to preserve the one-line inline validation within the setZeusCar method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateZeusCarForArrayConstraintsFromSetZeusCar(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getZeusDatenGrecoResponseZeusCarItem) {
            // validation for constraint: itemType
            if (!$getZeusDatenGrecoResponseZeusCarItem instanceof \StructType\ZeusCar) {
                $invalidValues[] = is_object($getZeusDatenGrecoResponseZeusCarItem) ? get_class($getZeusDatenGrecoResponseZeusCarItem) : sprintf('%s(%s)', gettype($getZeusDatenGrecoResponseZeusCarItem), var_export($getZeusDatenGrecoResponseZeusCarItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The zeusCar property can only contain items of type \StructType\ZeusCar, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set zeusCar value
     * @throws \InvalidArgumentException
     * @param \StructType\ZeusCar[] $zeusCar
     * @return \StructType\GetZeusDatenGrecoResponse
     */
    public function setZeusCar(array $zeusCar = array())
    {
        // validation for constraint: array
        if ('' !== ($zeusCarArrayErrorMessage = self::validateZeusCarForArrayConstraintsFromSetZeusCar($zeusCar))) {
            throw new \InvalidArgumentException($zeusCarArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(300)
        if (is_array($zeusCar) && count($zeusCar) > 300) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 300', count($zeusCar)), __LINE__);
        }
        $this->zeusCar = $zeusCar;
        return $this;
    }
    /**
     * Add item to zeusCar value
     * @throws \InvalidArgumentException
     * @param \StructType\ZeusCar $item
     * @return \StructType\GetZeusDatenGrecoResponse
     */
    public function addToZeusCar(\StructType\ZeusCar $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ZeusCar) {
            throw new \InvalidArgumentException(sprintf('The zeusCar property can only contain items of type \StructType\ZeusCar, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(300)
        if (is_array($this->zeusCar) && count($this->zeusCar) >= 300) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 300', count($this->zeusCar)), __LINE__);
        }
        $this->zeusCar[] = $item;
        return $this;
    }
    /**
     * Get evpServiceFault value
     * @return \StructType\EvpServiceFault|null
     */
    public function getEvpServiceFault()
    {
        return $this->evpServiceFault;
    }
    /**
     * Set evpServiceFault value
     * @param \StructType\EvpServiceFault $evpServiceFault
     * @return \StructType\GetZeusDatenGrecoResponse
     */
    public function setEvpServiceFault(\StructType\EvpServiceFault $evpServiceFault = null)
    {
        $this->evpServiceFault = $evpServiceFault;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetZeusDatenGrecoResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
