<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getZeusDatenGrecoRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Request for getting ZEUS information
 * @subpackage Structs
 */
class GetZeusDatenGrecoRequest extends AbstractStructBase
{
    /**
     * The login
     * Meta information extracted from the WSDL
     * - documentation: login data of user
     * @var \StructType\Login
     */
    public $login;
    /**
     * The licencePlate
     * Meta information extracted from the WSDL
     * - documentation: licence number of the car
     * - minOccurs: 0
     * @var string
     */
    public $licencePlate;
    /**
     * The vbNumber
     * Meta information extracted from the WSDL
     * - documentation: vb number of the car
     * - minOccurs: 0
     * @var string
     */
    public $vbNumber;
    /**
     * The carSerialNumber
     * Meta information extracted from the WSDL
     * - documentation: serial number of the car
     * - minOccurs: 0
     * @var string
     */
    public $carSerialNumber;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - documentation: zunameVorname
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The lastModified
     * Meta information extracted from the WSDL
     * - documentation: lastModified
     * - minOccurs: 0
     * @var string
     */
    public $lastModified;
    /**
     * The maxCount
     * Meta information extracted from the WSDL
     * - documentation: maximum count of entries, which will be returned. (max 150)
     * @var int
     */
    public $maxCount;
    /**
     * Constructor method for getZeusDatenGrecoRequest
     * @uses GetZeusDatenGrecoRequest::setLogin()
     * @uses GetZeusDatenGrecoRequest::setLicencePlate()
     * @uses GetZeusDatenGrecoRequest::setVbNumber()
     * @uses GetZeusDatenGrecoRequest::setCarSerialNumber()
     * @uses GetZeusDatenGrecoRequest::setName()
     * @uses GetZeusDatenGrecoRequest::setLastModified()
     * @uses GetZeusDatenGrecoRequest::setMaxCount()
     * @param \StructType\Login $login
     * @param string $licencePlate
     * @param string $vbNumber
     * @param string $carSerialNumber
     * @param string $name
     * @param string $lastModified
     * @param int $maxCount
     */
    public function __construct(\StructType\Login $login = null, $licencePlate = null, $vbNumber = null, $carSerialNumber = null, $name = null, $lastModified = null, $maxCount = null)
    {
        $this
            ->setLogin($login)
            ->setLicencePlate($licencePlate)
            ->setVbNumber($vbNumber)
            ->setCarSerialNumber($carSerialNumber)
            ->setName($name)
            ->setLastModified($lastModified)
            ->setMaxCount($maxCount);
    }
    /**
     * Get login value
     * @return \StructType\Login|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param \StructType\Login $login
     * @return \StructType\GetZeusDatenGrecoRequest
     */
    public function setLogin(\StructType\Login $login = null)
    {
        $this->login = $login;
        return $this;
    }
    /**
     * Get licencePlate value
     * @return string|null
     */
    public function getLicencePlate()
    {
        return $this->licencePlate;
    }
    /**
     * Set licencePlate value
     * @param string $licencePlate
     * @return \StructType\GetZeusDatenGrecoRequest
     */
    public function setLicencePlate($licencePlate = null)
    {
        // validation for constraint: string
        if (!is_null($licencePlate) && !is_string($licencePlate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($licencePlate, true), gettype($licencePlate)), __LINE__);
        }
        $this->licencePlate = $licencePlate;
        return $this;
    }
    /**
     * Get vbNumber value
     * @return string|null
     */
    public function getVbNumber()
    {
        return $this->vbNumber;
    }
    /**
     * Set vbNumber value
     * @param string $vbNumber
     * @return \StructType\GetZeusDatenGrecoRequest
     */
    public function setVbNumber($vbNumber = null)
    {
        // validation for constraint: string
        if (!is_null($vbNumber) && !is_string($vbNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vbNumber, true), gettype($vbNumber)), __LINE__);
        }
        $this->vbNumber = $vbNumber;
        return $this;
    }
    /**
     * Get carSerialNumber value
     * @return string|null
     */
    public function getCarSerialNumber()
    {
        return $this->carSerialNumber;
    }
    /**
     * Set carSerialNumber value
     * @param string $carSerialNumber
     * @return \StructType\GetZeusDatenGrecoRequest
     */
    public function setCarSerialNumber($carSerialNumber = null)
    {
        // validation for constraint: string
        if (!is_null($carSerialNumber) && !is_string($carSerialNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carSerialNumber, true), gettype($carSerialNumber)), __LINE__);
        }
        $this->carSerialNumber = $carSerialNumber;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\GetZeusDatenGrecoRequest
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get lastModified value
     * @return string|null
     */
    public function getLastModified()
    {
        return $this->lastModified;
    }
    /**
     * Set lastModified value
     * @param string $lastModified
     * @return \StructType\GetZeusDatenGrecoRequest
     */
    public function setLastModified($lastModified = null)
    {
        // validation for constraint: string
        if (!is_null($lastModified) && !is_string($lastModified)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModified, true), gettype($lastModified)), __LINE__);
        }
        $this->lastModified = $lastModified;
        return $this;
    }
    /**
     * Get maxCount value
     * @return int|null
     */
    public function getMaxCount()
    {
        return $this->maxCount;
    }
    /**
     * Set maxCount value
     * @param int $maxCount
     * @return \StructType\GetZeusDatenGrecoRequest
     */
    public function setMaxCount($maxCount = null)
    {
        // validation for constraint: int
        if (!is_null($maxCount) && !(is_int($maxCount) || ctype_digit($maxCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxCount, true), gettype($maxCount)), __LINE__);
        }
        $this->maxCount = $maxCount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetZeusDatenGrecoRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
