<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getLatestIDFromNumbergeneratorRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Request which returns the latest number (according to the type of number), which was used in eVP DB
 * @subpackage Structs
 */
class GetLatestIDFromNumbergeneratorRequest extends AbstractStructBase
{
    /**
     * The login
     * @var \StructType\Login
     */
    public $login;
    /**
     * The numbergeneratorTyp
     * Meta information extracted from the WSDL
     * - documentation: ID of the numbergenerator ANTRAGSNR GFNR GROUPID PARTNERID HISTORYID
     * @var string
     */
    public $numbergeneratorTyp;
    /**
     * Constructor method for getLatestIDFromNumbergeneratorRequest
     * @uses GetLatestIDFromNumbergeneratorRequest::setLogin()
     * @uses GetLatestIDFromNumbergeneratorRequest::setNumbergeneratorTyp()
     * @param \StructType\Login $login
     * @param string $numbergeneratorTyp
     */
    public function __construct(\StructType\Login $login = null, $numbergeneratorTyp = null)
    {
        $this
            ->setLogin($login)
            ->setNumbergeneratorTyp($numbergeneratorTyp);
    }
    /**
     * Get login value
     * @return \StructType\Login|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param \StructType\Login $login
     * @return \StructType\GetLatestIDFromNumbergeneratorRequest
     */
    public function setLogin(\StructType\Login $login = null)
    {
        $this->login = $login;
        return $this;
    }
    /**
     * Get numbergeneratorTyp value
     * @return string|null
     */
    public function getNumbergeneratorTyp()
    {
        return $this->numbergeneratorTyp;
    }
    /**
     * Set numbergeneratorTyp value
     * @param string $numbergeneratorTyp
     * @return \StructType\GetLatestIDFromNumbergeneratorRequest
     */
    public function setNumbergeneratorTyp($numbergeneratorTyp = null)
    {
        // validation for constraint: string
        if (!is_null($numbergeneratorTyp) && !is_string($numbergeneratorTyp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numbergeneratorTyp, true), gettype($numbergeneratorTyp)), __LINE__);
        }
        $this->numbergeneratorTyp = $numbergeneratorTyp;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetLatestIDFromNumbergeneratorRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
