<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getCustomerRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Request um Kunden in der eVP anzuzeigen
 * @subpackage Structs
 */
class GetCustomerRequest extends AbstractStructBase
{
    /**
     * The login
     * @var \StructType\Login
     */
    public $login;
    /**
     * The customerID
     * Meta information extracted from the WSDL
     * - documentation: ID des Kunden in der eVP. Alle Geschäftsfälle die zu einem Kunden angelegt werden referenzieren über diese ID. Wird dieses Feld nicht geschickt bedeutet dies, dass in der eVP der Kunde neu anzulegen ist. Eine ID wird dann
     * generiert und im Response zurückgeschickt.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $customerID;
    /**
     * The customerPAOID
     * Meta information extracted from the WSDL
     * - documentation: PAOID des Kunden in der eVP. Alle Geschäftsfälle die zu einem Kunden angelegt werden referenzieren über diese PAOID. Wird dieses Feld nicht geschickt bedeutet dies, dass in der eVP der Kunde neu anzulegen ist. Eine ID wird dann
     * generiert und im Response zurückgeschickt.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $customerPAOID;
    /**
     * The customerPaPartnerNr
     * Meta information extracted from the WSDL
     * - documentation: PA-Partnernr des Kunden in der eVP.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $customerPaPartnerNr;
    /**
     * The externalCustomerID
     * Meta information extracted from the WSDL
     * - documentation: Externe Partner ID
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $externalCustomerID;
    /**
     * The withoutFrame
     * Meta information extracted from the WSDL
     * - documentation: Definiert ob ein eVP Navigationsframe angezeigt wird oder nicht
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $withoutFrame;
    /**
     * The customerEmail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $customerEmail;
    /**
     * Constructor method for getCustomerRequest
     * @uses GetCustomerRequest::setLogin()
     * @uses GetCustomerRequest::setCustomerID()
     * @uses GetCustomerRequest::setCustomerPAOID()
     * @uses GetCustomerRequest::setCustomerPaPartnerNr()
     * @uses GetCustomerRequest::setExternalCustomerID()
     * @uses GetCustomerRequest::setWithoutFrame()
     * @uses GetCustomerRequest::setCustomerEmail()
     * @param \StructType\Login $login
     * @param int $customerID
     * @param string $customerPAOID
     * @param string $customerPaPartnerNr
     * @param string $externalCustomerID
     * @param bool $withoutFrame
     * @param string $customerEmail
     */
    public function __construct(\StructType\Login $login = null, $customerID = null, $customerPAOID = null, $customerPaPartnerNr = null, $externalCustomerID = null, $withoutFrame = false, $customerEmail = null)
    {
        $this
            ->setLogin($login)
            ->setCustomerID($customerID)
            ->setCustomerPAOID($customerPAOID)
            ->setCustomerPaPartnerNr($customerPaPartnerNr)
            ->setExternalCustomerID($externalCustomerID)
            ->setWithoutFrame($withoutFrame)
            ->setCustomerEmail($customerEmail);
    }
    /**
     * Get login value
     * @return \StructType\Login|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param \StructType\Login $login
     * @return \StructType\GetCustomerRequest
     */
    public function setLogin(\StructType\Login $login = null)
    {
        $this->login = $login;
        return $this;
    }
    /**
     * Get customerID value
     * @return int|null
     */
    public function getCustomerID()
    {
        return $this->customerID;
    }
    /**
     * Set customerID value
     * @param int $customerID
     * @return \StructType\GetCustomerRequest
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: int
        if (!is_null($customerID) && !(is_int($customerID) || ctype_digit($customerID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerID, true), gettype($customerID)), __LINE__);
        }
        $this->customerID = $customerID;
        return $this;
    }
    /**
     * Get customerPAOID value
     * @return string|null
     */
    public function getCustomerPAOID()
    {
        return $this->customerPAOID;
    }
    /**
     * Set customerPAOID value
     * @param string $customerPAOID
     * @return \StructType\GetCustomerRequest
     */
    public function setCustomerPAOID($customerPAOID = null)
    {
        // validation for constraint: string
        if (!is_null($customerPAOID) && !is_string($customerPAOID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerPAOID, true), gettype($customerPAOID)), __LINE__);
        }
        $this->customerPAOID = $customerPAOID;
        return $this;
    }
    /**
     * Get customerPaPartnerNr value
     * @return string|null
     */
    public function getCustomerPaPartnerNr()
    {
        return $this->customerPaPartnerNr;
    }
    /**
     * Set customerPaPartnerNr value
     * @param string $customerPaPartnerNr
     * @return \StructType\GetCustomerRequest
     */
    public function setCustomerPaPartnerNr($customerPaPartnerNr = null)
    {
        // validation for constraint: string
        if (!is_null($customerPaPartnerNr) && !is_string($customerPaPartnerNr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerPaPartnerNr, true), gettype($customerPaPartnerNr)), __LINE__);
        }
        $this->customerPaPartnerNr = $customerPaPartnerNr;
        return $this;
    }
    /**
     * Get externalCustomerID value
     * @return string|null
     */
    public function getExternalCustomerID()
    {
        return $this->externalCustomerID;
    }
    /**
     * Set externalCustomerID value
     * @param string $externalCustomerID
     * @return \StructType\GetCustomerRequest
     */
    public function setExternalCustomerID($externalCustomerID = null)
    {
        // validation for constraint: string
        if (!is_null($externalCustomerID) && !is_string($externalCustomerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalCustomerID, true), gettype($externalCustomerID)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($externalCustomerID) && mb_strlen($externalCustomerID) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($externalCustomerID)), __LINE__);
        }
        $this->externalCustomerID = $externalCustomerID;
        return $this;
    }
    /**
     * Get withoutFrame value
     * @return bool|null
     */
    public function getWithoutFrame()
    {
        return $this->withoutFrame;
    }
    /**
     * Set withoutFrame value
     * @param bool $withoutFrame
     * @return \StructType\GetCustomerRequest
     */
    public function setWithoutFrame($withoutFrame = false)
    {
        // validation for constraint: boolean
        if (!is_null($withoutFrame) && !is_bool($withoutFrame)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($withoutFrame, true), gettype($withoutFrame)), __LINE__);
        }
        $this->withoutFrame = $withoutFrame;
        return $this;
    }
    /**
     * Get customerEmail value
     * @return string|null
     */
    public function getCustomerEmail()
    {
        return $this->customerEmail;
    }
    /**
     * Set customerEmail value
     * @param string $customerEmail
     * @return \StructType\GetCustomerRequest
     */
    public function setCustomerEmail($customerEmail = null)
    {
        // validation for constraint: string
        if (!is_null($customerEmail) && !is_string($customerEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerEmail, true), gettype($customerEmail)), __LINE__);
        }
        $this->customerEmail = $customerEmail;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetCustomerRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
