<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getBusinessCasesRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Request zur Geschäftsfalldatenversorgung
 * @subpackage Structs
 */
class GetBusinessCasesRequest extends AbstractStructBase
{
    /**
     * The login
     * @var \StructType\Login
     */
    public $login;
    /**
     * The fromDate
     * Meta information extracted from the WSDL
     * - documentation: Bezieht sich auf des Änderungsdatum des Geschäftsfalles
     * @var string
     */
    public $fromDate;
    /**
     * The toDate
     * Meta information extracted from the WSDL
     * - documentation: Bezieht sich auf des Änderungsdatum des Geschäftsfalles
     * @var string
     */
    public $toDate;
    /**
     * The customerID
     * Meta information extracted from the WSDL
     * - documentation: Ist nur eine Datenversorgung für einen Bestimmten Kunden gewünscht ist dessen ID hier zu übergeben.
     * - minOccurs: 0
     * @var int
     */
    public $customerID;
    /**
     * The pageCount
     * Meta information extracted from the WSDL
     * - documentation: Gibt die n-50 Geschäftsfälle zurück, die den fromDate, toDate Kriterien entsprechen. Wird der pageCount bei der nächsten Anfrage um 1 erhöht kommen die nächsten n-50 zurück. Ist der PageCount zu hoch wird nichts
     * zurückgeliefert.
     * - minOccurs: 0
     * @var int
     */
    public $pageCount;
    /**
     * The foreignID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $foreignID;
    /**
     * The licencePlate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $licencePlate;
    /**
     * The businessCaseType
     * Meta information extracted from the WSDL
     * - maxOccurs: 10
     * - minOccurs: 0
     * @var string[]
     */
    public $businessCaseType;
    /**
     * Constructor method for getBusinessCasesRequest
     * @uses GetBusinessCasesRequest::setLogin()
     * @uses GetBusinessCasesRequest::setFromDate()
     * @uses GetBusinessCasesRequest::setToDate()
     * @uses GetBusinessCasesRequest::setCustomerID()
     * @uses GetBusinessCasesRequest::setPageCount()
     * @uses GetBusinessCasesRequest::setForeignID()
     * @uses GetBusinessCasesRequest::setLicencePlate()
     * @uses GetBusinessCasesRequest::setBusinessCaseType()
     * @param \StructType\Login $login
     * @param string $fromDate
     * @param string $toDate
     * @param int $customerID
     * @param int $pageCount
     * @param string $foreignID
     * @param string $licencePlate
     * @param string[] $businessCaseType
     */
    public function __construct(\StructType\Login $login = null, $fromDate = null, $toDate = null, $customerID = null, $pageCount = null, $foreignID = null, $licencePlate = null, array $businessCaseType = array())
    {
        $this
            ->setLogin($login)
            ->setFromDate($fromDate)
            ->setToDate($toDate)
            ->setCustomerID($customerID)
            ->setPageCount($pageCount)
            ->setForeignID($foreignID)
            ->setLicencePlate($licencePlate)
            ->setBusinessCaseType($businessCaseType);
    }
    /**
     * Get login value
     * @return \StructType\Login|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param \StructType\Login $login
     * @return \StructType\GetBusinessCasesRequest
     */
    public function setLogin(\StructType\Login $login = null)
    {
        $this->login = $login;
        return $this;
    }
    /**
     * Get fromDate value
     * @return string|null
     */
    public function getFromDate()
    {
        return $this->fromDate;
    }
    /**
     * Set fromDate value
     * @param string $fromDate
     * @return \StructType\GetBusinessCasesRequest
     */
    public function setFromDate($fromDate = null)
    {
        // validation for constraint: string
        if (!is_null($fromDate) && !is_string($fromDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromDate, true), gettype($fromDate)), __LINE__);
        }
        $this->fromDate = $fromDate;
        return $this;
    }
    /**
     * Get toDate value
     * @return string|null
     */
    public function getToDate()
    {
        return $this->toDate;
    }
    /**
     * Set toDate value
     * @param string $toDate
     * @return \StructType\GetBusinessCasesRequest
     */
    public function setToDate($toDate = null)
    {
        // validation for constraint: string
        if (!is_null($toDate) && !is_string($toDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($toDate, true), gettype($toDate)), __LINE__);
        }
        $this->toDate = $toDate;
        return $this;
    }
    /**
     * Get customerID value
     * @return int|null
     */
    public function getCustomerID()
    {
        return $this->customerID;
    }
    /**
     * Set customerID value
     * @param int $customerID
     * @return \StructType\GetBusinessCasesRequest
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: int
        if (!is_null($customerID) && !(is_int($customerID) || ctype_digit($customerID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerID, true), gettype($customerID)), __LINE__);
        }
        $this->customerID = $customerID;
        return $this;
    }
    /**
     * Get pageCount value
     * @return int|null
     */
    public function getPageCount()
    {
        return $this->pageCount;
    }
    /**
     * Set pageCount value
     * @param int $pageCount
     * @return \StructType\GetBusinessCasesRequest
     */
    public function setPageCount($pageCount = null)
    {
        // validation for constraint: int
        if (!is_null($pageCount) && !(is_int($pageCount) || ctype_digit($pageCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pageCount, true), gettype($pageCount)), __LINE__);
        }
        $this->pageCount = $pageCount;
        return $this;
    }
    /**
     * Get foreignID value
     * @return string|null
     */
    public function getForeignID()
    {
        return $this->foreignID;
    }
    /**
     * Set foreignID value
     * @param string $foreignID
     * @return \StructType\GetBusinessCasesRequest
     */
    public function setForeignID($foreignID = null)
    {
        // validation for constraint: string
        if (!is_null($foreignID) && !is_string($foreignID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($foreignID, true), gettype($foreignID)), __LINE__);
        }
        $this->foreignID = $foreignID;
        return $this;
    }
    /**
     * Get licencePlate value
     * @return string|null
     */
    public function getLicencePlate()
    {
        return $this->licencePlate;
    }
    /**
     * Set licencePlate value
     * @param string $licencePlate
     * @return \StructType\GetBusinessCasesRequest
     */
    public function setLicencePlate($licencePlate = null)
    {
        // validation for constraint: string
        if (!is_null($licencePlate) && !is_string($licencePlate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($licencePlate, true), gettype($licencePlate)), __LINE__);
        }
        $this->licencePlate = $licencePlate;
        return $this;
    }
    /**
     * Get businessCaseType value
     * @return string[]|null
     */
    public function getBusinessCaseType()
    {
        return $this->businessCaseType;
    }
    /**
     * This method is responsible for validating the values passed to the setBusinessCaseType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBusinessCaseType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBusinessCaseTypeForArrayConstraintsFromSetBusinessCaseType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getBusinessCasesRequestBusinessCaseTypeItem) {
            // validation for constraint: enumeration
            if (!\EnumType\BusinessCaseType::valueIsValid($getBusinessCasesRequestBusinessCaseTypeItem)) {
                $invalidValues[] = is_object($getBusinessCasesRequestBusinessCaseTypeItem) ? get_class($getBusinessCasesRequestBusinessCaseTypeItem) : sprintf('%s(%s)', gettype($getBusinessCasesRequestBusinessCaseTypeItem), var_export($getBusinessCasesRequestBusinessCaseTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\BusinessCaseType', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\BusinessCaseType::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set businessCaseType value
     * @uses \EnumType\BusinessCaseType::valueIsValid()
     * @uses \EnumType\BusinessCaseType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $businessCaseType
     * @return \StructType\GetBusinessCasesRequest
     */
    public function setBusinessCaseType(array $businessCaseType = array())
    {
        // validation for constraint: array
        if ('' !== ($businessCaseTypeArrayErrorMessage = self::validateBusinessCaseTypeForArrayConstraintsFromSetBusinessCaseType($businessCaseType))) {
            throw new \InvalidArgumentException($businessCaseTypeArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($businessCaseType) && count($businessCaseType) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 10', count($businessCaseType)), __LINE__);
        }
        $this->businessCaseType = $businessCaseType;
        return $this;
    }
    /**
     * Add item to businessCaseType value
     * @uses \EnumType\BusinessCaseType::valueIsValid()
     * @uses \EnumType\BusinessCaseType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\GetBusinessCasesRequest
     */
    public function addToBusinessCaseType($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\BusinessCaseType::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\BusinessCaseType', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \EnumType\BusinessCaseType::getValidValues())), __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($this->businessCaseType) && count($this->businessCaseType) >= 10) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 10', count($this->businessCaseType)), __LINE__);
        }
        $this->businessCaseType[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetBusinessCasesRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
