<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getBusinessCaseHistoryResponse StructType
 * Meta information extracted from the WSDL
 * - documentation: Liefert Detailinformationen für die History zu einem Geschäftsfall
 * @subpackage Structs
 */
class GetBusinessCaseHistoryResponse extends AbstractStructBase
{
    /**
     * The history
     * Meta information extracted from the WSDL
     * - documentation: Liefter 0 bis n History Einträge zu diesem Geschäftsfall
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\History[]
     */
    public $history;
    /**
     * The evpServiceFault
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EvpServiceFault
     */
    public $evpServiceFault;
    /**
     * Constructor method for getBusinessCaseHistoryResponse
     * @uses GetBusinessCaseHistoryResponse::setHistory()
     * @uses GetBusinessCaseHistoryResponse::setEvpServiceFault()
     * @param \StructType\History[] $history
     * @param \StructType\EvpServiceFault $evpServiceFault
     */
    public function __construct(array $history = array(), \StructType\EvpServiceFault $evpServiceFault = null)
    {
        $this
            ->setHistory($history)
            ->setEvpServiceFault($evpServiceFault);
    }
    /**
     * Get history value
     * @return \StructType\History[]|null
     */
    public function getHistory()
    {
        return $this->history;
    }
    /**
     * This method is responsible for validating the values passed to the setHistory method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHistory method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHistoryForArrayConstraintsFromSetHistory(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getBusinessCaseHistoryResponseHistoryItem) {
            // validation for constraint: itemType
            if (!$getBusinessCaseHistoryResponseHistoryItem instanceof \StructType\History) {
                $invalidValues[] = is_object($getBusinessCaseHistoryResponseHistoryItem) ? get_class($getBusinessCaseHistoryResponseHistoryItem) : sprintf('%s(%s)', gettype($getBusinessCaseHistoryResponseHistoryItem), var_export($getBusinessCaseHistoryResponseHistoryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The history property can only contain items of type \StructType\History, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set history value
     * @throws \InvalidArgumentException
     * @param \StructType\History[] $history
     * @return \StructType\GetBusinessCaseHistoryResponse
     */
    public function setHistory(array $history = array())
    {
        // validation for constraint: array
        if ('' !== ($historyArrayErrorMessage = self::validateHistoryForArrayConstraintsFromSetHistory($history))) {
            throw new \InvalidArgumentException($historyArrayErrorMessage, __LINE__);
        }
        $this->history = $history;
        return $this;
    }
    /**
     * Add item to history value
     * @throws \InvalidArgumentException
     * @param \StructType\History $item
     * @return \StructType\GetBusinessCaseHistoryResponse
     */
    public function addToHistory(\StructType\History $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\History) {
            throw new \InvalidArgumentException(sprintf('The history property can only contain items of type \StructType\History, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->history[] = $item;
        return $this;
    }
    /**
     * Get evpServiceFault value
     * @return \StructType\EvpServiceFault|null
     */
    public function getEvpServiceFault()
    {
        return $this->evpServiceFault;
    }
    /**
     * Set evpServiceFault value
     * @param \StructType\EvpServiceFault $evpServiceFault
     * @return \StructType\GetBusinessCaseHistoryResponse
     */
    public function setEvpServiceFault(\StructType\EvpServiceFault $evpServiceFault = null)
    {
        $this->evpServiceFault = $evpServiceFault;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetBusinessCaseHistoryResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
