<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getArcImageInfosRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Request zum Abruf der Informationen der Dokumente zu einer Polizze aus dem Generali ArchivClient
 * @subpackage Structs
 */
class GetArcImageInfosRequest extends AbstractStructBase
{
    /**
     * The login
     * @var \StructType\Login
     */
    public $login;
    /**
     * The policy
     * Meta information extracted from the WSDL
     * - documentation: Policy
     * @var \StructType\Policy
     */
    public $policy;
    /**
     * The dateFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dateFrom;
    /**
     * The dateUntil
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dateUntil;
    /**
     * Constructor method for getArcImageInfosRequest
     * @uses GetArcImageInfosRequest::setLogin()
     * @uses GetArcImageInfosRequest::setPolicy()
     * @uses GetArcImageInfosRequest::setDateFrom()
     * @uses GetArcImageInfosRequest::setDateUntil()
     * @param \StructType\Login $login
     * @param \StructType\Policy $policy
     * @param string $dateFrom
     * @param string $dateUntil
     */
    public function __construct(\StructType\Login $login = null, \StructType\Policy $policy = null, $dateFrom = null, $dateUntil = null)
    {
        $this
            ->setLogin($login)
            ->setPolicy($policy)
            ->setDateFrom($dateFrom)
            ->setDateUntil($dateUntil);
    }
    /**
     * Get login value
     * @return \StructType\Login|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param \StructType\Login $login
     * @return \StructType\GetArcImageInfosRequest
     */
    public function setLogin(\StructType\Login $login = null)
    {
        $this->login = $login;
        return $this;
    }
    /**
     * Get policy value
     * @return \StructType\Policy|null
     */
    public function getPolicy()
    {
        return $this->policy;
    }
    /**
     * Set policy value
     * @param \StructType\Policy $policy
     * @return \StructType\GetArcImageInfosRequest
     */
    public function setPolicy(\StructType\Policy $policy = null)
    {
        $this->policy = $policy;
        return $this;
    }
    /**
     * Get dateFrom value
     * @return string|null
     */
    public function getDateFrom()
    {
        return $this->dateFrom;
    }
    /**
     * Set dateFrom value
     * @param string $dateFrom
     * @return \StructType\GetArcImageInfosRequest
     */
    public function setDateFrom($dateFrom = null)
    {
        // validation for constraint: string
        if (!is_null($dateFrom) && !is_string($dateFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateFrom, true), gettype($dateFrom)), __LINE__);
        }
        $this->dateFrom = $dateFrom;
        return $this;
    }
    /**
     * Get dateUntil value
     * @return string|null
     */
    public function getDateUntil()
    {
        return $this->dateUntil;
    }
    /**
     * Set dateUntil value
     * @param string $dateUntil
     * @return \StructType\GetArcImageInfosRequest
     */
    public function setDateUntil($dateUntil = null)
    {
        // validation for constraint: string
        if (!is_null($dateUntil) && !is_string($dateUntil)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateUntil, true), gettype($dateUntil)), __LINE__);
        }
        $this->dateUntil = $dateUntil;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetArcImageInfosRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
