<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for generalikfzv2Type StructType
 * @subpackage Structs
 */
class Generalikfzv2Type extends AbstractStructBase
{
    /**
     * The header
     * @var \StructType\HeaderType
     */
    public $header;
    /**
     * The versicherungsbestaetigung
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\VersicherungsbestaetigungType
     */
    public $versicherungsbestaetigung;
    /**
     * The zulassungsdaten
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ZulassungsdatenType
     */
    public $zulassungsdaten;
    /**
     * The fahrzeugdatenPkw
     * Meta information extracted from the WSDL
     * - choice: fahrzeugdatenPkw | fahrzeugdatenLkw
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * @var \StructType\FahrzeugdatenPkwType
     */
    public $fahrzeugdatenPkw;
    /**
     * The fahrzeugdatenLkw
     * Meta information extracted from the WSDL
     * - choice: fahrzeugdatenPkw | fahrzeugdatenLkw
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * @var \StructType\FahrzeugdatenLkwType
     */
    public $fahrzeugdatenLkw;
    /**
     * The tarifierung
     * @var \StructType\TarifierungsdatenType
     */
    public $tarifierung;
    /**
     * The vereinbarungen
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\VereinbarungenType
     */
    public $vereinbarungen;
    /**
     * The antragsdaten
     * @var \StructType\AntragsdatenType
     */
    public $antragsdaten;
    /**
     * The rueckmeldung
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RueckmeldungType
     */
    public $rueckmeldung;
    /**
     * Constructor method for generalikfzv2Type
     * @uses Generalikfzv2Type::setHeader()
     * @uses Generalikfzv2Type::setVersicherungsbestaetigung()
     * @uses Generalikfzv2Type::setZulassungsdaten()
     * @uses Generalikfzv2Type::setFahrzeugdatenPkw()
     * @uses Generalikfzv2Type::setFahrzeugdatenLkw()
     * @uses Generalikfzv2Type::setTarifierung()
     * @uses Generalikfzv2Type::setVereinbarungen()
     * @uses Generalikfzv2Type::setAntragsdaten()
     * @uses Generalikfzv2Type::setRueckmeldung()
     * @param \StructType\HeaderType $header
     * @param \StructType\VersicherungsbestaetigungType $versicherungsbestaetigung
     * @param \StructType\ZulassungsdatenType $zulassungsdaten
     * @param \StructType\FahrzeugdatenPkwType $fahrzeugdatenPkw
     * @param \StructType\FahrzeugdatenLkwType $fahrzeugdatenLkw
     * @param \StructType\TarifierungsdatenType $tarifierung
     * @param \StructType\VereinbarungenType $vereinbarungen
     * @param \StructType\AntragsdatenType $antragsdaten
     * @param \StructType\RueckmeldungType $rueckmeldung
     */
    public function __construct(\StructType\HeaderType $header = null, \StructType\VersicherungsbestaetigungType $versicherungsbestaetigung = null, \StructType\ZulassungsdatenType $zulassungsdaten = null, \StructType\FahrzeugdatenPkwType $fahrzeugdatenPkw = null, \StructType\FahrzeugdatenLkwType $fahrzeugdatenLkw = null, \StructType\TarifierungsdatenType $tarifierung = null, \StructType\VereinbarungenType $vereinbarungen = null, \StructType\AntragsdatenType $antragsdaten = null, \StructType\RueckmeldungType $rueckmeldung = null)
    {
        $this
            ->setHeader($header)
            ->setVersicherungsbestaetigung($versicherungsbestaetigung)
            ->setZulassungsdaten($zulassungsdaten)
            ->setFahrzeugdatenPkw($fahrzeugdatenPkw)
            ->setFahrzeugdatenLkw($fahrzeugdatenLkw)
            ->setTarifierung($tarifierung)
            ->setVereinbarungen($vereinbarungen)
            ->setAntragsdaten($antragsdaten)
            ->setRueckmeldung($rueckmeldung);
    }
    /**
     * Get header value
     * @return \StructType\HeaderType|null
     */
    public function getHeader()
    {
        return $this->header;
    }
    /**
     * Set header value
     * @param \StructType\HeaderType $header
     * @return \StructType\Generalikfzv2Type
     */
    public function setHeader(\StructType\HeaderType $header = null)
    {
        $this->header = $header;
        return $this;
    }
    /**
     * Get versicherungsbestaetigung value
     * @return \StructType\VersicherungsbestaetigungType|null
     */
    public function getVersicherungsbestaetigung()
    {
        return $this->versicherungsbestaetigung;
    }
    /**
     * Set versicherungsbestaetigung value
     * @param \StructType\VersicherungsbestaetigungType $versicherungsbestaetigung
     * @return \StructType\Generalikfzv2Type
     */
    public function setVersicherungsbestaetigung(\StructType\VersicherungsbestaetigungType $versicherungsbestaetigung = null)
    {
        $this->versicherungsbestaetigung = $versicherungsbestaetigung;
        return $this;
    }
    /**
     * Get zulassungsdaten value
     * @return \StructType\ZulassungsdatenType|null
     */
    public function getZulassungsdaten()
    {
        return $this->zulassungsdaten;
    }
    /**
     * Set zulassungsdaten value
     * @param \StructType\ZulassungsdatenType $zulassungsdaten
     * @return \StructType\Generalikfzv2Type
     */
    public function setZulassungsdaten(\StructType\ZulassungsdatenType $zulassungsdaten = null)
    {
        $this->zulassungsdaten = $zulassungsdaten;
        return $this;
    }
    /**
     * Get fahrzeugdatenPkw value
     * @return \StructType\FahrzeugdatenPkwType|null
     */
    public function getFahrzeugdatenPkw()
    {
        return isset($this->fahrzeugdatenPkw) ? $this->fahrzeugdatenPkw : null;
    }
    /**
     * This method is responsible for validating the value passed to the setFahrzeugdatenPkw method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFahrzeugdatenPkw method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateFahrzeugdatenPkwForChoiceConstraintsFromSetFahrzeugdatenPkw($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'fahrzeugdatenLkw',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property fahrzeugdatenPkw can\'t be set as the property %s is already set. Only one property must be set among these properties: fahrzeugdatenPkw, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set fahrzeugdatenPkw value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\FahrzeugdatenPkwType $fahrzeugdatenPkw
     * @return \StructType\Generalikfzv2Type
     */
    public function setFahrzeugdatenPkw(\StructType\FahrzeugdatenPkwType $fahrzeugdatenPkw = null)
    {
        // validation for constraint: choice(fahrzeugdatenPkw, fahrzeugdatenLkw)
        if ('' !== ($fahrzeugdatenPkwChoiceErrorMessage = self::validateFahrzeugdatenPkwForChoiceConstraintsFromSetFahrzeugdatenPkw($fahrzeugdatenPkw))) {
            throw new \InvalidArgumentException($fahrzeugdatenPkwChoiceErrorMessage, __LINE__);
        }
        if (is_null($fahrzeugdatenPkw) || (is_array($fahrzeugdatenPkw) && empty($fahrzeugdatenPkw))) {
            unset($this->fahrzeugdatenPkw);
        } else {
            $this->fahrzeugdatenPkw = $fahrzeugdatenPkw;
        }
        return $this;
    }
    /**
     * Get fahrzeugdatenLkw value
     * @return \StructType\FahrzeugdatenLkwType|null
     */
    public function getFahrzeugdatenLkw()
    {
        return isset($this->fahrzeugdatenLkw) ? $this->fahrzeugdatenLkw : null;
    }
    /**
     * This method is responsible for validating the value passed to the setFahrzeugdatenLkw method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFahrzeugdatenLkw method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateFahrzeugdatenLkwForChoiceConstraintsFromSetFahrzeugdatenLkw($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'fahrzeugdatenPkw',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property fahrzeugdatenLkw can\'t be set as the property %s is already set. Only one property must be set among these properties: fahrzeugdatenLkw, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set fahrzeugdatenLkw value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\FahrzeugdatenLkwType $fahrzeugdatenLkw
     * @return \StructType\Generalikfzv2Type
     */
    public function setFahrzeugdatenLkw(\StructType\FahrzeugdatenLkwType $fahrzeugdatenLkw = null)
    {
        // validation for constraint: choice(fahrzeugdatenPkw, fahrzeugdatenLkw)
        if ('' !== ($fahrzeugdatenLkwChoiceErrorMessage = self::validateFahrzeugdatenLkwForChoiceConstraintsFromSetFahrzeugdatenLkw($fahrzeugdatenLkw))) {
            throw new \InvalidArgumentException($fahrzeugdatenLkwChoiceErrorMessage, __LINE__);
        }
        if (is_null($fahrzeugdatenLkw) || (is_array($fahrzeugdatenLkw) && empty($fahrzeugdatenLkw))) {
            unset($this->fahrzeugdatenLkw);
        } else {
            $this->fahrzeugdatenLkw = $fahrzeugdatenLkw;
        }
        return $this;
    }
    /**
     * Get tarifierung value
     * @return \StructType\TarifierungsdatenType|null
     */
    public function getTarifierung()
    {
        return $this->tarifierung;
    }
    /**
     * Set tarifierung value
     * @param \StructType\TarifierungsdatenType $tarifierung
     * @return \StructType\Generalikfzv2Type
     */
    public function setTarifierung(\StructType\TarifierungsdatenType $tarifierung = null)
    {
        $this->tarifierung = $tarifierung;
        return $this;
    }
    /**
     * Get vereinbarungen value
     * @return \StructType\VereinbarungenType|null
     */
    public function getVereinbarungen()
    {
        return $this->vereinbarungen;
    }
    /**
     * Set vereinbarungen value
     * @param \StructType\VereinbarungenType $vereinbarungen
     * @return \StructType\Generalikfzv2Type
     */
    public function setVereinbarungen(\StructType\VereinbarungenType $vereinbarungen = null)
    {
        $this->vereinbarungen = $vereinbarungen;
        return $this;
    }
    /**
     * Get antragsdaten value
     * @return \StructType\AntragsdatenType|null
     */
    public function getAntragsdaten()
    {
        return $this->antragsdaten;
    }
    /**
     * Set antragsdaten value
     * @param \StructType\AntragsdatenType $antragsdaten
     * @return \StructType\Generalikfzv2Type
     */
    public function setAntragsdaten(\StructType\AntragsdatenType $antragsdaten = null)
    {
        $this->antragsdaten = $antragsdaten;
        return $this;
    }
    /**
     * Get rueckmeldung value
     * @return \StructType\RueckmeldungType|null
     */
    public function getRueckmeldung()
    {
        return $this->rueckmeldung;
    }
    /**
     * Set rueckmeldung value
     * @param \StructType\RueckmeldungType $rueckmeldung
     * @return \StructType\Generalikfzv2Type
     */
    public function setRueckmeldung(\StructType\RueckmeldungType $rueckmeldung = null)
    {
        $this->rueckmeldung = $rueckmeldung;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Generalikfzv2Type
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
