<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FondsType StructType
 * @subpackage Structs
 */
class FondsType extends AbstractStructBase
{
    /**
     * The fondskategorie
     * @var string
     */
    public $fondskategorie;
    /**
     * The fonds
     * Meta information extracted from the WSDL
     * - maxOccurs: 5
     * @var \StructType\EinzelfondsType[]
     */
    public $fonds;
    /**
     * Constructor method for FondsType
     * @uses FondsType::setFondskategorie()
     * @uses FondsType::setFonds()
     * @param string $fondskategorie
     * @param \StructType\EinzelfondsType[] $fonds
     */
    public function __construct($fondskategorie = null, array $fonds = array())
    {
        $this
            ->setFondskategorie($fondskategorie)
            ->setFonds($fonds);
    }
    /**
     * Get fondskategorie value
     * @return string|null
     */
    public function getFondskategorie()
    {
        return $this->fondskategorie;
    }
    /**
     * Set fondskategorie value
     * @uses \EnumType\FondskategorieType::valueIsValid()
     * @uses \EnumType\FondskategorieType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $fondskategorie
     * @return \StructType\FondsType
     */
    public function setFondskategorie($fondskategorie = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\FondskategorieType::valueIsValid($fondskategorie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\FondskategorieType', is_array($fondskategorie) ? implode(', ', $fondskategorie) : var_export($fondskategorie, true), implode(', ', \EnumType\FondskategorieType::getValidValues())), __LINE__);
        }
        $this->fondskategorie = $fondskategorie;
        return $this;
    }
    /**
     * Get fonds value
     * @return \StructType\EinzelfondsType[]|null
     */
    public function getFonds()
    {
        return $this->fonds;
    }
    /**
     * This method is responsible for validating the values passed to the setFonds method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFonds method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFondsForArrayConstraintsFromSetFonds(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $fondsTypeFondsItem) {
            // validation for constraint: itemType
            if (!$fondsTypeFondsItem instanceof \StructType\EinzelfondsType) {
                $invalidValues[] = is_object($fondsTypeFondsItem) ? get_class($fondsTypeFondsItem) : sprintf('%s(%s)', gettype($fondsTypeFondsItem), var_export($fondsTypeFondsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The fonds property can only contain items of type \StructType\EinzelfondsType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set fonds value
     * @throws \InvalidArgumentException
     * @param \StructType\EinzelfondsType[] $fonds
     * @return \StructType\FondsType
     */
    public function setFonds(array $fonds = array())
    {
        // validation for constraint: array
        if ('' !== ($fondsArrayErrorMessage = self::validateFondsForArrayConstraintsFromSetFonds($fonds))) {
            throw new \InvalidArgumentException($fondsArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($fonds) && count($fonds) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($fonds)), __LINE__);
        }
        $this->fonds = $fonds;
        return $this;
    }
    /**
     * Add item to fonds value
     * @throws \InvalidArgumentException
     * @param \StructType\EinzelfondsType $item
     * @return \StructType\FondsType
     */
    public function addToFonds(\StructType\EinzelfondsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EinzelfondsType) {
            throw new \InvalidArgumentException(sprintf('The fonds property can only contain items of type \StructType\EinzelfondsType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->fonds) && count($this->fonds) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->fonds)), __LINE__);
        }
        $this->fonds[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FondsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
