<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for fahrzeugdatenLkwType StructType
 * @subpackage Structs
 */
class FahrzeugdatenLkwType extends AbstractStructBase
{
    /**
     * The zulassungsbezirk
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $zulassungsbezirk;
    /**
     * The kfzArt
     * @var string
     */
    public $kfzArt;
    /**
     * The verwendungsart
     * @var string
     */
    public $verwendungsart;
    /**
     * The verwendung
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $verwendung;
    /**
     * The markeLkw
     * @var string
     */
    public $markeLkw;
    /**
     * The typeAusfuehrung
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 32
     * @var string
     */
    public $typeAusfuehrung;
    /**
     * The firmenfahrzeug
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $firmenfahrzeug;
    /**
     * The bauartgeschwindigkeit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $bauartgeschwindigkeit;
    /**
     * The erstzulassung
     * @var string
     */
    public $erstzulassung;
    /**
     * The leistungKW
     * @var int
     */
    public $leistungKW;
    /**
     * The hubraum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $hubraum;
    /**
     * The anzahlPlaetze
     * @var int
     */
    public $anzahlPlaetze;
    /**
     * The eigengewicht
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $eigengewicht;
    /**
     * The gesamtgewichtLkw
     * @var int
     */
    public $gesamtgewichtLkw;
    /**
     * The nutzlastLkw
     * @var int
     */
    public $nutzlastLkw;
    /**
     * The listenpreis
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $listenpreis;
    /**
     * The kaufpreis
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $kaufpreis;
    /**
     * The antriebsart
     * @var string
     */
    public $antriebsart;
    /**
     * The befreiungsgrund
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $befreiungsgrund;
    /**
     * The gueterbefoerderungLkw
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $gueterbefoerderungLkw;
    /**
     * The gefaehrlicheGueter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $gefaehrlicheGueter;
    /**
     * The ohneKennzeichen
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ohneKennzeichen;
    /**
     * The schneeraeumung
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $schneeraeumung;
    /**
     * The kleiner10Kmh
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $kleiner10Kmh;
    /**
     * The selbstvermietung
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $selbstvermietung;
    /**
     * The landForstwirtschaft
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $landForstwirtschaft;
    /**
     * The oldtimer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $oldtimer;
    /**
     * The aufbauLkw
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $aufbauLkw;
    /**
     * Constructor method for fahrzeugdatenLkwType
     * @uses FahrzeugdatenLkwType::setZulassungsbezirk()
     * @uses FahrzeugdatenLkwType::setKfzArt()
     * @uses FahrzeugdatenLkwType::setVerwendungsart()
     * @uses FahrzeugdatenLkwType::setVerwendung()
     * @uses FahrzeugdatenLkwType::setMarkeLkw()
     * @uses FahrzeugdatenLkwType::setTypeAusfuehrung()
     * @uses FahrzeugdatenLkwType::setFirmenfahrzeug()
     * @uses FahrzeugdatenLkwType::setBauartgeschwindigkeit()
     * @uses FahrzeugdatenLkwType::setErstzulassung()
     * @uses FahrzeugdatenLkwType::setLeistungKW()
     * @uses FahrzeugdatenLkwType::setHubraum()
     * @uses FahrzeugdatenLkwType::setAnzahlPlaetze()
     * @uses FahrzeugdatenLkwType::setEigengewicht()
     * @uses FahrzeugdatenLkwType::setGesamtgewichtLkw()
     * @uses FahrzeugdatenLkwType::setNutzlastLkw()
     * @uses FahrzeugdatenLkwType::setListenpreis()
     * @uses FahrzeugdatenLkwType::setKaufpreis()
     * @uses FahrzeugdatenLkwType::setAntriebsart()
     * @uses FahrzeugdatenLkwType::setBefreiungsgrund()
     * @uses FahrzeugdatenLkwType::setGueterbefoerderungLkw()
     * @uses FahrzeugdatenLkwType::setGefaehrlicheGueter()
     * @uses FahrzeugdatenLkwType::setOhneKennzeichen()
     * @uses FahrzeugdatenLkwType::setSchneeraeumung()
     * @uses FahrzeugdatenLkwType::setKleiner10Kmh()
     * @uses FahrzeugdatenLkwType::setSelbstvermietung()
     * @uses FahrzeugdatenLkwType::setLandForstwirtschaft()
     * @uses FahrzeugdatenLkwType::setOldtimer()
     * @uses FahrzeugdatenLkwType::setAufbauLkw()
     * @param string $zulassungsbezirk
     * @param string $kfzArt
     * @param string $verwendungsart
     * @param string $verwendung
     * @param string $markeLkw
     * @param string $typeAusfuehrung
     * @param string $firmenfahrzeug
     * @param int $bauartgeschwindigkeit
     * @param string $erstzulassung
     * @param int $leistungKW
     * @param int $hubraum
     * @param int $anzahlPlaetze
     * @param int $eigengewicht
     * @param int $gesamtgewichtLkw
     * @param int $nutzlastLkw
     * @param int $listenpreis
     * @param int $kaufpreis
     * @param string $antriebsart
     * @param string $befreiungsgrund
     * @param string $gueterbefoerderungLkw
     * @param string $gefaehrlicheGueter
     * @param string $ohneKennzeichen
     * @param string $schneeraeumung
     * @param string $kleiner10Kmh
     * @param string $selbstvermietung
     * @param string $landForstwirtschaft
     * @param string $oldtimer
     * @param string $aufbauLkw
     */
    public function __construct($zulassungsbezirk = null, $kfzArt = null, $verwendungsart = null, $verwendung = null, $markeLkw = null, $typeAusfuehrung = null, $firmenfahrzeug = null, $bauartgeschwindigkeit = null, $erstzulassung = null, $leistungKW = null, $hubraum = null, $anzahlPlaetze = null, $eigengewicht = null, $gesamtgewichtLkw = null, $nutzlastLkw = null, $listenpreis = null, $kaufpreis = null, $antriebsart = null, $befreiungsgrund = null, $gueterbefoerderungLkw = null, $gefaehrlicheGueter = null, $ohneKennzeichen = null, $schneeraeumung = null, $kleiner10Kmh = null, $selbstvermietung = null, $landForstwirtschaft = null, $oldtimer = null, $aufbauLkw = null)
    {
        $this
            ->setZulassungsbezirk($zulassungsbezirk)
            ->setKfzArt($kfzArt)
            ->setVerwendungsart($verwendungsart)
            ->setVerwendung($verwendung)
            ->setMarkeLkw($markeLkw)
            ->setTypeAusfuehrung($typeAusfuehrung)
            ->setFirmenfahrzeug($firmenfahrzeug)
            ->setBauartgeschwindigkeit($bauartgeschwindigkeit)
            ->setErstzulassung($erstzulassung)
            ->setLeistungKW($leistungKW)
            ->setHubraum($hubraum)
            ->setAnzahlPlaetze($anzahlPlaetze)
            ->setEigengewicht($eigengewicht)
            ->setGesamtgewichtLkw($gesamtgewichtLkw)
            ->setNutzlastLkw($nutzlastLkw)
            ->setListenpreis($listenpreis)
            ->setKaufpreis($kaufpreis)
            ->setAntriebsart($antriebsart)
            ->setBefreiungsgrund($befreiungsgrund)
            ->setGueterbefoerderungLkw($gueterbefoerderungLkw)
            ->setGefaehrlicheGueter($gefaehrlicheGueter)
            ->setOhneKennzeichen($ohneKennzeichen)
            ->setSchneeraeumung($schneeraeumung)
            ->setKleiner10Kmh($kleiner10Kmh)
            ->setSelbstvermietung($selbstvermietung)
            ->setLandForstwirtschaft($landForstwirtschaft)
            ->setOldtimer($oldtimer)
            ->setAufbauLkw($aufbauLkw);
    }
    /**
     * Get zulassungsbezirk value
     * @return string|null
     */
    public function getZulassungsbezirk()
    {
        return $this->zulassungsbezirk;
    }
    /**
     * Set zulassungsbezirk value
     * @uses \EnumType\ZulassungsbezirkType::valueIsValid()
     * @uses \EnumType\ZulassungsbezirkType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $zulassungsbezirk
     * @return \StructType\FahrzeugdatenLkwType
     */
    public function setZulassungsbezirk($zulassungsbezirk = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ZulassungsbezirkType::valueIsValid($zulassungsbezirk)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ZulassungsbezirkType', is_array($zulassungsbezirk) ? implode(', ', $zulassungsbezirk) : var_export($zulassungsbezirk, true), implode(', ', \EnumType\ZulassungsbezirkType::getValidValues())), __LINE__);
        }
        $this->zulassungsbezirk = $zulassungsbezirk;
        return $this;
    }
    /**
     * Get kfzArt value
     * @return string|null
     */
    public function getKfzArt()
    {
        return $this->kfzArt;
    }
    /**
     * Set kfzArt value
     * @uses \EnumType\KfzArtType::valueIsValid()
     * @uses \EnumType\KfzArtType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $kfzArt
     * @return \StructType\FahrzeugdatenLkwType
     */
    public function setKfzArt($kfzArt = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\KfzArtType::valueIsValid($kfzArt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\KfzArtType', is_array($kfzArt) ? implode(', ', $kfzArt) : var_export($kfzArt, true), implode(', ', \EnumType\KfzArtType::getValidValues())), __LINE__);
        }
        $this->kfzArt = $kfzArt;
        return $this;
    }
    /**
     * Get verwendungsart value
     * @return string|null
     */
    public function getVerwendungsart()
    {
        return $this->verwendungsart;
    }
    /**
     * Set verwendungsart value
     * @uses \EnumType\KfzVerwendungType::valueIsValid()
     * @uses \EnumType\KfzVerwendungType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $verwendungsart
     * @return \StructType\FahrzeugdatenLkwType
     */
    public function setVerwendungsart($verwendungsart = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\KfzVerwendungType::valueIsValid($verwendungsart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\KfzVerwendungType', is_array($verwendungsart) ? implode(', ', $verwendungsart) : var_export($verwendungsart, true), implode(', ', \EnumType\KfzVerwendungType::getValidValues())), __LINE__);
        }
        $this->verwendungsart = $verwendungsart;
        return $this;
    }
    /**
     * Get verwendung value
     * @return string|null
     */
    public function getVerwendung()
    {
        return $this->verwendung;
    }
    /**
     * Set verwendung value
     * @uses \EnumType\KfzVerwendung2Type::valueIsValid()
     * @uses \EnumType\KfzVerwendung2Type::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $verwendung
     * @return \StructType\FahrzeugdatenLkwType
     */
    public function setVerwendung($verwendung = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\KfzVerwendung2Type::valueIsValid($verwendung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\KfzVerwendung2Type', is_array($verwendung) ? implode(', ', $verwendung) : var_export($verwendung, true), implode(', ', \EnumType\KfzVerwendung2Type::getValidValues())), __LINE__);
        }
        $this->verwendung = $verwendung;
        return $this;
    }
    /**
     * Get markeLkw value
     * @return string|null
     */
    public function getMarkeLkw()
    {
        return $this->markeLkw;
    }
    /**
     * Set markeLkw value
     * @param string $markeLkw
     * @return \StructType\FahrzeugdatenLkwType
     */
    public function setMarkeLkw($markeLkw = null)
    {
        // validation for constraint: string
        if (!is_null($markeLkw) && !is_string($markeLkw)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($markeLkw, true), gettype($markeLkw)), __LINE__);
        }
        $this->markeLkw = $markeLkw;
        return $this;
    }
    /**
     * Get typeAusfuehrung value
     * @return string|null
     */
    public function getTypeAusfuehrung()
    {
        return $this->typeAusfuehrung;
    }
    /**
     * Set typeAusfuehrung value
     * @param string $typeAusfuehrung
     * @return \StructType\FahrzeugdatenLkwType
     */
    public function setTypeAusfuehrung($typeAusfuehrung = null)
    {
        // validation for constraint: string
        if (!is_null($typeAusfuehrung) && !is_string($typeAusfuehrung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeAusfuehrung, true), gettype($typeAusfuehrung)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($typeAusfuehrung) && mb_strlen($typeAusfuehrung) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($typeAusfuehrung)), __LINE__);
        }
        $this->typeAusfuehrung = $typeAusfuehrung;
        return $this;
    }
    /**
     * Get firmenfahrzeug value
     * @return string|null
     */
    public function getFirmenfahrzeug()
    {
        return $this->firmenfahrzeug;
    }
    /**
     * Set firmenfahrzeug value
     * @uses \EnumType\JaNeinType::valueIsValid()
     * @uses \EnumType\JaNeinType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $firmenfahrzeug
     * @return \StructType\FahrzeugdatenLkwType
     */
    public function setFirmenfahrzeug($firmenfahrzeug = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JaNeinType::valueIsValid($firmenfahrzeug)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JaNeinType', is_array($firmenfahrzeug) ? implode(', ', $firmenfahrzeug) : var_export($firmenfahrzeug, true), implode(', ', \EnumType\JaNeinType::getValidValues())), __LINE__);
        }
        $this->firmenfahrzeug = $firmenfahrzeug;
        return $this;
    }
    /**
     * Get bauartgeschwindigkeit value
     * @return int|null
     */
    public function getBauartgeschwindigkeit()
    {
        return $this->bauartgeschwindigkeit;
    }
    /**
     * Set bauartgeschwindigkeit value
     * @param int $bauartgeschwindigkeit
     * @return \StructType\FahrzeugdatenLkwType
     */
    public function setBauartgeschwindigkeit($bauartgeschwindigkeit = null)
    {
        // validation for constraint: int
        if (!is_null($bauartgeschwindigkeit) && !(is_int($bauartgeschwindigkeit) || ctype_digit($bauartgeschwindigkeit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bauartgeschwindigkeit, true), gettype($bauartgeschwindigkeit)), __LINE__);
        }
        $this->bauartgeschwindigkeit = $bauartgeschwindigkeit;
        return $this;
    }
    /**
     * Get erstzulassung value
     * @return string|null
     */
    public function getErstzulassung()
    {
        return $this->erstzulassung;
    }
    /**
     * Set erstzulassung value
     * @param string $erstzulassung
     * @return \StructType\FahrzeugdatenLkwType
     */
    public function setErstzulassung($erstzulassung = null)
    {
        // validation for constraint: string
        if (!is_null($erstzulassung) && !is_string($erstzulassung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($erstzulassung, true), gettype($erstzulassung)), __LINE__);
        }
        $this->erstzulassung = $erstzulassung;
        return $this;
    }
    /**
     * Get leistungKW value
     * @return int|null
     */
    public function getLeistungKW()
    {
        return $this->leistungKW;
    }
    /**
     * Set leistungKW value
     * @param int $leistungKW
     * @return \StructType\FahrzeugdatenLkwType
     */
    public function setLeistungKW($leistungKW = null)
    {
        // validation for constraint: int
        if (!is_null($leistungKW) && !(is_int($leistungKW) || ctype_digit($leistungKW))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($leistungKW, true), gettype($leistungKW)), __LINE__);
        }
        $this->leistungKW = $leistungKW;
        return $this;
    }
    /**
     * Get hubraum value
     * @return int|null
     */
    public function getHubraum()
    {
        return $this->hubraum;
    }
    /**
     * Set hubraum value
     * @param int $hubraum
     * @return \StructType\FahrzeugdatenLkwType
     */
    public function setHubraum($hubraum = null)
    {
        // validation for constraint: int
        if (!is_null($hubraum) && !(is_int($hubraum) || ctype_digit($hubraum))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($hubraum, true), gettype($hubraum)), __LINE__);
        }
        $this->hubraum = $hubraum;
        return $this;
    }
    /**
     * Get anzahlPlaetze value
     * @return int|null
     */
    public function getAnzahlPlaetze()
    {
        return $this->anzahlPlaetze;
    }
    /**
     * Set anzahlPlaetze value
     * @param int $anzahlPlaetze
     * @return \StructType\FahrzeugdatenLkwType
     */
    public function setAnzahlPlaetze($anzahlPlaetze = null)
    {
        // validation for constraint: int
        if (!is_null($anzahlPlaetze) && !(is_int($anzahlPlaetze) || ctype_digit($anzahlPlaetze))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anzahlPlaetze, true), gettype($anzahlPlaetze)), __LINE__);
        }
        $this->anzahlPlaetze = $anzahlPlaetze;
        return $this;
    }
    /**
     * Get eigengewicht value
     * @return int|null
     */
    public function getEigengewicht()
    {
        return $this->eigengewicht;
    }
    /**
     * Set eigengewicht value
     * @param int $eigengewicht
     * @return \StructType\FahrzeugdatenLkwType
     */
    public function setEigengewicht($eigengewicht = null)
    {
        // validation for constraint: int
        if (!is_null($eigengewicht) && !(is_int($eigengewicht) || ctype_digit($eigengewicht))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($eigengewicht, true), gettype($eigengewicht)), __LINE__);
        }
        $this->eigengewicht = $eigengewicht;
        return $this;
    }
    /**
     * Get gesamtgewichtLkw value
     * @return int|null
     */
    public function getGesamtgewichtLkw()
    {
        return $this->gesamtgewichtLkw;
    }
    /**
     * Set gesamtgewichtLkw value
     * @param int $gesamtgewichtLkw
     * @return \StructType\FahrzeugdatenLkwType
     */
    public function setGesamtgewichtLkw($gesamtgewichtLkw = null)
    {
        // validation for constraint: int
        if (!is_null($gesamtgewichtLkw) && !(is_int($gesamtgewichtLkw) || ctype_digit($gesamtgewichtLkw))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($gesamtgewichtLkw, true), gettype($gesamtgewichtLkw)), __LINE__);
        }
        $this->gesamtgewichtLkw = $gesamtgewichtLkw;
        return $this;
    }
    /**
     * Get nutzlastLkw value
     * @return int|null
     */
    public function getNutzlastLkw()
    {
        return $this->nutzlastLkw;
    }
    /**
     * Set nutzlastLkw value
     * @param int $nutzlastLkw
     * @return \StructType\FahrzeugdatenLkwType
     */
    public function setNutzlastLkw($nutzlastLkw = null)
    {
        // validation for constraint: int
        if (!is_null($nutzlastLkw) && !(is_int($nutzlastLkw) || ctype_digit($nutzlastLkw))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nutzlastLkw, true), gettype($nutzlastLkw)), __LINE__);
        }
        $this->nutzlastLkw = $nutzlastLkw;
        return $this;
    }
    /**
     * Get listenpreis value
     * @return int|null
     */
    public function getListenpreis()
    {
        return $this->listenpreis;
    }
    /**
     * Set listenpreis value
     * @param int $listenpreis
     * @return \StructType\FahrzeugdatenLkwType
     */
    public function setListenpreis($listenpreis = null)
    {
        // validation for constraint: int
        if (!is_null($listenpreis) && !(is_int($listenpreis) || ctype_digit($listenpreis))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($listenpreis, true), gettype($listenpreis)), __LINE__);
        }
        $this->listenpreis = $listenpreis;
        return $this;
    }
    /**
     * Get kaufpreis value
     * @return int|null
     */
    public function getKaufpreis()
    {
        return $this->kaufpreis;
    }
    /**
     * Set kaufpreis value
     * @param int $kaufpreis
     * @return \StructType\FahrzeugdatenLkwType
     */
    public function setKaufpreis($kaufpreis = null)
    {
        // validation for constraint: int
        if (!is_null($kaufpreis) && !(is_int($kaufpreis) || ctype_digit($kaufpreis))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kaufpreis, true), gettype($kaufpreis)), __LINE__);
        }
        $this->kaufpreis = $kaufpreis;
        return $this;
    }
    /**
     * Get antriebsart value
     * @return string|null
     */
    public function getAntriebsart()
    {
        return $this->antriebsart;
    }
    /**
     * Set antriebsart value
     * @uses \EnumType\AntriebsartType::valueIsValid()
     * @uses \EnumType\AntriebsartType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $antriebsart
     * @return \StructType\FahrzeugdatenLkwType
     */
    public function setAntriebsart($antriebsart = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AntriebsartType::valueIsValid($antriebsart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AntriebsartType', is_array($antriebsart) ? implode(', ', $antriebsart) : var_export($antriebsart, true), implode(', ', \EnumType\AntriebsartType::getValidValues())), __LINE__);
        }
        $this->antriebsart = $antriebsart;
        return $this;
    }
    /**
     * Get befreiungsgrund value
     * @return string|null
     */
    public function getBefreiungsgrund()
    {
        return $this->befreiungsgrund;
    }
    /**
     * Set befreiungsgrund value
     * @uses \EnumType\BefreiungsgrundType::valueIsValid()
     * @uses \EnumType\BefreiungsgrundType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $befreiungsgrund
     * @return \StructType\FahrzeugdatenLkwType
     */
    public function setBefreiungsgrund($befreiungsgrund = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\BefreiungsgrundType::valueIsValid($befreiungsgrund)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\BefreiungsgrundType', is_array($befreiungsgrund) ? implode(', ', $befreiungsgrund) : var_export($befreiungsgrund, true), implode(', ', \EnumType\BefreiungsgrundType::getValidValues())), __LINE__);
        }
        $this->befreiungsgrund = $befreiungsgrund;
        return $this;
    }
    /**
     * Get gueterbefoerderungLkw value
     * @return string|null
     */
    public function getGueterbefoerderungLkw()
    {
        return $this->gueterbefoerderungLkw;
    }
    /**
     * Set gueterbefoerderungLkw value
     * @uses \EnumType\GueterbefoerderungLkwType::valueIsValid()
     * @uses \EnumType\GueterbefoerderungLkwType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $gueterbefoerderungLkw
     * @return \StructType\FahrzeugdatenLkwType
     */
    public function setGueterbefoerderungLkw($gueterbefoerderungLkw = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\GueterbefoerderungLkwType::valueIsValid($gueterbefoerderungLkw)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\GueterbefoerderungLkwType', is_array($gueterbefoerderungLkw) ? implode(', ', $gueterbefoerderungLkw) : var_export($gueterbefoerderungLkw, true), implode(', ', \EnumType\GueterbefoerderungLkwType::getValidValues())), __LINE__);
        }
        $this->gueterbefoerderungLkw = $gueterbefoerderungLkw;
        return $this;
    }
    /**
     * Get gefaehrlicheGueter value
     * @return string|null
     */
    public function getGefaehrlicheGueter()
    {
        return $this->gefaehrlicheGueter;
    }
    /**
     * Set gefaehrlicheGueter value
     * @uses \EnumType\JaNeinType::valueIsValid()
     * @uses \EnumType\JaNeinType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $gefaehrlicheGueter
     * @return \StructType\FahrzeugdatenLkwType
     */
    public function setGefaehrlicheGueter($gefaehrlicheGueter = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JaNeinType::valueIsValid($gefaehrlicheGueter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JaNeinType', is_array($gefaehrlicheGueter) ? implode(', ', $gefaehrlicheGueter) : var_export($gefaehrlicheGueter, true), implode(', ', \EnumType\JaNeinType::getValidValues())), __LINE__);
        }
        $this->gefaehrlicheGueter = $gefaehrlicheGueter;
        return $this;
    }
    /**
     * Get ohneKennzeichen value
     * @return string|null
     */
    public function getOhneKennzeichen()
    {
        return $this->ohneKennzeichen;
    }
    /**
     * Set ohneKennzeichen value
     * @uses \EnumType\JaNeinType::valueIsValid()
     * @uses \EnumType\JaNeinType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ohneKennzeichen
     * @return \StructType\FahrzeugdatenLkwType
     */
    public function setOhneKennzeichen($ohneKennzeichen = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JaNeinType::valueIsValid($ohneKennzeichen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JaNeinType', is_array($ohneKennzeichen) ? implode(', ', $ohneKennzeichen) : var_export($ohneKennzeichen, true), implode(', ', \EnumType\JaNeinType::getValidValues())), __LINE__);
        }
        $this->ohneKennzeichen = $ohneKennzeichen;
        return $this;
    }
    /**
     * Get schneeraeumung value
     * @return string|null
     */
    public function getSchneeraeumung()
    {
        return $this->schneeraeumung;
    }
    /**
     * Set schneeraeumung value
     * @uses \EnumType\JaNeinType::valueIsValid()
     * @uses \EnumType\JaNeinType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $schneeraeumung
     * @return \StructType\FahrzeugdatenLkwType
     */
    public function setSchneeraeumung($schneeraeumung = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JaNeinType::valueIsValid($schneeraeumung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JaNeinType', is_array($schneeraeumung) ? implode(', ', $schneeraeumung) : var_export($schneeraeumung, true), implode(', ', \EnumType\JaNeinType::getValidValues())), __LINE__);
        }
        $this->schneeraeumung = $schneeraeumung;
        return $this;
    }
    /**
     * Get kleiner10Kmh value
     * @return string|null
     */
    public function getKleiner10Kmh()
    {
        return $this->kleiner10Kmh;
    }
    /**
     * Set kleiner10Kmh value
     * @uses \EnumType\JaNeinType::valueIsValid()
     * @uses \EnumType\JaNeinType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $kleiner10Kmh
     * @return \StructType\FahrzeugdatenLkwType
     */
    public function setKleiner10Kmh($kleiner10Kmh = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JaNeinType::valueIsValid($kleiner10Kmh)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JaNeinType', is_array($kleiner10Kmh) ? implode(', ', $kleiner10Kmh) : var_export($kleiner10Kmh, true), implode(', ', \EnumType\JaNeinType::getValidValues())), __LINE__);
        }
        $this->kleiner10Kmh = $kleiner10Kmh;
        return $this;
    }
    /**
     * Get selbstvermietung value
     * @return string|null
     */
    public function getSelbstvermietung()
    {
        return $this->selbstvermietung;
    }
    /**
     * Set selbstvermietung value
     * @uses \EnumType\JaNeinType::valueIsValid()
     * @uses \EnumType\JaNeinType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $selbstvermietung
     * @return \StructType\FahrzeugdatenLkwType
     */
    public function setSelbstvermietung($selbstvermietung = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JaNeinType::valueIsValid($selbstvermietung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JaNeinType', is_array($selbstvermietung) ? implode(', ', $selbstvermietung) : var_export($selbstvermietung, true), implode(', ', \EnumType\JaNeinType::getValidValues())), __LINE__);
        }
        $this->selbstvermietung = $selbstvermietung;
        return $this;
    }
    /**
     * Get landForstwirtschaft value
     * @return string|null
     */
    public function getLandForstwirtschaft()
    {
        return $this->landForstwirtschaft;
    }
    /**
     * Set landForstwirtschaft value
     * @uses \EnumType\JaNeinType::valueIsValid()
     * @uses \EnumType\JaNeinType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $landForstwirtschaft
     * @return \StructType\FahrzeugdatenLkwType
     */
    public function setLandForstwirtschaft($landForstwirtschaft = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JaNeinType::valueIsValid($landForstwirtschaft)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JaNeinType', is_array($landForstwirtschaft) ? implode(', ', $landForstwirtschaft) : var_export($landForstwirtschaft, true), implode(', ', \EnumType\JaNeinType::getValidValues())), __LINE__);
        }
        $this->landForstwirtschaft = $landForstwirtschaft;
        return $this;
    }
    /**
     * Get oldtimer value
     * @return string|null
     */
    public function getOldtimer()
    {
        return $this->oldtimer;
    }
    /**
     * Set oldtimer value
     * @uses \EnumType\JaNeinType::valueIsValid()
     * @uses \EnumType\JaNeinType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $oldtimer
     * @return \StructType\FahrzeugdatenLkwType
     */
    public function setOldtimer($oldtimer = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JaNeinType::valueIsValid($oldtimer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JaNeinType', is_array($oldtimer) ? implode(', ', $oldtimer) : var_export($oldtimer, true), implode(', ', \EnumType\JaNeinType::getValidValues())), __LINE__);
        }
        $this->oldtimer = $oldtimer;
        return $this;
    }
    /**
     * Get aufbauLkw value
     * @return string|null
     */
    public function getAufbauLkw()
    {
        return $this->aufbauLkw;
    }
    /**
     * Set aufbauLkw value
     * @uses \EnumType\AufbauLkwType::valueIsValid()
     * @uses \EnumType\AufbauLkwType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $aufbauLkw
     * @return \StructType\FahrzeugdatenLkwType
     */
    public function setAufbauLkw($aufbauLkw = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AufbauLkwType::valueIsValid($aufbauLkw)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AufbauLkwType', is_array($aufbauLkw) ? implode(', ', $aufbauLkw) : var_export($aufbauLkw, true), implode(', ', \EnumType\AufbauLkwType::getValidValues())), __LINE__);
        }
        $this->aufbauLkw = $aufbauLkw;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FahrzeugdatenLkwType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
