<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EvpServiceFault StructType
 * Meta information extracted from the WSDL
 * - documentation: Enthält eventuelle Fehlermeldungen + Fehlercode + Fehlertyp
 * @subpackage Structs
 */
class EvpServiceFault extends AbstractStructBase
{
    /**
     * The errorType
     * Meta information extracted from the WSDL
     * - documentation: Errortyp ( 1 = Error, 2 = Warning, 3 = Hinweis)
     * @var int
     */
    public $errorType;
    /**
     * The errorCode
     * Meta information extracted from the WSDL
     * - documentation: Errorcode ( 0 = interner Fehler, 1 = User existiert nicht, 2 = Kunde existiert nicht, 3 = User hat keine Rechte auf Kunde, 4 = BusinessCase existiert nicht, 5 = VersionsNummer zwischen eVP Offline und eVP Online stimmt nicht ueberein
     * @var int
     */
    public $errorCode;
    /**
     * The errorMsg
     * Meta information extracted from the WSDL
     * - documentation: Eine ausgeschriebene Fehlermeldung, für den User
     * @var string
     */
    public $errorMsg;
    /**
     * The deepLink
     * Meta information extracted from the WSDL
     * - documentation: Der Link mit zu dem aufgebauten Objekt zum Check für und durch den User
     * - minOccurs: 0
     * @var string
     */
    public $deepLink;
    /**
     * Constructor method for EvpServiceFault
     * @uses EvpServiceFault::setErrorType()
     * @uses EvpServiceFault::setErrorCode()
     * @uses EvpServiceFault::setErrorMsg()
     * @uses EvpServiceFault::setDeepLink()
     * @param int $errorType
     * @param int $errorCode
     * @param string $errorMsg
     * @param string $deepLink
     */
    public function __construct($errorType = null, $errorCode = null, $errorMsg = null, $deepLink = null)
    {
        $this
            ->setErrorType($errorType)
            ->setErrorCode($errorCode)
            ->setErrorMsg($errorMsg)
            ->setDeepLink($deepLink);
    }
    /**
     * Get errorType value
     * @return int|null
     */
    public function getErrorType()
    {
        return $this->errorType;
    }
    /**
     * Set errorType value
     * @param int $errorType
     * @return \StructType\EvpServiceFault
     */
    public function setErrorType($errorType = null)
    {
        // validation for constraint: int
        if (!is_null($errorType) && !(is_int($errorType) || ctype_digit($errorType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($errorType, true), gettype($errorType)), __LINE__);
        }
        $this->errorType = $errorType;
        return $this;
    }
    /**
     * Get errorCode value
     * @return int|null
     */
    public function getErrorCode()
    {
        return $this->errorCode;
    }
    /**
     * Set errorCode value
     * @param int $errorCode
     * @return \StructType\EvpServiceFault
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: int
        if (!is_null($errorCode) && !(is_int($errorCode) || ctype_digit($errorCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($errorCode, true), gettype($errorCode)), __LINE__);
        }
        $this->errorCode = $errorCode;
        return $this;
    }
    /**
     * Get errorMsg value
     * @return string|null
     */
    public function getErrorMsg()
    {
        return $this->errorMsg;
    }
    /**
     * Set errorMsg value
     * @param string $errorMsg
     * @return \StructType\EvpServiceFault
     */
    public function setErrorMsg($errorMsg = null)
    {
        // validation for constraint: string
        if (!is_null($errorMsg) && !is_string($errorMsg)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMsg, true), gettype($errorMsg)), __LINE__);
        }
        $this->errorMsg = $errorMsg;
        return $this;
    }
    /**
     * Get deepLink value
     * @return string|null
     */
    public function getDeepLink()
    {
        return $this->deepLink;
    }
    /**
     * Set deepLink value
     * @param string $deepLink
     * @return \StructType\EvpServiceFault
     */
    public function setDeepLink($deepLink = null)
    {
        // validation for constraint: string
        if (!is_null($deepLink) && !is_string($deepLink)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deepLink, true), gettype($deepLink)), __LINE__);
        }
        $this->deepLink = $deepLink;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EvpServiceFault
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
