<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EinzelfondsType StructType
 * @subpackage Structs
 */
class EinzelfondsType extends AbstractStructBase
{
    /**
     * The fondsname
     * Meta information extracted from the WSDL
     * - documentation: Der Fondsname muss in der gleichen Schreibweise wie in VPMS kommen
     * @var string
     */
    public $fondsname;
    /**
     * The fondsanteil
     * Meta information extracted from the WSDL
     * - documentation: Die Summe aller Fondsanteile muss 100% ergeben
     * @var float
     */
    public $fondsanteil;
    /**
     * Constructor method for EinzelfondsType
     * @uses EinzelfondsType::setFondsname()
     * @uses EinzelfondsType::setFondsanteil()
     * @param string $fondsname
     * @param float $fondsanteil
     */
    public function __construct($fondsname = null, $fondsanteil = null)
    {
        $this
            ->setFondsname($fondsname)
            ->setFondsanteil($fondsanteil);
    }
    /**
     * Get fondsname value
     * @return string|null
     */
    public function getFondsname()
    {
        return $this->fondsname;
    }
    /**
     * Set fondsname value
     * @param string $fondsname
     * @return \StructType\EinzelfondsType
     */
    public function setFondsname($fondsname = null)
    {
        // validation for constraint: string
        if (!is_null($fondsname) && !is_string($fondsname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fondsname, true), gettype($fondsname)), __LINE__);
        }
        $this->fondsname = $fondsname;
        return $this;
    }
    /**
     * Get fondsanteil value
     * @return float|null
     */
    public function getFondsanteil()
    {
        return $this->fondsanteil;
    }
    /**
     * Set fondsanteil value
     * @param float $fondsanteil
     * @return \StructType\EinzelfondsType
     */
    public function setFondsanteil($fondsanteil = null)
    {
        // validation for constraint: float
        if (!is_null($fondsanteil) && !(is_float($fondsanteil) || is_numeric($fondsanteil))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fondsanteil, true), gettype($fondsanteil)), __LINE__);
        }
        $this->fondsanteil = $fondsanteil;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EinzelfondsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
