<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for deleteUserDataTokensRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Request zum User Token löschen
 * @subpackage Structs
 */
class DeleteUserDataTokensRequest extends AbstractStructBase
{
    /**
     * The login
     * @var \StructType\Login
     */
    public $login;
    /**
     * The tokensToDelete
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var string[]
     */
    public $tokensToDelete;
    /**
     * Constructor method for deleteUserDataTokensRequest
     * @uses DeleteUserDataTokensRequest::setLogin()
     * @uses DeleteUserDataTokensRequest::setTokensToDelete()
     * @param \StructType\Login $login
     * @param string[] $tokensToDelete
     */
    public function __construct(\StructType\Login $login = null, array $tokensToDelete = array())
    {
        $this
            ->setLogin($login)
            ->setTokensToDelete($tokensToDelete);
    }
    /**
     * Get login value
     * @return \StructType\Login|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param \StructType\Login $login
     * @return \StructType\DeleteUserDataTokensRequest
     */
    public function setLogin(\StructType\Login $login = null)
    {
        $this->login = $login;
        return $this;
    }
    /**
     * Get tokensToDelete value
     * @return string[]|null
     */
    public function getTokensToDelete()
    {
        return $this->tokensToDelete;
    }
    /**
     * This method is responsible for validating the values passed to the setTokensToDelete method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTokensToDelete method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTokensToDeleteForArrayConstraintsFromSetTokensToDelete(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $deleteUserDataTokensRequestTokensToDeleteItem) {
            // validation for constraint: itemType
            if (!is_string($deleteUserDataTokensRequestTokensToDeleteItem)) {
                $invalidValues[] = is_object($deleteUserDataTokensRequestTokensToDeleteItem) ? get_class($deleteUserDataTokensRequestTokensToDeleteItem) : sprintf('%s(%s)', gettype($deleteUserDataTokensRequestTokensToDeleteItem), var_export($deleteUserDataTokensRequestTokensToDeleteItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The tokensToDelete property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set tokensToDelete value
     * @throws \InvalidArgumentException
     * @param string[] $tokensToDelete
     * @return \StructType\DeleteUserDataTokensRequest
     */
    public function setTokensToDelete(array $tokensToDelete = array())
    {
        // validation for constraint: array
        if ('' !== ($tokensToDeleteArrayErrorMessage = self::validateTokensToDeleteForArrayConstraintsFromSetTokensToDelete($tokensToDelete))) {
            throw new \InvalidArgumentException($tokensToDeleteArrayErrorMessage, __LINE__);
        }
        $this->tokensToDelete = $tokensToDelete;
        return $this;
    }
    /**
     * Add item to tokensToDelete value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\DeleteUserDataTokensRequest
     */
    public function addToTokensToDelete($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The tokensToDelete property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->tokensToDelete[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DeleteUserDataTokensRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
