<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Customer StructType
 * Meta information extracted from the WSDL
 * - documentation: Kundenobjekt
 * @subpackage Structs
 */
class Customer extends AbstractStructBase
{
    /**
     * The customerID
     * Meta information extracted from the WSDL
     * - documentation: ID des Kunden in der eVP. Alle Geschäftsfälle die zu einem Kunden angelegt werden referenzieren über diese ID. Wird dieses Feld nicht geschickt bedeutet dies, dass in der eVP der Kunde neu anzulegen ist. Eine ID wird dann
     * generiert und im Response zurückgeschickt.
     * - minOccurs: 0
     * @var int
     */
    public $customerID;
    /**
     * The type
     * @var string
     */
    public $type;
    /**
     * The externalCustomerID
     * Meta information extracted from the WSDL
     * - documentation: ID des Kunden im Client-System
     * - base: xsd:string
     * - maxLength: 50
     * @var string
     */
    public $externalCustomerID;
    /**
     * The userID
     * Meta information extracted from the WSDL
     * - documentation: UserID zu der der Kunde gehört. Im Regelfall gleich jener im Login-Objekt.
     * - base: xsd:string
     * - maxLength: 50
     * @var string
     */
    public $userID;
    /**
     * The title
     * Meta information extracted from the WSDL
     * - documentation: Berufs-, oder akademischer Titel des Kunden
     * - base: xsd:string
     * - maxLength: 20
     * - minOccurs: 0
     * @var string
     */
    public $title;
    /**
     * The firstName
     * Meta information extracted from the WSDL
     * - documentation: Vorname für natürliche Personen
     * - base: xsd:string
     * - maxLength: 50
     * - minOccurs: 0
     * @var string
     */
    public $firstName;
    /**
     * The sureName
     * Meta information extracted from the WSDL
     * - documentation: Familien-, Gruppen-, bzw. Firmenname
     * - base: xsd:string
     * - maxLength: 50
     * @var string
     */
    public $sureName;
    /**
     * The birthDate
     * Meta information extracted from the WSDL
     * - documentation: Geburtsdatum bei natürlichen Personen
     * - minOccurs: 0
     * @var string
     */
    public $birthDate;
    /**
     * The profession
     * Meta information extracted from the WSDL
     * - documentation: Beruf bei natürlichen Personen
     * - base: xsd:string
     * - maxLength: 50
     * - minOccurs: 0
     * @var string
     */
    public $profession;
    /**
     * The legalRegistrationNumber
     * Meta information extracted from the WSDL
     * - documentation: Firmenbuchnummer
     * - minOccurs: 0
     * @var string
     */
    public $legalRegistrationNumber;
    /**
     * The rechtsform
     * Meta information extracted from the WSDL
     * - documentation: Wenn die Rechtsform Teil des Namens ist, dann muss diese auch beim Namen angegeben werden. Wenn eine Firmenbuchnummer übergeben wird, wird die Rechtsform aus dem Firmenverzeichnis übernommen - egal, was übergeben wird.
     * - minOccurs: 0
     * @var string
     */
    public $rechtsform;
    /**
     * The ansprechpartner
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TypAnsprechpartner
     */
    public $ansprechpartner;
    /**
     * The customerAddress
     * Meta information extracted from the WSDL
     * - documentation: Adresse des Kunden
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Adress[]
     */
    public $customerAddress;
    /**
     * The customerBankAccount
     * Meta information extracted from the WSDL
     * - documentation: Haupt-Bankverbindung des Kunden
     * - minOccurs: 0
     * @var \StructType\BankAccount
     */
    public $customerBankAccount;
    /**
     * The customerAdditionalBankAccounts
     * Meta information extracted from the WSDL
     * - documentation: Weitere Bankverbindungen des Kunden
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\BankAccount[]
     */
    public $customerAdditionalBankAccounts;
    /**
     * The customerCommunication
     * Meta information extracted from the WSDL
     * - documentation: Telefonnummer, eMail-Adresse
     * - minOccurs: 0
     * @var \StructType\CommunicationDetails
     */
    public $customerCommunication;
    /**
     * The saveData
     * Meta information extracted from the WSDL
     * - documentation: XML-Datenblob
     * @var string
     */
    public $saveData;
    /**
     * The nationality
     * Meta information extracted from the WSDL
     * - documentation: Staatsbürgerschaft
     * - minOccurs: 0
     * @var \StructType\Country
     */
    public $nationality;
    /**
     * The identification
     * Meta information extracted from the WSDL
     * - documentation: Identifikationsnachweis des Kunden
     * - minOccurs: 0
     * @var \StructType\Identification
     */
    public $identification;
    /**
     * The socialInsurance
     * Meta information extracted from the WSDL
     * - documentation: Daten zur Sozialversicherung
     * - minOccurs: 0
     * @var \StructType\SocialInsurance
     */
    public $socialInsurance;
    /**
     * The oeamtcNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $oeamtcNumber;
    /**
     * The oeamtcGisaKurz
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $oeamtcGisaKurz;
    /**
     * The oeamtcGisaLang
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $oeamtcGisaLang;
    /**
     * Constructor method for Customer
     * @uses Customer::setCustomerID()
     * @uses Customer::setType()
     * @uses Customer::setExternalCustomerID()
     * @uses Customer::setUserID()
     * @uses Customer::setTitle()
     * @uses Customer::setFirstName()
     * @uses Customer::setSureName()
     * @uses Customer::setBirthDate()
     * @uses Customer::setProfession()
     * @uses Customer::setLegalRegistrationNumber()
     * @uses Customer::setRechtsform()
     * @uses Customer::setAnsprechpartner()
     * @uses Customer::setCustomerAddress()
     * @uses Customer::setCustomerBankAccount()
     * @uses Customer::setCustomerAdditionalBankAccounts()
     * @uses Customer::setCustomerCommunication()
     * @uses Customer::setSaveData()
     * @uses Customer::setNationality()
     * @uses Customer::setIdentification()
     * @uses Customer::setSocialInsurance()
     * @uses Customer::setOeamtcNumber()
     * @uses Customer::setOeamtcGisaKurz()
     * @uses Customer::setOeamtcGisaLang()
     * @param int $customerID
     * @param string $type
     * @param string $externalCustomerID
     * @param string $userID
     * @param string $title
     * @param string $firstName
     * @param string $sureName
     * @param string $birthDate
     * @param string $profession
     * @param string $legalRegistrationNumber
     * @param string $rechtsform
     * @param \StructType\TypAnsprechpartner $ansprechpartner
     * @param \StructType\Adress[] $customerAddress
     * @param \StructType\BankAccount $customerBankAccount
     * @param \StructType\BankAccount[] $customerAdditionalBankAccounts
     * @param \StructType\CommunicationDetails $customerCommunication
     * @param string $saveData
     * @param \StructType\Country $nationality
     * @param \StructType\Identification $identification
     * @param \StructType\SocialInsurance $socialInsurance
     * @param string $oeamtcNumber
     * @param string $oeamtcGisaKurz
     * @param string $oeamtcGisaLang
     */
    public function __construct($customerID = null, $type = null, $externalCustomerID = null, $userID = null, $title = null, $firstName = null, $sureName = null, $birthDate = null, $profession = null, $legalRegistrationNumber = null, $rechtsform = null, \StructType\TypAnsprechpartner $ansprechpartner = null, array $customerAddress = array(), \StructType\BankAccount $customerBankAccount = null, array $customerAdditionalBankAccounts = array(), \StructType\CommunicationDetails $customerCommunication = null, $saveData = null, \StructType\Country $nationality = null, \StructType\Identification $identification = null, \StructType\SocialInsurance $socialInsurance = null, $oeamtcNumber = null, $oeamtcGisaKurz = null, $oeamtcGisaLang = null)
    {
        $this
            ->setCustomerID($customerID)
            ->setType($type)
            ->setExternalCustomerID($externalCustomerID)
            ->setUserID($userID)
            ->setTitle($title)
            ->setFirstName($firstName)
            ->setSureName($sureName)
            ->setBirthDate($birthDate)
            ->setProfession($profession)
            ->setLegalRegistrationNumber($legalRegistrationNumber)
            ->setRechtsform($rechtsform)
            ->setAnsprechpartner($ansprechpartner)
            ->setCustomerAddress($customerAddress)
            ->setCustomerBankAccount($customerBankAccount)
            ->setCustomerAdditionalBankAccounts($customerAdditionalBankAccounts)
            ->setCustomerCommunication($customerCommunication)
            ->setSaveData($saveData)
            ->setNationality($nationality)
            ->setIdentification($identification)
            ->setSocialInsurance($socialInsurance)
            ->setOeamtcNumber($oeamtcNumber)
            ->setOeamtcGisaKurz($oeamtcGisaKurz)
            ->setOeamtcGisaLang($oeamtcGisaLang);
    }
    /**
     * Get customerID value
     * @return int|null
     */
    public function getCustomerID()
    {
        return $this->customerID;
    }
    /**
     * Set customerID value
     * @param int $customerID
     * @return \StructType\Customer
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: int
        if (!is_null($customerID) && !(is_int($customerID) || ctype_digit($customerID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerID, true), gettype($customerID)), __LINE__);
        }
        $this->customerID = $customerID;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @uses \EnumType\Salutation::valueIsValid()
     * @uses \EnumType\Salutation::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\Customer
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Salutation::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Salutation', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \EnumType\Salutation::getValidValues())), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get externalCustomerID value
     * @return string|null
     */
    public function getExternalCustomerID()
    {
        return $this->externalCustomerID;
    }
    /**
     * Set externalCustomerID value
     * @param string $externalCustomerID
     * @return \StructType\Customer
     */
    public function setExternalCustomerID($externalCustomerID = null)
    {
        // validation for constraint: string
        if (!is_null($externalCustomerID) && !is_string($externalCustomerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalCustomerID, true), gettype($externalCustomerID)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($externalCustomerID) && mb_strlen($externalCustomerID) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($externalCustomerID)), __LINE__);
        }
        $this->externalCustomerID = $externalCustomerID;
        return $this;
    }
    /**
     * Get userID value
     * @return string|null
     */
    public function getUserID()
    {
        return $this->userID;
    }
    /**
     * Set userID value
     * @param string $userID
     * @return \StructType\Customer
     */
    public function setUserID($userID = null)
    {
        // validation for constraint: string
        if (!is_null($userID) && !is_string($userID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userID, true), gettype($userID)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($userID) && mb_strlen($userID) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($userID)), __LINE__);
        }
        $this->userID = $userID;
        return $this;
    }
    /**
     * Get title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->title;
    }
    /**
     * Set title value
     * @param string $title
     * @return \StructType\Customer
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($title) && mb_strlen($title) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($title)), __LINE__);
        }
        $this->title = $title;
        return $this;
    }
    /**
     * Get firstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->firstName;
    }
    /**
     * Set firstName value
     * @param string $firstName
     * @return \StructType\Customer
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($firstName) && mb_strlen($firstName) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($firstName)), __LINE__);
        }
        $this->firstName = $firstName;
        return $this;
    }
    /**
     * Get sureName value
     * @return string|null
     */
    public function getSureName()
    {
        return $this->sureName;
    }
    /**
     * Set sureName value
     * @param string $sureName
     * @return \StructType\Customer
     */
    public function setSureName($sureName = null)
    {
        // validation for constraint: string
        if (!is_null($sureName) && !is_string($sureName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sureName, true), gettype($sureName)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($sureName) && mb_strlen($sureName) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($sureName)), __LINE__);
        }
        $this->sureName = $sureName;
        return $this;
    }
    /**
     * Get birthDate value
     * @return string|null
     */
    public function getBirthDate()
    {
        return $this->birthDate;
    }
    /**
     * Set birthDate value
     * @param string $birthDate
     * @return \StructType\Customer
     */
    public function setBirthDate($birthDate = null)
    {
        // validation for constraint: string
        if (!is_null($birthDate) && !is_string($birthDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($birthDate, true), gettype($birthDate)), __LINE__);
        }
        $this->birthDate = $birthDate;
        return $this;
    }
    /**
     * Get profession value
     * @return string|null
     */
    public function getProfession()
    {
        return $this->profession;
    }
    /**
     * Set profession value
     * @param string $profession
     * @return \StructType\Customer
     */
    public function setProfession($profession = null)
    {
        // validation for constraint: string
        if (!is_null($profession) && !is_string($profession)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($profession, true), gettype($profession)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($profession) && mb_strlen($profession) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($profession)), __LINE__);
        }
        $this->profession = $profession;
        return $this;
    }
    /**
     * Get legalRegistrationNumber value
     * @return string|null
     */
    public function getLegalRegistrationNumber()
    {
        return $this->legalRegistrationNumber;
    }
    /**
     * Set legalRegistrationNumber value
     * @param string $legalRegistrationNumber
     * @return \StructType\Customer
     */
    public function setLegalRegistrationNumber($legalRegistrationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($legalRegistrationNumber) && !is_string($legalRegistrationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($legalRegistrationNumber, true), gettype($legalRegistrationNumber)), __LINE__);
        }
        $this->legalRegistrationNumber = $legalRegistrationNumber;
        return $this;
    }
    /**
     * Get rechtsform value
     * @return string|null
     */
    public function getRechtsform()
    {
        return $this->rechtsform;
    }
    /**
     * Set rechtsform value
     * @uses \EnumType\TypRechtsform::valueIsValid()
     * @uses \EnumType\TypRechtsform::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $rechtsform
     * @return \StructType\Customer
     */
    public function setRechtsform($rechtsform = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TypRechtsform::valueIsValid($rechtsform)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TypRechtsform', is_array($rechtsform) ? implode(', ', $rechtsform) : var_export($rechtsform, true), implode(', ', \EnumType\TypRechtsform::getValidValues())), __LINE__);
        }
        $this->rechtsform = $rechtsform;
        return $this;
    }
    /**
     * Get ansprechpartner value
     * @return \StructType\TypAnsprechpartner|null
     */
    public function getAnsprechpartner()
    {
        return $this->ansprechpartner;
    }
    /**
     * Set ansprechpartner value
     * @param \StructType\TypAnsprechpartner $ansprechpartner
     * @return \StructType\Customer
     */
    public function setAnsprechpartner(\StructType\TypAnsprechpartner $ansprechpartner = null)
    {
        $this->ansprechpartner = $ansprechpartner;
        return $this;
    }
    /**
     * Get customerAddress value
     * @return \StructType\Adress[]|null
     */
    public function getCustomerAddress()
    {
        return $this->customerAddress;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomerAddress method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomerAddress method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomerAddressForArrayConstraintsFromSetCustomerAddress(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerCustomerAddressItem) {
            // validation for constraint: itemType
            if (!$customerCustomerAddressItem instanceof \StructType\Adress) {
                $invalidValues[] = is_object($customerCustomerAddressItem) ? get_class($customerCustomerAddressItem) : sprintf('%s(%s)', gettype($customerCustomerAddressItem), var_export($customerCustomerAddressItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The customerAddress property can only contain items of type \StructType\Adress, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set customerAddress value
     * @throws \InvalidArgumentException
     * @param \StructType\Adress[] $customerAddress
     * @return \StructType\Customer
     */
    public function setCustomerAddress(array $customerAddress = array())
    {
        // validation for constraint: array
        if ('' !== ($customerAddressArrayErrorMessage = self::validateCustomerAddressForArrayConstraintsFromSetCustomerAddress($customerAddress))) {
            throw new \InvalidArgumentException($customerAddressArrayErrorMessage, __LINE__);
        }
        $this->customerAddress = $customerAddress;
        return $this;
    }
    /**
     * Add item to customerAddress value
     * @throws \InvalidArgumentException
     * @param \StructType\Adress $item
     * @return \StructType\Customer
     */
    public function addToCustomerAddress(\StructType\Adress $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Adress) {
            throw new \InvalidArgumentException(sprintf('The customerAddress property can only contain items of type \StructType\Adress, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->customerAddress[] = $item;
        return $this;
    }
    /**
     * Get customerBankAccount value
     * @return \StructType\BankAccount|null
     */
    public function getCustomerBankAccount()
    {
        return $this->customerBankAccount;
    }
    /**
     * Set customerBankAccount value
     * @param \StructType\BankAccount $customerBankAccount
     * @return \StructType\Customer
     */
    public function setCustomerBankAccount(\StructType\BankAccount $customerBankAccount = null)
    {
        $this->customerBankAccount = $customerBankAccount;
        return $this;
    }
    /**
     * Get customerAdditionalBankAccounts value
     * @return \StructType\BankAccount[]|null
     */
    public function getCustomerAdditionalBankAccounts()
    {
        return $this->customerAdditionalBankAccounts;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomerAdditionalBankAccounts method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomerAdditionalBankAccounts method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomerAdditionalBankAccountsForArrayConstraintsFromSetCustomerAdditionalBankAccounts(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerCustomerAdditionalBankAccountsItem) {
            // validation for constraint: itemType
            if (!$customerCustomerAdditionalBankAccountsItem instanceof \StructType\BankAccount) {
                $invalidValues[] = is_object($customerCustomerAdditionalBankAccountsItem) ? get_class($customerCustomerAdditionalBankAccountsItem) : sprintf('%s(%s)', gettype($customerCustomerAdditionalBankAccountsItem), var_export($customerCustomerAdditionalBankAccountsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The customerAdditionalBankAccounts property can only contain items of type \StructType\BankAccount, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set customerAdditionalBankAccounts value
     * @throws \InvalidArgumentException
     * @param \StructType\BankAccount[] $customerAdditionalBankAccounts
     * @return \StructType\Customer
     */
    public function setCustomerAdditionalBankAccounts(array $customerAdditionalBankAccounts = array())
    {
        // validation for constraint: array
        if ('' !== ($customerAdditionalBankAccountsArrayErrorMessage = self::validateCustomerAdditionalBankAccountsForArrayConstraintsFromSetCustomerAdditionalBankAccounts($customerAdditionalBankAccounts))) {
            throw new \InvalidArgumentException($customerAdditionalBankAccountsArrayErrorMessage, __LINE__);
        }
        $this->customerAdditionalBankAccounts = $customerAdditionalBankAccounts;
        return $this;
    }
    /**
     * Add item to customerAdditionalBankAccounts value
     * @throws \InvalidArgumentException
     * @param \StructType\BankAccount $item
     * @return \StructType\Customer
     */
    public function addToCustomerAdditionalBankAccounts(\StructType\BankAccount $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BankAccount) {
            throw new \InvalidArgumentException(sprintf('The customerAdditionalBankAccounts property can only contain items of type \StructType\BankAccount, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->customerAdditionalBankAccounts[] = $item;
        return $this;
    }
    /**
     * Get customerCommunication value
     * @return \StructType\CommunicationDetails|null
     */
    public function getCustomerCommunication()
    {
        return $this->customerCommunication;
    }
    /**
     * Set customerCommunication value
     * @param \StructType\CommunicationDetails $customerCommunication
     * @return \StructType\Customer
     */
    public function setCustomerCommunication(\StructType\CommunicationDetails $customerCommunication = null)
    {
        $this->customerCommunication = $customerCommunication;
        return $this;
    }
    /**
     * Get saveData value
     * @return string|null
     */
    public function getSaveData()
    {
        return $this->saveData;
    }
    /**
     * Set saveData value
     * @param string $saveData
     * @return \StructType\Customer
     */
    public function setSaveData($saveData = null)
    {
        // validation for constraint: string
        if (!is_null($saveData) && !is_string($saveData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($saveData, true), gettype($saveData)), __LINE__);
        }
        $this->saveData = $saveData;
        return $this;
    }
    /**
     * Get nationality value
     * @return \StructType\Country|null
     */
    public function getNationality()
    {
        return $this->nationality;
    }
    /**
     * Set nationality value
     * @param \StructType\Country $nationality
     * @return \StructType\Customer
     */
    public function setNationality(\StructType\Country $nationality = null)
    {
        $this->nationality = $nationality;
        return $this;
    }
    /**
     * Get identification value
     * @return \StructType\Identification|null
     */
    public function getIdentification()
    {
        return $this->identification;
    }
    /**
     * Set identification value
     * @param \StructType\Identification $identification
     * @return \StructType\Customer
     */
    public function setIdentification(\StructType\Identification $identification = null)
    {
        $this->identification = $identification;
        return $this;
    }
    /**
     * Get socialInsurance value
     * @return \StructType\SocialInsurance|null
     */
    public function getSocialInsurance()
    {
        return $this->socialInsurance;
    }
    /**
     * Set socialInsurance value
     * @param \StructType\SocialInsurance $socialInsurance
     * @return \StructType\Customer
     */
    public function setSocialInsurance(\StructType\SocialInsurance $socialInsurance = null)
    {
        $this->socialInsurance = $socialInsurance;
        return $this;
    }
    /**
     * Get oeamtcNumber value
     * @return string|null
     */
    public function getOeamtcNumber()
    {
        return $this->oeamtcNumber;
    }
    /**
     * Set oeamtcNumber value
     * @param string $oeamtcNumber
     * @return \StructType\Customer
     */
    public function setOeamtcNumber($oeamtcNumber = null)
    {
        // validation for constraint: string
        if (!is_null($oeamtcNumber) && !is_string($oeamtcNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oeamtcNumber, true), gettype($oeamtcNumber)), __LINE__);
        }
        $this->oeamtcNumber = $oeamtcNumber;
        return $this;
    }
    /**
     * Get oeamtcGisaKurz value
     * @return string|null
     */
    public function getOeamtcGisaKurz()
    {
        return $this->oeamtcGisaKurz;
    }
    /**
     * Set oeamtcGisaKurz value
     * @param string $oeamtcGisaKurz
     * @return \StructType\Customer
     */
    public function setOeamtcGisaKurz($oeamtcGisaKurz = null)
    {
        // validation for constraint: string
        if (!is_null($oeamtcGisaKurz) && !is_string($oeamtcGisaKurz)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oeamtcGisaKurz, true), gettype($oeamtcGisaKurz)), __LINE__);
        }
        $this->oeamtcGisaKurz = $oeamtcGisaKurz;
        return $this;
    }
    /**
     * Get oeamtcGisaLang value
     * @return string|null
     */
    public function getOeamtcGisaLang()
    {
        return $this->oeamtcGisaLang;
    }
    /**
     * Set oeamtcGisaLang value
     * @param string $oeamtcGisaLang
     * @return \StructType\Customer
     */
    public function setOeamtcGisaLang($oeamtcGisaLang = null)
    {
        // validation for constraint: string
        if (!is_null($oeamtcGisaLang) && !is_string($oeamtcGisaLang)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oeamtcGisaLang, true), gettype($oeamtcGisaLang)), __LINE__);
        }
        $this->oeamtcGisaLang = $oeamtcGisaLang;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Customer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
