<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Contract StructType
 * Meta information extracted from the WSDL
 * - documentation: Vertragsobjekt
 * @subpackage Structs
 */
class Contract extends AbstractStructBase
{
    /**
     * The policy
     * @var \StructType\Policy
     */
    public $policy;
    /**
     * The data
     * @var \StructType\Data
     */
    public $data;
    /**
     * The omdsData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OmdsData
     */
    public $omdsData;
    /**
     * The customers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Customers
     */
    public $customers;
    /**
     * The additionalContractData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AdditionalContractData
     */
    public $additionalContractData;
    /**
     * Constructor method for Contract
     * @uses Contract::setPolicy()
     * @uses Contract::setData()
     * @uses Contract::setOmdsData()
     * @uses Contract::setCustomers()
     * @uses Contract::setAdditionalContractData()
     * @param \StructType\Policy $policy
     * @param \StructType\Data $data
     * @param \StructType\OmdsData $omdsData
     * @param \StructType\Customers $customers
     * @param \StructType\AdditionalContractData $additionalContractData
     */
    public function __construct(\StructType\Policy $policy = null, \StructType\Data $data = null, \StructType\OmdsData $omdsData = null, \StructType\Customers $customers = null, \StructType\AdditionalContractData $additionalContractData = null)
    {
        $this
            ->setPolicy($policy)
            ->setData($data)
            ->setOmdsData($omdsData)
            ->setCustomers($customers)
            ->setAdditionalContractData($additionalContractData);
    }
    /**
     * Get policy value
     * @return \StructType\Policy|null
     */
    public function getPolicy()
    {
        return $this->policy;
    }
    /**
     * Set policy value
     * @param \StructType\Policy $policy
     * @return \StructType\Contract
     */
    public function setPolicy(\StructType\Policy $policy = null)
    {
        $this->policy = $policy;
        return $this;
    }
    /**
     * Get data value
     * @return \StructType\Data|null
     */
    public function getData()
    {
        return $this->data;
    }
    /**
     * Set data value
     * @param \StructType\Data $data
     * @return \StructType\Contract
     */
    public function setData(\StructType\Data $data = null)
    {
        $this->data = $data;
        return $this;
    }
    /**
     * Get omdsData value
     * @return \StructType\OmdsData|null
     */
    public function getOmdsData()
    {
        return $this->omdsData;
    }
    /**
     * Set omdsData value
     * @param \StructType\OmdsData $omdsData
     * @return \StructType\Contract
     */
    public function setOmdsData(\StructType\OmdsData $omdsData = null)
    {
        $this->omdsData = $omdsData;
        return $this;
    }
    /**
     * Get customers value
     * @return \StructType\Customers|null
     */
    public function getCustomers()
    {
        return $this->customers;
    }
    /**
     * Set customers value
     * @param \StructType\Customers $customers
     * @return \StructType\Contract
     */
    public function setCustomers(\StructType\Customers $customers = null)
    {
        $this->customers = $customers;
        return $this;
    }
    /**
     * Get additionalContractData value
     * @return \StructType\AdditionalContractData|null
     */
    public function getAdditionalContractData()
    {
        return $this->additionalContractData;
    }
    /**
     * Set additionalContractData value
     * @param \StructType\AdditionalContractData $additionalContractData
     * @return \StructType\Contract
     */
    public function setAdditionalContractData(\StructType\AdditionalContractData $additionalContractData = null)
    {
        $this->additionalContractData = $additionalContractData;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Contract
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
