<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Contact StructType
 * Meta information extracted from the WSDL
 * - documentation: Kontaktobjekt
 * @subpackage Structs
 */
class Contact extends AbstractStructBase
{
    /**
     * The firstName
     * Meta information extracted from the WSDL
     * - documentation: Vorname für natürliche Personen
     * - base: xsd:string
     * - maxLength: 50
     * - minOccurs: 0
     * @var string
     */
    public $firstName;
    /**
     * The sureName
     * Meta information extracted from the WSDL
     * - documentation: Familien-, Gruppen-, bzw. Firmenname
     * - base: xsd:string
     * - maxLength: 50
     * @var string
     */
    public $sureName;
    /**
     * The customerCommunication
     * Meta information extracted from the WSDL
     * - documentation: Telefonnummer, eMail-Adresse
     * - minOccurs: 0
     * @var \StructType\CommunicationDetails
     */
    public $customerCommunication;
    /**
     * The relationshipToCustomer
     * Meta information extracted from the WSDL
     * - documentation: Beziehung der Kontaktperson zum Versicherungsnehmer/Antragsteller
     * - base: xsd:string
     * - maxLength: 30
     * - minOccurs: 0
     * @var string
     */
    public $relationshipToCustomer;
    /**
     * Constructor method for Contact
     * @uses Contact::setFirstName()
     * @uses Contact::setSureName()
     * @uses Contact::setCustomerCommunication()
     * @uses Contact::setRelationshipToCustomer()
     * @param string $firstName
     * @param string $sureName
     * @param \StructType\CommunicationDetails $customerCommunication
     * @param string $relationshipToCustomer
     */
    public function __construct($firstName = null, $sureName = null, \StructType\CommunicationDetails $customerCommunication = null, $relationshipToCustomer = null)
    {
        $this
            ->setFirstName($firstName)
            ->setSureName($sureName)
            ->setCustomerCommunication($customerCommunication)
            ->setRelationshipToCustomer($relationshipToCustomer);
    }
    /**
     * Get firstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->firstName;
    }
    /**
     * Set firstName value
     * @param string $firstName
     * @return \StructType\Contact
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($firstName) && mb_strlen($firstName) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($firstName)), __LINE__);
        }
        $this->firstName = $firstName;
        return $this;
    }
    /**
     * Get sureName value
     * @return string|null
     */
    public function getSureName()
    {
        return $this->sureName;
    }
    /**
     * Set sureName value
     * @param string $sureName
     * @return \StructType\Contact
     */
    public function setSureName($sureName = null)
    {
        // validation for constraint: string
        if (!is_null($sureName) && !is_string($sureName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sureName, true), gettype($sureName)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($sureName) && mb_strlen($sureName) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($sureName)), __LINE__);
        }
        $this->sureName = $sureName;
        return $this;
    }
    /**
     * Get customerCommunication value
     * @return \StructType\CommunicationDetails|null
     */
    public function getCustomerCommunication()
    {
        return $this->customerCommunication;
    }
    /**
     * Set customerCommunication value
     * @param \StructType\CommunicationDetails $customerCommunication
     * @return \StructType\Contact
     */
    public function setCustomerCommunication(\StructType\CommunicationDetails $customerCommunication = null)
    {
        $this->customerCommunication = $customerCommunication;
        return $this;
    }
    /**
     * Get relationshipToCustomer value
     * @return string|null
     */
    public function getRelationshipToCustomer()
    {
        return $this->relationshipToCustomer;
    }
    /**
     * Set relationshipToCustomer value
     * @param string $relationshipToCustomer
     * @return \StructType\Contact
     */
    public function setRelationshipToCustomer($relationshipToCustomer = null)
    {
        // validation for constraint: string
        if (!is_null($relationshipToCustomer) && !is_string($relationshipToCustomer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relationshipToCustomer, true), gettype($relationshipToCustomer)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($relationshipToCustomer) && mb_strlen($relationshipToCustomer) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($relationshipToCustomer)), __LINE__);
        }
        $this->relationshipToCustomer = $relationshipToCustomer;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Contact
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
