<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Consultation_ContractData StructType
 * Meta information extracted from the WSDL
 * - documentation: Detaildatenobjekt der Antragsdaten für eine Beratung
 * @subpackage Structs
 */
class Consultation_ContractData extends AbstractStructBase
{
    /**
     * The section
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $section;
    /**
     * The agentNumber
     * Meta information extracted from the WSDL
     * - documentation: Vermittlernummer z.B: 123456
     * - base: xsd:string
     * - maxLength: 6
     * - minOccurs: 0
     * @var string
     */
    public $agentNumber;
    /**
     * The directorateID
     * Meta information extracted from the WSDL
     * - documentation: Regionaldirektion 0=Wien 2=Niederösterreich 3=Oberösterreich 4=Salzburg 5=Tirol 6=Vorarlberg 7=Burgenland 8=Steiermark 9=Kärnten/Osttirol
     * - minOccurs: 0
     * @var int
     */
    public $directorateID;
    /**
     * The branchID
     * Meta information extracted from the WSDL
     * - documentation: MPS/Geschäftsstelle abhängig von Regionaldirektion z.B. : 0.1320=MPS 1 0.1340=MPS 2 0.1360=MPS 3 0.1380=MPS 4 0.200=Donaufelderhof 0.300=Favoriten ...
     * - minOccurs: 0
     * @var int
     */
    public $branchID;
    /**
     * The electronicSignature
     * Meta information extracted from the WSDL
     * - documentation: Sollen die Dokumente vor der Übertragung elektronisch unterschrieben werden? (Die Übertragung des Geschäftsfalls muss dann separat angestoßen werden)
     * - minOccurs: 0
     * @var bool
     */
    public $electronicSignature;
    /**
     * Constructor method for Consultation_ContractData
     * @uses Consultation_ContractData::setSection()
     * @uses Consultation_ContractData::setAgentNumber()
     * @uses Consultation_ContractData::setDirectorateID()
     * @uses Consultation_ContractData::setBranchID()
     * @uses Consultation_ContractData::setElectronicSignature()
     * @param string $section
     * @param string $agentNumber
     * @param int $directorateID
     * @param int $branchID
     * @param bool $electronicSignature
     */
    public function __construct($section = null, $agentNumber = null, $directorateID = null, $branchID = null, $electronicSignature = null)
    {
        $this
            ->setSection($section)
            ->setAgentNumber($agentNumber)
            ->setDirectorateID($directorateID)
            ->setBranchID($branchID)
            ->setElectronicSignature($electronicSignature);
    }
    /**
     * Get section value
     * @return string|null
     */
    public function getSection()
    {
        return $this->section;
    }
    /**
     * Set section value
     * @uses \EnumType\Section::valueIsValid()
     * @uses \EnumType\Section::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $section
     * @return \StructType\Consultation_ContractData
     */
    public function setSection($section = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Section::valueIsValid($section)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Section', is_array($section) ? implode(', ', $section) : var_export($section, true), implode(', ', \EnumType\Section::getValidValues())), __LINE__);
        }
        $this->section = $section;
        return $this;
    }
    /**
     * Get agentNumber value
     * @return string|null
     */
    public function getAgentNumber()
    {
        return $this->agentNumber;
    }
    /**
     * Set agentNumber value
     * @param string $agentNumber
     * @return \StructType\Consultation_ContractData
     */
    public function setAgentNumber($agentNumber = null)
    {
        // validation for constraint: string
        if (!is_null($agentNumber) && !is_string($agentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agentNumber, true), gettype($agentNumber)), __LINE__);
        }
        // validation for constraint: maxLength(6)
        if (!is_null($agentNumber) && mb_strlen($agentNumber) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 6', mb_strlen($agentNumber)), __LINE__);
        }
        $this->agentNumber = $agentNumber;
        return $this;
    }
    /**
     * Get directorateID value
     * @return int|null
     */
    public function getDirectorateID()
    {
        return $this->directorateID;
    }
    /**
     * Set directorateID value
     * @param int $directorateID
     * @return \StructType\Consultation_ContractData
     */
    public function setDirectorateID($directorateID = null)
    {
        // validation for constraint: int
        if (!is_null($directorateID) && !(is_int($directorateID) || ctype_digit($directorateID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($directorateID, true), gettype($directorateID)), __LINE__);
        }
        $this->directorateID = $directorateID;
        return $this;
    }
    /**
     * Get branchID value
     * @return int|null
     */
    public function getBranchID()
    {
        return $this->branchID;
    }
    /**
     * Set branchID value
     * @param int $branchID
     * @return \StructType\Consultation_ContractData
     */
    public function setBranchID($branchID = null)
    {
        // validation for constraint: int
        if (!is_null($branchID) && !(is_int($branchID) || ctype_digit($branchID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($branchID, true), gettype($branchID)), __LINE__);
        }
        $this->branchID = $branchID;
        return $this;
    }
    /**
     * Get electronicSignature value
     * @return bool|null
     */
    public function getElectronicSignature()
    {
        return $this->electronicSignature;
    }
    /**
     * Set electronicSignature value
     * @param bool $electronicSignature
     * @return \StructType\Consultation_ContractData
     */
    public function setElectronicSignature($electronicSignature = null)
    {
        // validation for constraint: boolean
        if (!is_null($electronicSignature) && !is_bool($electronicSignature)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($electronicSignature, true), gettype($electronicSignature)), __LINE__);
        }
        $this->electronicSignature = $electronicSignature;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Consultation_ContractData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
