<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CommunicationDetails StructType
 * Meta information extracted from the WSDL
 * - documentation: Kommunikationseinträge
 * @subpackage Structs
 */
class CommunicationDetails extends AbstractStructBase
{
    /**
     * The telephone
     * Meta information extracted from the WSDL
     * - documentation: Telefonnummer
     * - base: xsd:string
     * - maxLength: 50
     * @var string
     */
    public $telephone;
    /**
     * The fax
     * Meta information extracted from the WSDL
     * - documentation: Faxnummer
     * - base: xsd:string
     * - maxLength: 50
     * - minOccurs: 0
     * @var string
     */
    public $fax;
    /**
     * The email
     * Meta information extracted from the WSDL
     * - documentation: eMail-Adresse
     * - base: xsd:string
     * - maxLength: 50
     * - minOccurs: 0
     * @var string
     */
    public $email;
    /**
     * Constructor method for CommunicationDetails
     * @uses CommunicationDetails::setTelephone()
     * @uses CommunicationDetails::setFax()
     * @uses CommunicationDetails::setEmail()
     * @param string $telephone
     * @param string $fax
     * @param string $email
     */
    public function __construct($telephone = null, $fax = null, $email = null)
    {
        $this
            ->setTelephone($telephone)
            ->setFax($fax)
            ->setEmail($email);
    }
    /**
     * Get telephone value
     * @return string|null
     */
    public function getTelephone()
    {
        return $this->telephone;
    }
    /**
     * Set telephone value
     * @param string $telephone
     * @return \StructType\CommunicationDetails
     */
    public function setTelephone($telephone = null)
    {
        // validation for constraint: string
        if (!is_null($telephone) && !is_string($telephone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($telephone, true), gettype($telephone)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($telephone) && mb_strlen($telephone) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($telephone)), __LINE__);
        }
        $this->telephone = $telephone;
        return $this;
    }
    /**
     * Get fax value
     * @return string|null
     */
    public function getFax()
    {
        return $this->fax;
    }
    /**
     * Set fax value
     * @param string $fax
     * @return \StructType\CommunicationDetails
     */
    public function setFax($fax = null)
    {
        // validation for constraint: string
        if (!is_null($fax) && !is_string($fax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fax, true), gettype($fax)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($fax) && mb_strlen($fax) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($fax)), __LINE__);
        }
        $this->fax = $fax;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \StructType\CommunicationDetails
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($email) && mb_strlen($email) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CommunicationDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
