<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ClaimentFirma StructType
 * @subpackage Structs
 */
class ClaimentFirma extends AbstractStructBase
{
    /**
     * The name
     * @var string
     */
    public $name;
    /**
     * The adresse
     * @var \StructType\Adress
     */
    public $adresse;
    /**
     * The claimentContactData
     * @var \StructType\ClaimentContactData
     */
    public $claimentContactData;
    /**
     * Constructor method for ClaimentFirma
     * @uses ClaimentFirma::setName()
     * @uses ClaimentFirma::setAdresse()
     * @uses ClaimentFirma::setClaimentContactData()
     * @param string $name
     * @param \StructType\Adress $adresse
     * @param \StructType\ClaimentContactData $claimentContactData
     */
    public function __construct($name = null, \StructType\Adress $adresse = null, \StructType\ClaimentContactData $claimentContactData = null)
    {
        $this
            ->setName($name)
            ->setAdresse($adresse)
            ->setClaimentContactData($claimentContactData);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\ClaimentFirma
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get adresse value
     * @return \StructType\Adress|null
     */
    public function getAdresse()
    {
        return $this->adresse;
    }
    /**
     * Set adresse value
     * @param \StructType\Adress $adresse
     * @return \StructType\ClaimentFirma
     */
    public function setAdresse(\StructType\Adress $adresse = null)
    {
        $this->adresse = $adresse;
        return $this;
    }
    /**
     * Get claimentContactData value
     * @return \StructType\ClaimentContactData|null
     */
    public function getClaimentContactData()
    {
        return $this->claimentContactData;
    }
    /**
     * Set claimentContactData value
     * @param \StructType\ClaimentContactData $claimentContactData
     * @return \StructType\ClaimentFirma
     */
    public function setClaimentContactData(\StructType\ClaimentContactData $claimentContactData = null)
    {
        $this->claimentContactData = $claimentContactData;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ClaimentFirma
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
