<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ClaimentContactData StructType
 * @subpackage Structs
 */
class ClaimentContactData extends AbstractStructBase
{
    /**
     * The telefon
     * @var string
     */
    public $telefon;
    /**
     * The eMail
     * @var string
     */
    public $eMail;
    /**
     * Constructor method for ClaimentContactData
     * @uses ClaimentContactData::setTelefon()
     * @uses ClaimentContactData::setEMail()
     * @param string $telefon
     * @param string $eMail
     */
    public function __construct($telefon = null, $eMail = null)
    {
        $this
            ->setTelefon($telefon)
            ->setEMail($eMail);
    }
    /**
     * Get telefon value
     * @return string|null
     */
    public function getTelefon()
    {
        return $this->telefon;
    }
    /**
     * Set telefon value
     * @param string $telefon
     * @return \StructType\ClaimentContactData
     */
    public function setTelefon($telefon = null)
    {
        // validation for constraint: string
        if (!is_null($telefon) && !is_string($telefon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($telefon, true), gettype($telefon)), __LINE__);
        }
        $this->telefon = $telefon;
        return $this;
    }
    /**
     * Get eMail value
     * @return string|null
     */
    public function getEMail()
    {
        return $this->eMail;
    }
    /**
     * Set eMail value
     * @param string $eMail
     * @return \StructType\ClaimentContactData
     */
    public function setEMail($eMail = null)
    {
        // validation for constraint: string
        if (!is_null($eMail) && !is_string($eMail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eMail, true), gettype($eMail)), __LINE__);
        }
        $this->eMail = $eMail;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ClaimentContactData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
