<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Claim StructType
 * Meta information extracted from the WSDL
 * - documentation: Schaden
 * @subpackage Structs
 */
class Claim extends AbstractStructBase
{
    /**
     * The claimState
     * Meta information extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $claimState;
    /**
     * The claimNumber
     * @var string
     */
    public $claimNumber;
    /**
     * The policyNumber
     * @var string
     */
    public $policyNumber;
    /**
     * The policyType
     * @var string
     */
    public $policyType;
    /**
     * The policyTypeFull
     * @var string
     */
    public $policyTypeFull;
    /**
     * The claimDate
     * @var string
     */
    public $claimDate;
    /**
     * The claimDateDone
     * @var string
     */
    public $claimDateDone;
    /**
     * The claimPayment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $claimPayment;
    /**
     * The note
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $note;
    /**
     * Constructor method for Claim
     * @uses Claim::setClaimState()
     * @uses Claim::setClaimNumber()
     * @uses Claim::setPolicyNumber()
     * @uses Claim::setPolicyType()
     * @uses Claim::setPolicyTypeFull()
     * @uses Claim::setClaimDate()
     * @uses Claim::setClaimDateDone()
     * @uses Claim::setClaimPayment()
     * @uses Claim::setNote()
     * @param string $claimState
     * @param string $claimNumber
     * @param string $policyNumber
     * @param string $policyType
     * @param string $policyTypeFull
     * @param string $claimDate
     * @param string $claimDateDone
     * @param float $claimPayment
     * @param string $note
     */
    public function __construct($claimState = null, $claimNumber = null, $policyNumber = null, $policyType = null, $policyTypeFull = null, $claimDate = null, $claimDateDone = null, $claimPayment = null, $note = null)
    {
        $this
            ->setClaimState($claimState)
            ->setClaimNumber($claimNumber)
            ->setPolicyNumber($policyNumber)
            ->setPolicyType($policyType)
            ->setPolicyTypeFull($policyTypeFull)
            ->setClaimDate($claimDate)
            ->setClaimDateDone($claimDateDone)
            ->setClaimPayment($claimPayment)
            ->setNote($note);
    }
    /**
     * Get claimState value
     * @return string
     */
    public function getClaimState()
    {
        return $this->claimState;
    }
    /**
     * Set claimState value
     * @uses \EnumType\ClaimType::valueIsValid()
     * @uses \EnumType\ClaimType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $claimState
     * @return \StructType\Claim
     */
    public function setClaimState($claimState = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ClaimType::valueIsValid($claimState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ClaimType', is_array($claimState) ? implode(', ', $claimState) : var_export($claimState, true), implode(', ', \EnumType\ClaimType::getValidValues())), __LINE__);
        }
        $this->claimState = $claimState;
        return $this;
    }
    /**
     * Get claimNumber value
     * @return string|null
     */
    public function getClaimNumber()
    {
        return $this->claimNumber;
    }
    /**
     * Set claimNumber value
     * @param string $claimNumber
     * @return \StructType\Claim
     */
    public function setClaimNumber($claimNumber = null)
    {
        // validation for constraint: string
        if (!is_null($claimNumber) && !is_string($claimNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($claimNumber, true), gettype($claimNumber)), __LINE__);
        }
        $this->claimNumber = $claimNumber;
        return $this;
    }
    /**
     * Get policyNumber value
     * @return string|null
     */
    public function getPolicyNumber()
    {
        return $this->policyNumber;
    }
    /**
     * Set policyNumber value
     * @param string $policyNumber
     * @return \StructType\Claim
     */
    public function setPolicyNumber($policyNumber = null)
    {
        // validation for constraint: string
        if (!is_null($policyNumber) && !is_string($policyNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($policyNumber, true), gettype($policyNumber)), __LINE__);
        }
        $this->policyNumber = $policyNumber;
        return $this;
    }
    /**
     * Get policyType value
     * @return string|null
     */
    public function getPolicyType()
    {
        return $this->policyType;
    }
    /**
     * Set policyType value
     * @uses \EnumType\PolicyType::valueIsValid()
     * @uses \EnumType\PolicyType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $policyType
     * @return \StructType\Claim
     */
    public function setPolicyType($policyType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PolicyType::valueIsValid($policyType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PolicyType', is_array($policyType) ? implode(', ', $policyType) : var_export($policyType, true), implode(', ', \EnumType\PolicyType::getValidValues())), __LINE__);
        }
        $this->policyType = $policyType;
        return $this;
    }
    /**
     * Get policyTypeFull value
     * @return string|null
     */
    public function getPolicyTypeFull()
    {
        return $this->policyTypeFull;
    }
    /**
     * Set policyTypeFull value
     * @param string $policyTypeFull
     * @return \StructType\Claim
     */
    public function setPolicyTypeFull($policyTypeFull = null)
    {
        // validation for constraint: string
        if (!is_null($policyTypeFull) && !is_string($policyTypeFull)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($policyTypeFull, true), gettype($policyTypeFull)), __LINE__);
        }
        $this->policyTypeFull = $policyTypeFull;
        return $this;
    }
    /**
     * Get claimDate value
     * @return string|null
     */
    public function getClaimDate()
    {
        return $this->claimDate;
    }
    /**
     * Set claimDate value
     * @param string $claimDate
     * @return \StructType\Claim
     */
    public function setClaimDate($claimDate = null)
    {
        // validation for constraint: string
        if (!is_null($claimDate) && !is_string($claimDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($claimDate, true), gettype($claimDate)), __LINE__);
        }
        $this->claimDate = $claimDate;
        return $this;
    }
    /**
     * Get claimDateDone value
     * @return string|null
     */
    public function getClaimDateDone()
    {
        return $this->claimDateDone;
    }
    /**
     * Set claimDateDone value
     * @param string $claimDateDone
     * @return \StructType\Claim
     */
    public function setClaimDateDone($claimDateDone = null)
    {
        // validation for constraint: string
        if (!is_null($claimDateDone) && !is_string($claimDateDone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($claimDateDone, true), gettype($claimDateDone)), __LINE__);
        }
        $this->claimDateDone = $claimDateDone;
        return $this;
    }
    /**
     * Get claimPayment value
     * @return float|null
     */
    public function getClaimPayment()
    {
        return $this->claimPayment;
    }
    /**
     * Set claimPayment value
     * @param float $claimPayment
     * @return \StructType\Claim
     */
    public function setClaimPayment($claimPayment = null)
    {
        // validation for constraint: float
        if (!is_null($claimPayment) && !(is_float($claimPayment) || is_numeric($claimPayment))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($claimPayment, true), gettype($claimPayment)), __LINE__);
        }
        $this->claimPayment = $claimPayment;
        return $this;
    }
    /**
     * Get note value
     * @return string|null
     */
    public function getNote()
    {
        return $this->note;
    }
    /**
     * Set note value
     * @param string $note
     * @return \StructType\Claim
     */
    public function setNote($note = null)
    {
        // validation for constraint: string
        if (!is_null($note) && !is_string($note)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($note, true), gettype($note)), __LINE__);
        }
        $this->note = $note;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Claim
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
