<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChoiceList StructType
 * @subpackage Structs
 */
class ChoiceList extends AbstractStructBase
{
    /**
     * The attribute
     * @var string
     */
    public $attribute;
    /**
     * The choiceListEntry
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\ChoiceListEntry[]
     */
    public $choiceListEntry;
    /**
     * Constructor method for ChoiceList
     * @uses ChoiceList::setAttribute()
     * @uses ChoiceList::setChoiceListEntry()
     * @param string $attribute
     * @param \StructType\ChoiceListEntry[] $choiceListEntry
     */
    public function __construct($attribute = null, array $choiceListEntry = array())
    {
        $this
            ->setAttribute($attribute)
            ->setChoiceListEntry($choiceListEntry);
    }
    /**
     * Get attribute value
     * @return string|null
     */
    public function getAttribute()
    {
        return $this->attribute;
    }
    /**
     * Set attribute value
     * @param string $attribute
     * @return \StructType\ChoiceList
     */
    public function setAttribute($attribute = null)
    {
        // validation for constraint: string
        if (!is_null($attribute) && !is_string($attribute)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($attribute, true), gettype($attribute)), __LINE__);
        }
        $this->attribute = $attribute;
        return $this;
    }
    /**
     * Get choiceListEntry value
     * @return \StructType\ChoiceListEntry[]|null
     */
    public function getChoiceListEntry()
    {
        return $this->choiceListEntry;
    }
    /**
     * This method is responsible for validating the values passed to the setChoiceListEntry method
     * This method is willingly generated in order to preserve the one-line inline validation within the setChoiceListEntry method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateChoiceListEntryForArrayConstraintsFromSetChoiceListEntry(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $choiceListChoiceListEntryItem) {
            // validation for constraint: itemType
            if (!$choiceListChoiceListEntryItem instanceof \StructType\ChoiceListEntry) {
                $invalidValues[] = is_object($choiceListChoiceListEntryItem) ? get_class($choiceListChoiceListEntryItem) : sprintf('%s(%s)', gettype($choiceListChoiceListEntryItem), var_export($choiceListChoiceListEntryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The choiceListEntry property can only contain items of type \StructType\ChoiceListEntry, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set choiceListEntry value
     * @throws \InvalidArgumentException
     * @param \StructType\ChoiceListEntry[] $choiceListEntry
     * @return \StructType\ChoiceList
     */
    public function setChoiceListEntry(array $choiceListEntry = array())
    {
        // validation for constraint: array
        if ('' !== ($choiceListEntryArrayErrorMessage = self::validateChoiceListEntryForArrayConstraintsFromSetChoiceListEntry($choiceListEntry))) {
            throw new \InvalidArgumentException($choiceListEntryArrayErrorMessage, __LINE__);
        }
        $this->choiceListEntry = $choiceListEntry;
        return $this;
    }
    /**
     * Add item to choiceListEntry value
     * @throws \InvalidArgumentException
     * @param \StructType\ChoiceListEntry $item
     * @return \StructType\ChoiceList
     */
    public function addToChoiceListEntry(\StructType\ChoiceListEntry $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ChoiceListEntry) {
            throw new \InvalidArgumentException(sprintf('The choiceListEntry property can only contain items of type \StructType\ChoiceListEntry, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->choiceListEntry[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ChoiceList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
